/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.networking;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.nerdorg.minehop.Minehop;
import net.nerdorg.minehop.commands.SpectateCommands;
import net.nerdorg.minehop.config.MinehopConfig;
import net.nerdorg.minehop.data.DataManager;
import net.nerdorg.minehop.discord.DiscordIntegration;
import net.nerdorg.minehop.networking.ModMessages;
import net.nerdorg.minehop.replays.ReplayEvents;
import net.nerdorg.minehop.replays.ReplayManager;
import net.nerdorg.minehop.util.Logger;
import net.nerdorg.minehop.util.ZoneUtil;

public class PacketHandler {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void sendConfigToClient(class_3222 player, MinehopConfig config) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeDouble(config.movement.sv_friction);
        buf.writeDouble(config.movement.sv_accelerate);
        buf.writeDouble(config.movement.sv_airaccelerate);
        buf.writeDouble(config.movement.sv_maxairspeed);
        buf.writeDouble(config.movement.speed_mul);
        buf.writeDouble(config.movement.sv_gravity);
        buf.writeDouble(Minehop.speedCapMap.containsKey(player.method_5820()) ? Minehop.speedCapMap.get(player.method_5820()) : 1000000.0);
        DataManager.MapData currentMap = ZoneUtil.getCurrentMap((class_1297)player);
        buf.writeBoolean(currentMap != null && currentMap.hns);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.CONFIG_SYNC_ID, (class_2540)buf);
    }

    public static void updateZone(class_3222 player, int entityId, class_2338 pos1, class_2338 pos2, String name, int check_index) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(entityId);
        buf.method_10807(pos1);
        buf.method_10807(pos2);
        buf.method_10814(name);
        buf.writeInt(check_index);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.ZONE_SYNC_ID, (class_2540)buf);
    }

    public static void sendSelfVToggle(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.SELF_V_TOGGLE, (class_2540)buf);
    }

    public static void sendOtherVToggle(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.OTHER_V_TOGGLE, (class_2540)buf);
    }

    public static void sendReplayVToggle(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.REPLAY_V_TOGGLE, (class_2540)buf);
    }

    public static void sendEfficiency(class_3222 player, double efficiency) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeDouble(efficiency);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.SEND_EFFICIENCY, (class_2540)buf);
    }

    public static void sendSpectators(class_3222 player) {
        List<String> spectators;
        if (SpectateCommands.spectatorList.containsKey(player.method_5820()) && (spectators = SpectateCommands.spectatorList.get(player.method_5820())).size() > 1) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(spectators.size() - 1);
            for (String spectator : spectators) {
                if (spectator.equals(player.method_5820())) continue;
                buf.method_10814(spectator);
            }
            ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.SEND_SPECTATORS, (class_2540)buf);
        }
    }

    private static void handleMapCompletion(class_3222 player, MinecraftServer server, float time) {
        float ping_limit = 300.0f;
        if (!player.method_7337() && !player.method_7325() && Minehop.timerManager.containsKey(player.method_5820())) {
            String map_name = ZoneUtil.getCurrentMapName((class_1297)player);
            HashMap<String, Long> timerMap = Minehop.timerManager.get(player.method_5820());
            List keyList = timerMap.keySet().stream().toList();
            double rawTime = (double)(System.nanoTime() - timerMap.get(keyList.get(0))) / 1.0E9;
            if ((double)time < rawTime + (double)(ping_limit / 1000.0f) && (double)time > rawTime - (double)(ping_limit / 1000.0f)) {
                DataManager.RecordData mapPersonalRecord;
                String formattedNumber = String.format("%.5f", Float.valueOf(time));
                DataManager.RecordData mapRecord = DataManager.getRecord(map_name);
                if (mapRecord != null) {
                    if ((double)time < mapRecord.time) {
                        recordMessage = player.method_5820() + " just beat " + mapRecord.name + "'s time (" + String.format("%.5f", mapRecord.time) + ") on " + mapRecord.map_name + " and now hold the world record with a time of " + formattedNumber + "!";
                        Logger.logGlobal(server, recordMessage);
                        Minehop.recordList.remove(mapRecord);
                        if (DataManager.getAnyRecordFromName(mapRecord.name) == null) {
                            server.method_3734().method_9249(server.method_3734().method_9235().parse("lp user " + mapRecord.name + " parent remove record_holder", (Object)server.method_3739()), "lp user " + mapRecord.name + " parent remove record_holder");
                        }
                        server.method_3734().method_9249(server.method_3734().method_9235().parse("lp user " + player.method_5820() + " parent add record_holder", (Object)server.method_3739()), "lp user " + player.method_5820() + " parent add record_holder");
                        Minehop.recordList.add(new DataManager.RecordData(player.method_5820(), map_name, time));
                        DataManager.saveData(player.method_51469(), "MineHop_Data/minehop_records.json", Minehop.recordList);
                        ReplayManager.Replay replay = new ReplayManager.Replay(map_name, player.method_5820(), time, ReplayEvents.replayEntryMap.get(player.method_5820()));
                        ReplayManager.saveRecordReplay(player.method_51469(), replay);
                        DiscordIntegration.sendRecordToDiscord(recordMessage);
                    }
                } else {
                    recordMessage = player.method_5820() + " just claimed the world record on " + map_name + " with a time of " + formattedNumber + "!";
                    Logger.logGlobal(server, recordMessage);
                    server.method_3734().method_9249(server.method_3734().method_9235().parse("lp user " + player.method_5820() + " parent add record_holder", (Object)server.method_3739()), "lp user " + player.method_5820() + " parent add record_holder");
                    Minehop.recordList.add(new DataManager.RecordData(player.method_5820(), map_name, time));
                    DataManager.saveData(player.method_51469(), "MineHop_Data/minehop_records.json", Minehop.recordList);
                    ReplayManager.Replay replay = new ReplayManager.Replay(map_name, player.method_5820(), time, ReplayEvents.replayEntryMap.get(player.method_5820()));
                    ReplayManager.saveRecordReplay(player.method_51469(), replay);
                    DiscordIntegration.sendRecordToDiscord(recordMessage);
                }
                if ((mapPersonalRecord = DataManager.getPersonalRecord(player.method_5820(), map_name)) != null) {
                    if ((double)time < mapPersonalRecord.time) {
                        Logger.logSuccess((class_1657)player, "You just beat your time (" + String.format("%.5f", mapPersonalRecord.time) + ") on " + mapPersonalRecord.map_name + ", your new record is " + formattedNumber + "!");
                        Minehop.personalRecordList.remove(mapPersonalRecord);
                        Minehop.personalRecordList.add(new DataManager.RecordData(player.method_5820(), map_name, time));
                        DataManager.saveData(player.method_51469(), "MineHop_Data/minehop_pbs.json", Minehop.personalRecordList);
                    }
                } else {
                    Logger.logSuccess((class_1657)player, "You just claimed a personal record of " + formattedNumber + "!");
                    Minehop.personalRecordList.add(new DataManager.RecordData(player.method_5820(), map_name, time));
                    DataManager.saveData(player.method_51469(), "MineHop_Data/minehop_pbs.json", Minehop.personalRecordList);
                }
                Logger.logSuccess((class_1657)player, "Completed " + map_name + " in " + formattedNumber + " seconds.");
            } else {
                Logger.logServer(server, "Invalid time for " + player.method_5820() + ".");
            }
            Minehop.timerManager.remove(player.method_5820());
        }
    }

    public static void sendSpecEfficiency(class_3222 player, double last_jump_speed, int jump_count, double last_efficiency) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeDouble(last_jump_speed);
        buf.writeInt(jump_count);
        buf.writeDouble(last_efficiency);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.CLIENT_SPEC_EFFICIENCY, (class_2540)buf);
    }

    public static void sendOpenMapScreen(class_3222 player, String title) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(title);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.OPEN_MAP_SCREEN, (class_2540)buf);
    }

    public static void sendMaps(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(Minehop.mapList.size());
        for (DataManager.MapData mapData : Minehop.mapList) {
            buf.method_10814(mapData.name);
            buf.writeDouble(mapData.x);
            buf.writeDouble(mapData.y);
            buf.writeDouble(mapData.z);
            buf.writeDouble(mapData.xrot);
            buf.writeDouble(mapData.yrot);
            buf.method_10814(mapData.worldKey);
            buf.writeBoolean(mapData.arena);
            buf.writeBoolean(mapData.hns);
            buf.writeInt(mapData.difficulty);
            buf.writeInt(mapData.player_count);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.SEND_MAPS, (class_2540)buf);
    }

    public static void sendRecords(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(Minehop.mapList.size());
        for (DataManager.MapData mapData : Minehop.mapList) {
            DataManager.RecordData recordData = DataManager.getRecord(mapData.name);
            if (recordData != null) {
                buf.method_10814(recordData.map_name);
                buf.method_10814(recordData.name);
                buf.writeDouble(recordData.time);
                continue;
            }
            buf.method_10814(mapData.name);
            buf.method_10814("None");
            buf.writeDouble(1000000.0);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.SEND_RECORDS, (class_2540)buf);
    }

    public static void sendPersonalRecords(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(Minehop.personalRecordList.size());
        for (DataManager.RecordData recordData : Minehop.personalRecordList) {
            buf.method_10814(recordData.map_name);
            buf.method_10814(recordData.name);
            buf.writeDouble(recordData.time);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.SEND_PERSONAL_RECORDS, (class_2540)buf);
    }

    public static void sendPower(class_3222 player, double x_power, double y_power, double z_power, class_2338 boosterPos) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeDouble(x_power);
        buf.writeDouble(y_power);
        buf.writeDouble(z_power);
        buf.writeInt(boosterPos.method_10263());
        buf.writeInt(boosterPos.method_10264());
        buf.writeInt(boosterPos.method_10260());
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.UPDATE_POWER, (class_2540)buf);
    }

    public static void registerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.SEND_TIME, (server, player, handler, buf, responseSender) -> {
            if (!player.method_7325()) {
                float time = buf.readFloat();
                if (player != null && Minehop.timerManager.containsKey(player.method_5820())) {
                    HashMap<String, Long> timerMap = Minehop.timerManager.get(player.method_5820());
                    List keyList = timerMap.keySet().stream().toList();
                    String mapName = (String)keyList.get(0);
                    DataManager.RecordData personalRecordData = DataManager.getPersonalRecord(player.method_5820(), mapName);
                    double personalRecord = 0.0;
                    if (personalRecordData != null) {
                        personalRecord = personalRecordData.time;
                    }
                    String formattedNumber = String.format("%.2f", Float.valueOf(time));
                    if (SpectateCommands.spectatorList.containsKey(player.method_5820())) {
                        List<String> spectators = SpectateCommands.spectatorList.get(player.method_5820());
                        for (String spectatorName : spectators) {
                            if (spectatorName.equals(player.method_5820())) continue;
                            class_3222 spectatorPlayer = server.method_3760().method_14566(spectatorName);
                            if (!spectatorPlayer.method_7337()) {
                                spectatorPlayer.method_31548().method_5448();
                            }
                            spectatorPlayer.method_20620(player.method_23317(), player.method_23318(), player.method_23321());
                            spectatorPlayer.method_14224((class_1297)player);
                            Logger.logActionBar((class_1657)spectatorPlayer, "Time: " + formattedNumber + " PB: " + (personalRecord != 0.0 ? String.format("%.5f", personalRecord) : "No PB"));
                        }
                    }
                    Logger.logActionBar((class_1657)player, "Time: " + formattedNumber + " PB: " + (personalRecord != 0.0 ? String.format("%.5f", personalRecord) : "No PB"));
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.MAP_FINISH, (server, player, handler, buf, responseSender) -> {
            float time = buf.readFloat();
            PacketHandler.handleMapCompletion(player, server, time);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.SERVER_SPEC_EFFICIENCY, (server, player, handler, buf, responseSender) -> {
            double last_jump_speed = buf.readDouble();
            int jump_count = buf.readInt();
            double last_efficiency = buf.readDouble();
            Minehop.lastEfficiencyMap.put(player.method_5820(), new ReplayManager.SSJEntry(jump_count, last_jump_speed, last_efficiency));
            if (SpectateCommands.spectatorList.containsKey(player.method_5820())) {
                List<String> spectators = SpectateCommands.spectatorList.get(player.method_5820());
                for (String spectator : spectators) {
                    class_3222 spectatorPlayer = server.method_3760().method_14566(spectator);
                    if (spectatorPlayer == null || spectatorPlayer.method_5820().equals(player.method_5820())) continue;
                    PacketHandler.sendSpecEfficiency(spectatorPlayer, last_jump_speed, jump_count, last_efficiency);
                }
            }
        });
    }
}

