/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.replays;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.nerdorg.minehop.Minehop;

public class ReplayManager {
    private static final Type replayListType = new TypeToken<List<Replay>>(){}.getType();

    public static void deleteReplays(String mapName) {
        if (Minehop.replayList != null) {
            Minehop.replayList.removeIf(replay -> replay.map_name.equals(mapName));
        }
    }

    public static Replay getReplay(String mapName) {
        if (Minehop.replayList != null) {
            for (Replay replay : Minehop.replayList) {
                if (!replay.map_name.equals(mapName)) continue;
                return replay;
            }
        }
        return null;
    }

    public static void saveRecordReplay(class_3218 world, Replay replay) {
        Gson gson = new Gson();
        ReplayManager.deleteReplays(replay.map_name);
        Minehop.replayList.add(replay);
        if (Minehop.replayList != null) {
            try {
                String jsonData = gson.toJson(Minehop.replayList);
                MinecraftServer server = world.method_8503();
                Path worldDir = server.method_27050(class_5218.field_24188);
                try {
                    Files.write(worldDir.resolve("minehop_replays.json"), jsonData.getBytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public static void saveRecordReplays(class_3218 world, List<Replay> replays) {
        Gson gson = new Gson();
        String jsonData = gson.toJson(replays);
        MinecraftServer server = world.method_8503();
        Path worldDir = server.method_27050(class_5218.field_24188);
        try {
            Files.write(worldDir.resolve("minehop_replays.json"), jsonData.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<Replay> loadRecordReplays(class_3218 world) {
        Path worldDir = world.method_8503().method_27050(class_5218.field_24188);
        Path filePath = worldDir.resolve("minehop_replays.json");
        try {
            String jsonData = new String(Files.readAllBytes(filePath));
            Gson gson = new Gson();
            return (List)gson.fromJson(jsonData, replayListType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void register() {
        ServerWorldEvents.LOAD.register((server, world) -> {
            Minehop.replayList = new ArrayList<Replay>();
            List<Replay> newReplayList = ReplayManager.loadRecordReplays(world);
            if (newReplayList != null) {
                Minehop.replayList = newReplayList;
            }
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> ReplayManager.saveRecordReplays(world, Minehop.replayList));
    }

    public static class Replay {
        public String map_name;
        public String player_name;
        public double time;
        public List<ReplayEntry> replayEntries;

        public Replay(String map_name, String player_name, double time, List<ReplayEntry> replayEntries) {
            this.map_name = map_name;
            this.player_name = player_name;
            this.time = time;
            this.replayEntries = replayEntries;
        }
    }

    public static class ReplayEntry {
        public double x;
        public double y;
        public double z;
        public double xrot;
        public double yrot;
        public double jump_count;
        public double last_jump_speed;
        public double efficiency;

        public ReplayEntry(double x, double y, double z, double xrot, double yrot, double jump_count, double last_jump_speed, double efficiency) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.xrot = xrot;
            this.yrot = yrot;
            this.jump_count = jump_count;
            this.last_jump_speed = last_jump_speed;
            this.efficiency = efficiency;
        }
    }

    public static class SSJEntry {
        public double jump_count;
        public double last_jump_speed;
        public double efficiency;

        public SSJEntry(double jump_count, double last_jump_speed, double efficiency) {
            this.jump_count = jump_count;
            this.last_jump_speed = last_jump_speed;
            this.efficiency = efficiency;
        }
    }
}

