/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares;

import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import wawa.flares.AllComponents;
import wawa.flares.data_component.FlareComponent;
import wawa.flares.item.FlareGunItem;
import wawa.flares.item.FlareItem;

public class AllItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"flares");
    public static final DeferredItem<FlareGunItem> FLARE_GUN = ITEMS.register("flare_gun", () -> new FlareGunItem(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> ILLUMINATION_FLARE_SHELL = ITEMS.registerSimpleItem("illumination_flare_shell");
    public static final DeferredItem<Item> SIGNALLING_FLARE_SHELL = ITEMS.registerSimpleItem("signalling_flare_shell");
    public static final DeferredItem<Item> FLARE = ITEMS.register("illumination_flare", () -> new FlareItem(new Item.Properties().component(AllComponents.FLARE.get(), (Object)FlareComponent.illuminating(DyeColor.WHITE.getTextureDiffuseColor()))));
    public static final DeferredItem<Item> SIGNALLING_FLARE = ITEMS.register("signalling_flare", () -> new FlareItem(new Item.Properties().component(AllComponents.FLARE.get(), (Object)FlareComponent.signalling(DyeColor.WHITE.getTextureDiffuseColor()))));

    public static void init(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
    }

    public static void addTabItems(CreativeModeTab.Output output) {
        ItemStack stack;
        output.accept((ItemLike)FLARE_GUN.get());
        output.accept((ItemLike)ILLUMINATION_FLARE_SHELL.get());
        output.accept((ItemLike)SIGNALLING_FLARE_SHELL.get());
        for (DyeColor color : DyeColor.values()) {
            stack = FLARE.toStack();
            stack.set(AllComponents.FLARE.get(), (Object)FlareComponent.illuminating(color.getTextureDiffuseColor()));
            output.accept(stack);
        }
        for (DyeColor color : DyeColor.values()) {
            stack = SIGNALLING_FLARE.toStack();
            stack.set(AllComponents.FLARE.get(), (Object)FlareComponent.signalling(color.getTextureDiffuseColor()));
            output.accept(stack);
        }
    }
}

