/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import wawa.flares.AllEntities;
import wawa.flares.AllItems;

public class FlareDatagenAssets {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        event.createProvider(Lang::new);
        event.addProvider((DataProvider)new Model(output, existingFileHelper));
    }

    public static class Model
    extends ItemModelProvider {
        public Model(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "flares", existingFileHelper);
        }

        protected void registerModels() {
            this.basicItem((Item)AllItems.ILLUMINATION_FLARE_SHELL.get());
            this.basicItem((Item)AllItems.SIGNALLING_FLARE_SHELL.get());
        }
    }

    public static class Lang
    extends LanguageProvider {
        public Lang(PackOutput output) {
            super(output, "flares", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.flares", "Flare Guns");
            this.add((Item)AllItems.FLARE_GUN.get(), "Flare Gun");
            this.add((Item)AllItems.ILLUMINATION_FLARE_SHELL.get(), "Illumination Flare Shell");
            this.add((Item)AllItems.SIGNALLING_FLARE_SHELL.get(), "Signalling Flare Shell");
            this.add((Item)AllItems.FLARE.get(), "Illumination Flare");
            this.add((Item)AllItems.SIGNALLING_FLARE.get(), "Signalling Flare");
            this.add(AllEntities.FLARE.get(), "Flare");
            this.addConfig("do_bloom", "Enable Bloom", "");
            this.addConfig("bloom_intensity", "Bloom Intensity", "Don't set this to 11");
            this.addConfig("do_dynamic_lights", "Enable Dynamic Lights", "I'm lazy though this will only affect newly spawned flares");
        }

        private void addConfig(String id, String name, String tooltip) {
            this.add("flares.configuration." + id, name);
            this.add("flares.configuration." + id + ".tooltip", tooltip);
        }
    }
}

