/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares.data_component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import wawa.flares.AllComponents;

public record FlareComponent(int argbColor, int maxAge, boolean trackable) {
    public static int ILLUMINATING_MAX_AGE = 6000;
    public static int SIGNALLING_MAX_AGE = 2400;
    public static final Codec<FlareComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(FlareComponent::argbColor), (App)Codec.INT.fieldOf("maxAge").forGetter(FlareComponent::maxAge), (App)Codec.BOOL.optionalFieldOf("trackable", (Object)false).forGetter(FlareComponent::trackable)).apply((Applicative)instance, FlareComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlareComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, FlareComponent::argbColor, (StreamCodec)ByteBufCodecs.INT, FlareComponent::maxAge, (StreamCodec)ByteBufCodecs.BOOL, FlareComponent::trackable, FlareComponent::new);

    public static FlareComponent illuminating(int argbColor) {
        return new FlareComponent(argbColor, ILLUMINATING_MAX_AGE, false);
    }

    public static FlareComponent signalling(int argbColor) {
        return new FlareComponent(argbColor, SIGNALLING_MAX_AGE, true);
    }

    public boolean isDarkerThanDark() {
        return this.argbColor == (DyeColor.BLACK.getTextureDiffuseColor() | 0xFF000000);
    }

    public static int tint(ItemStack stack, int tintIndex) {
        FlareComponent component = (FlareComponent)stack.get(AllComponents.FLARE.get());
        if (component != null && tintIndex == 1) {
            return component.argbColor();
        }
        return -1;
    }

    public void appendHoverText(Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
    }
}

