/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import wawa.flares.AllComponents;
import wawa.flares.AllItems;
import wawa.flares.AllTags;
import wawa.flares.Flares;
import wawa.flares.data_component.FlareComponent;
import wawa.flares.shot_flare.FlareEntity;

public class FlareGunItem
extends ProjectileWeaponItem {
    public static int CHARGE_TIME = 10;

    public FlareGunItem(Item.Properties properties) {
        super(properties);
    }

    public static void registerPredicate() {
        ItemProperties.register((Item)((Item)AllItems.FLARE_GUN.get()), (ResourceLocation)Flares.resource("loaded"), (stack, level, entity, seed) -> FlareGunItem.isLoaded(stack) ? 1.0f : 0.0f);
    }

    public static boolean isLoaded(ItemStack itemstack) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)itemstack.get(DataComponents.CHARGED_PROJECTILES);
        return chargedprojectiles != null && !chargedprojectiles.isEmpty();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (FlareGunItem.isLoaded(itemstack)) {
            this.performShooting(level, (LivingEntity)player, hand, itemstack);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        if (!player.getProjectile(itemstack).isEmpty()) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return CHARGE_TIME + 3;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        int i = this.getUseDuration(stack, livingEntity) - timeCharged;
        float f = FlareGunItem.getPowerForTime(i, stack, livingEntity);
        if (f >= 1.0f && !FlareGunItem.isCharged(stack)) {
            boolean bl = FlareGunItem.tryLoadFlares(livingEntity, stack);
        }
    }

    private static float getPowerForTime(int timeLeft, ItemStack stack, LivingEntity shooter) {
        float f = (float)timeLeft / (float)CHARGE_TIME;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static boolean isCharged(ItemStack crossbowStack) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)crossbowStack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        return !chargedprojectiles.isEmpty();
    }

    private static boolean tryLoadFlares(LivingEntity shooter, ItemStack flareGunStack) {
        List list = FlareGunItem.draw((ItemStack)flareGunStack, (ItemStack)shooter.getProjectile(flareGunStack), (LivingEntity)shooter);
        if (!list.isEmpty()) {
            flareGunStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((List)list));
            return true;
        }
        return false;
    }

    public boolean useOnRelease(ItemStack stack) {
        return stack.is((Item)this);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedprojectiles != null && !chargedprojectiles.isEmpty()) {
            ItemStack itemstack = (ItemStack)chargedprojectiles.getItems().getFirst();
            MutableComponent name = itemstack.getDisplayName().copy();
            FlareComponent component = (FlareComponent)itemstack.get(AllComponents.FLARE);
            if (component != null) {
                name.withColor(component.argbColor());
            }
            tooltipComponents.add((Component)Component.translatable((String)"item.minecraft.crossbow.projectile").append(CommonComponents.SPACE).append((Component)name));
        }
    }

    public void performShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack weapon) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)weapon.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        if (chargedprojectiles != null && !chargedprojectiles.isEmpty() && level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.shoot(serverlevel, shooter, shooter.getUsedItemHand(), weapon, chargedprojectiles.getItems(), 3.0f, 3.0f, true, null);
        }
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        FlareEntity entity = new FlareEntity(level, ammo);
        entity.setPos(shooter.getEyePosition());
        return entity;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.ARROW_SHOOT, shooter.getSoundSource(), 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 1.7f));
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + angle, 0.0f, velocity, inaccuracy);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> false;
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles(ItemStack thisIsTheFuckingGunItemStack) {
        return andThisIsTheAmmoPredicateStack -> andThisIsTheAmmoPredicateStack.is(AllTags.USABLE_FLARES);
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return ItemStack.EMPTY;
    }
}

