/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares.item;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import wawa.flares.AllComponents;
import wawa.flares.AllItems;
import wawa.flares.FlareConfig;
import wawa.flares.data_component.FlareComponent;
import wawa.flares.shot_flare.FlareEntity;

public class FlareItem
extends Item
implements ProjectileItem {
    private static final ProjectileItem.DispenseConfig dispenseConfig = ProjectileItem.DispenseConfig.builder().power(3.0f).build();

    public FlareItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        FlareComponent component = (FlareComponent)stack.get(AllComponents.FLARE);
        if (component != null) {
            component.appendHoverText(context, tooltipComponents, tooltipFlag);
            if (!component.trackable() && !((Boolean)FlareConfig.CONFIG.doDynamicLights.get()).booleanValue()) {
                tooltipComponents.add((Component)Component.literal((String)"kinda useless because dynamic lights are off :c"));
            }
        }
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        FlareEntity flare = new FlareEntity(level, stack);
        flare.setPos(pos.x(), pos.y(), pos.z());
        return flare;
    }

    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return dispenseConfig;
    }

    public static void init() {
        DispenserBlock.registerProjectileBehavior(AllItems.FLARE);
        DispenserBlock.registerProjectileBehavior(AllItems.SIGNALLING_FLARE);
    }
}

