/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import wawa.flares.AllComponents;
import wawa.flares.AllRecipes;
import wawa.flares.data_component.FlareComponent;

public class FlareDyeRecipe
extends CustomRecipe {
    private final Ingredient shell;
    private final ItemStack result;

    public FlareDyeRecipe(CraftingBookCategory category, Ingredient shell, ItemStack result) {
        super(category);
        this.shell = shell;
        this.result = result;
    }

    public Ingredient getShell() {
        return this.shell;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public ItemStack getResult(int count) {
        return this.result.copyWithCount(count);
    }

    public boolean matches(CraftingInput input, Level level) {
        int shells = 0;
        for (ItemStack item : input.items()) {
            if (item.isEmpty()) continue;
            if (this.getShell().test(item)) {
                ++shells;
                continue;
            }
            if (item.getItem() instanceof DyeItem) continue;
            return false;
        }
        return shells > 0;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        int shells = 0;
        ArrayList<DyeItem> dyes = new ArrayList<DyeItem>();
        for (ItemStack item : input.items()) {
            if (item.isEmpty()) continue;
            if (this.getShell().test(item)) {
                ++shells;
                continue;
            }
            Item item2 = item.getItem();
            if (item2 instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item2;
                dyes.add(dyeItem);
                continue;
            }
            return ItemStack.EMPTY;
        }
        return shells > 0 ? this.mixDyesIntoResult(dyes, shells) : ItemStack.EMPTY;
    }

    public static int mixTextDyes(ArrayList<DyeItem> dyes) {
        if (dyes.isEmpty()) {
            return 0;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        int i1 = 0;
        for (DyeItem dyeitem : dyes) {
            int j3 = dyeitem.getDyeColor().getTextureDiffuseColor();
            int i2 = FastColor.ARGB32.red((int)j3);
            int j2 = FastColor.ARGB32.green((int)j3);
            int k2 = FastColor.ARGB32.blue((int)j3);
            l += Math.max(i2, Math.max(j2, k2));
            i += i2;
            j += j2;
            k += k2;
            ++i1;
        }
        int l2 = i / i1;
        int i3 = j / i1;
        int k3 = k / i1;
        float f = (float)l / (float)i1;
        float f1 = Math.max(l2, Math.max(i3, k3));
        l2 = (int)((float)l2 * f / f1);
        i3 = (int)((float)i3 * f / f1);
        k3 = (int)((float)k3 * f / f1);
        return FastColor.ARGB32.color((int)255, (int)l2, (int)i3, (int)k3);
    }

    private ItemStack mixDyesIntoResult(ArrayList<DyeItem> dyes, int shells) {
        int maxAge;
        int color = FlareDyeRecipe.mixTextDyes(dyes);
        if (color == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack result = this.getResult(shells);
        boolean trackable = result.has(AllComponents.FLARE) && ((FlareComponent)result.get(AllComponents.FLARE)).trackable();
        int n = maxAge = trackable ? FlareComponent.SIGNALLING_MAX_AGE : FlareComponent.ILLUMINATING_MAX_AGE;
        if (result.has(AllComponents.FLARE)) {
            maxAge = ((FlareComponent)result.get(AllComponents.FLARE)).maxAge();
        }
        result.set(AllComponents.FLARE, (Object)new FlareComponent(color, maxAge, trackable));
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return AllRecipes.FLARE_DYE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<FlareDyeRecipe> {
        public static final MapCodec<FlareDyeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CustomRecipe::category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(FlareDyeRecipe::getShell), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(FlareDyeRecipe::getResult)).apply((Applicative)instance, FlareDyeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FlareDyeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FlareDyeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FlareDyeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static FlareDyeRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            Ingredient shellIngredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack flareResult = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new FlareDyeRecipe(category, shellIngredient, flareResult);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, FlareDyeRecipe recipe) {
            buffer.writeEnum((Enum)recipe.category());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getShell());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResult());
        }
    }
}

