/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares.shot_flare;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import wawa.flares.shot_flare.FlareEntity;

public class FlareData {
    public static final Codec<FlareData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(FlareData::getColor), (App)Vec3.CODEC.fieldOf("pos").forGetter(FlareData::getPos), (App)Vec3.CODEC.fieldOf("vel").forGetter(FlareData::getVel), (App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(FlareData::getUuid), (App)Codec.INT.fieldOf("life").forGetter(FlareData::getLife), (App)Codec.INT.fieldOf("maxLife").forGetter(FlareData::getMaxLife), (App)Codec.BOOL.fieldOf("inGround").forGetter(FlareData::isInGround), (App)Codec.BOOL.fieldOf("syncable").forGetter(FlareData::isSyncable)).apply((Applicative)instance, FlareData::new));
    public static final StreamCodec<ByteBuf, FlareData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private boolean entityLoaded;
    private int color;
    private Vec3 pos;
    private Vec3 vel;
    private UUID uuid;
    private int life;
    private int maxLife;
    private boolean inGround;
    private boolean syncable = false;

    public FlareData(boolean entityLoaded, FlareEntity uuid) {
        this.entityLoaded = entityLoaded;
        this.copyFromEntity(uuid);
    }

    public FlareData(int color, Vec3 pos, Vec3 vel, UUID uuid, int life, int maxLife, boolean inGround, boolean syncable) {
        this(false, color, pos, vel, uuid, life, maxLife, inGround);
        this.setSyncable(true);
    }

    public FlareData(boolean entityLoaded, int color, Vec3 pos, Vec3 vel, UUID uuid, int life, int maxLife, boolean inGround) {
        this.entityLoaded = entityLoaded;
        this.color = color;
        this.pos = pos;
        this.vel = vel;
        this.uuid = uuid;
        this.life = life;
        this.maxLife = maxLife;
        this.inGround = inGround;
    }

    public void setLoaded(boolean v) {
        this.entityLoaded = v;
    }

    public boolean isLoaded() {
        return this.entityLoaded;
    }

    public void setSyncable(boolean v) {
        this.syncable = v;
    }

    public boolean isSyncable() {
        return this.syncable;
    }

    public void copyFromEntity(FlareEntity entity) {
        this.color = entity.color;
        this.pos = entity.position();
        this.vel = entity.getDeltaMovement();
        this.uuid = entity.getUUID();
        this.life = entity.tickCount;
        this.maxLife = entity.getMaxAge();
        this.inGround = entity.inGround();
    }

    public void applyToEntity(FlareEntity entity) {
        entity.color = this.color;
        entity.setPos(this.pos);
        entity.setDeltaMovement(this.vel);
        entity.tickCount = this.life;
        entity.setMaxAge(this.maxLife);
        entity.setOnGround(this.inGround);
    }

    public boolean unloadedTick() {
        if (!this.entityLoaded) {
            this.tickMovement();
            ++this.life;
            return this.shouldRemove();
        }
        return false;
    }

    public void tickMovement() {
        if (!this.inGround) {
            this.pos = this.pos.add(this.vel);
            this.vel = FlareEntity.extraTickMovement(this.vel.scale(0.99));
        }
    }

    public boolean shouldRemove() {
        return this.life > this.maxLife;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public int getColor() {
        return this.color;
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public BlockPos getBlockPos() {
        return BlockPos.containing((double)this.pos.x, (double)this.pos.y, (double)this.pos.z);
    }

    public Vec3 getVel() {
        return this.vel;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getLife() {
        return this.life;
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public boolean isInGround() {
        return this.inGround;
    }
}

