/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares.shot_flare;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.network.VeilPacketManager;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import wawa.flares.AllComponents;
import wawa.flares.AllEntities;
import wawa.flares.AllItems;
import wawa.flares.FlareConfig;
import wawa.flares.data_component.FlareComponent;
import wawa.flares.mixinterface.SetRemovedListener;
import wawa.flares.packets.FlareKillPacket;
import wawa.flares.shot_flare.FlareData;
import wawa.flares.shot_flare.FlareHandlerClient;
import wawa.flares.shot_flare.FlareHandlerServer;

public class FlareEntity
extends AbstractArrow
implements SetRemovedListener {
    private static final EntityDataAccessor<ItemStack> FLARE_ITEM = SynchedEntityData.defineId(FlareEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> TICK_COUNT = SynchedEntityData.defineId(FlareEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MAX_AGE = SynchedEntityData.defineId(FlareEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IN_GROUND = SynchedEntityData.defineId(FlareEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TRACKABLE = SynchedEntityData.defineId(FlareEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private LightRenderHandle<PointLightData> outerLight;
    private LightRenderHandle<PointLightData> innerLight;
    public boolean theShadowsCuttingDeeper = false;
    public int color = -1;

    public FlareEntity(EntityType<FlareEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FlareEntity(Level level, ItemStack itemStack) {
        super(AllEntities.FLARE.get(), level);
        this.setPickupItemStack(itemStack.copyWithCount(1));
        FlareComponent component = (FlareComponent)itemStack.get(AllComponents.FLARE);
        if (component != null) {
            this.setTrackable(component.trackable());
            this.setMaxAge(component.maxAge());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLARE_ITEM, (Object)AllItems.FLARE.toStack());
        builder.define(TICK_COUNT, (Object)0);
        builder.define(MAX_AGE, (Object)2400);
        builder.define(IN_GROUND, (Object)false);
        builder.define(TRACKABLE, (Object)false);
    }

    public void tick() {
        super.tick();
        this.entityData.set(IN_GROUND, (Object)this.inGround);
        if (this.isTrackable()) {
            Level level;
            if (!this.inGround) {
                this.setDeltaMovement(FlareEntity.extraTickMovement(this.getDeltaMovement()));
            }
            if ((level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (FlareHandlerServer.get(serverLevel).isRemoved(this.uuid)) {
                    this.discard();
                } else {
                    FlareHandlerServer.get(serverLevel).flareEntityTick(serverLevel, this);
                }
            } else {
                level = this.level();
                if (level instanceof ClientLevel) {
                    ClientLevel clientLevel = (ClientLevel)level;
                    FlareHandlerClient.flareEntityTick(clientLevel, this);
                    this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.005, 0.0);
                }
            }
        }
        this.syncTickCount(this.tickCount);
        if (this.tickCount > this.getMaxAge()) {
            this.discard();
        }
    }

    private void syncTickCount(int v) {
        this.tickCount = v;
        this.getEntityData().set(TICK_COUNT, (Object)v);
    }

    public boolean isOnFire() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    protected void doKnockback(LivingEntity entity, DamageSource damageSource) {
        super.doKnockback(entity, damageSource);
        entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0));
    }

    public static Vec3 extraTickMovement(Vec3 deltaMovement) {
        return deltaMovement.multiply(0.99, 0.99, 0.99).subtract(0.0, 0.001, 0.0);
    }

    protected double getDefaultGravity() {
        return this.isTrackable() ? 0.0 : super.getDefaultGravity();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.entityData.set(IN_GROUND, (Object)this.inGround);
    }

    public boolean isTrackable() {
        return (Boolean)this.entityData.get(TRACKABLE);
    }

    public void setTrackable(boolean v) {
        this.entityData.set(TRACKABLE, (Object)v);
    }

    public int getMaxAge() {
        return (Integer)this.entityData.get(MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.entityData.set(MAX_AGE, (Object)maxAge);
    }

    public void onSyncedDataUpdated(List<SynchedEntityData.DataValue<?>> dataValues) {
        for (SynchedEntityData.DataValue<?> dataValue : dataValues) {
            Level level;
            if (dataValue.id() == FLARE_ITEM.id()) {
                FlareComponent component = (FlareComponent)((ItemStack)dataValue.value()).get(AllComponents.FLARE);
                if (component != null) {
                    this.color = component.argbColor();
                    this.theShadowsCuttingDeeper = component.isDarkerThanDark();
                    if (((Boolean)FlareConfig.CONFIG.doDynamicLights.get()).booleanValue() && this.outerLight == null) {
                        PointLightData outerLight = new PointLightData();
                        outerLight.setPosition(this.getX(), this.getY(), this.getZ());
                        outerLight.setBrightness(this.theShadowsCuttingDeeper ? -1.0f : 1.0f);
                        outerLight.setRadius(25.0f);
                        PointLightData innerLight = new PointLightData();
                        innerLight.setPosition(this.getX(), this.getY(), this.getZ());
                        innerLight.setBrightness(this.theShadowsCuttingDeeper ? -3.0f : 3.0f);
                        innerLight.setRadius(2.5f);
                        outerLight.setColor(this.color);
                        innerLight.setColor(this.color);
                        this.outerLight = VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)outerLight);
                        this.innerLight = VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)innerLight);
                    }
                }
                return;
            }
            if (dataValue.id() == TICK_COUNT.id()) {
                this.tickCount = (Integer)dataValue.value();
                continue;
            }
            if (dataValue.id() == IN_GROUND.id()) {
                this.inGround = (Boolean)dataValue.value();
                continue;
            }
            if (dataValue.id() != TRACKABLE.id() || ((Boolean)dataValue.value()).booleanValue() || !((level = this.level()) instanceof ClientLevel)) continue;
            ClientLevel clientLevel = (ClientLevel)level;
            FlareHandlerClient.remove(clientLevel, this.uuid);
        }
    }

    public void onClientRemoval() {
        super.onClientRemoval();
        if (this.outerLight != null) {
            this.outerLight.free();
            this.innerLight.free();
        }
    }

    public static float getIntensity(boolean trackable, float tickCount, int maxAge) {
        if (trackable) {
            if (tickCount < 100.0f) {
                return tickCount / 100.0f;
            }
            if (tickCount > (float)(maxAge - 400)) {
                return ((float)maxAge - tickCount) / 400.0f;
            }
        } else {
            if (tickCount < 5.0f) {
                return tickCount / 5.0f;
            }
            if (tickCount > (float)(maxAge - 1200)) {
                return ((float)maxAge - tickCount) / 1200.0f;
            }
        }
        return 1.0f;
    }

    public void updateLight(float partialTick) {
        Vec3 pos = this.getPosition(partialTick);
        if (this.outerLight != null) {
            PointLightData outerLight = (PointLightData)this.outerLight.getLightData();
            PointLightData innerLight = (PointLightData)this.innerLight.getLightData();
            outerLight.setPosition(pos.x, pos.y, pos.z);
            innerLight.setPosition(pos.x, pos.y, pos.z);
            float brightness = FlareEntity.getIntensity(this.isTrackable(), this.tickCount, this.getMaxAge());
            if (this.theShadowsCuttingDeeper) {
                brightness *= -1.0f;
            }
            outerLight.setBrightness(brightness);
            outerLight.setRadius(25.0f * brightness);
            innerLight.setBrightness(brightness * 3.0f);
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return AllItems.FLARE.toStack();
    }

    public void setPickupItemStack(ItemStack pickupItemStack) {
        super.setPickupItemStack(pickupItemStack);
        this.setSyncedStack(this.getPickupItem());
    }

    private void setSyncedStack(ItemStack stack) {
        this.getEntityData().set(FLARE_ITEM, (Object)stack);
        FlareComponent component = (FlareComponent)stack.get(AllComponents.FLARE);
        if (component != null) {
            this.color = component.argbColor();
            this.setMaxAge(component.maxAge());
            this.setTrackable(component.trackable());
        }
    }

    public boolean inGround() {
        return this.inGround;
    }

    protected void tickDespawn() {
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("TickCount", this.tickCount);
        compound.putInt("MaxAge", this.getMaxAge());
        compound.putBoolean("Trackable", this.isTrackable());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        ServerLevel serverLevel;
        FlareData data;
        super.readAdditionalSaveData(compound);
        this.tickCount = compound.getInt("TickCount");
        this.setMaxAge(compound.getInt("MaxAge"));
        this.setTrackable(compound.getBoolean("Trackable"));
        this.entityData.set(IN_GROUND, (Object)this.inGround);
        Level level = this.level();
        if (level instanceof ServerLevel && (data = FlareHandlerServer.get(serverLevel = (ServerLevel)level).get(this.uuid)) != null) {
            data.applyToEntity(this);
        }
    }

    @Override
    public void flares$onRemoved(Entity.RemovalReason reason) {
        if (this.isTrackable()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (reason.shouldSave()) {
                    FlareHandlerServer.get(serverLevel).setUnloaded(this.uuid);
                }
                if (reason.shouldDestroy()) {
                    VeilPacketManager.level((ServerLevel)serverLevel).sendPacket(new CustomPacketPayload[]{new FlareKillPacket(this.uuid)});
                    FlareHandlerServer.get(serverLevel).remove(this.uuid);
                }
            } else {
                level = this.level();
                if (level instanceof ClientLevel) {
                    ClientLevel clientLevel = (ClientLevel)level;
                    FlareHandlerClient.setUnloaded(clientLevel, this.uuid);
                }
            }
        }
    }
}

