/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares.shot_flare;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import wawa.flares.AllEntities;
import wawa.flares.AllRenderTypes;
import wawa.flares.Flares;
import wawa.flares.shot_flare.FlareEntity;

public class FlareEntityRenderer
extends EntityRenderer<FlareEntity> {
    public static ResourceLocation TEXTURE = Flares.resource("textures/entity/flare/sparkle.png");

    protected FlareEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(FlareEntity entity) {
        return TEXTURE;
    }

    public boolean shouldRender(FlareEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(FlareEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.tickCount > entity.getMaxAge()) {
            return;
        }
        entity.updateLight(partialTick);
        FlareEntityRenderer.renderFlare(bufferSource, poseStack, (float)entity.tickCount + partialTick, entity.getMaxAge(), entity.isTrackable(), entity.color, 1.0f);
    }

    public static void renderFlare(MultiBufferSource bufferSource, PoseStack poseStack, float tickCount, int maxAge, boolean trackable, int color, float scale) {
        Quaternionf quaternion = new Quaternionf((Quaternionfc)Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
        Vector3f dist = poseStack.last().pose().getTranslation(new Vector3f());
        float len = dist.length();
        if (len > 256.0f) {
            dist.mul((256.0f - len * 1.01f) / len);
            poseStack.translate(dist.x, dist.y, dist.z);
            len = 256.0f;
        }
        float scaledScale = scale * (1.0f + len / 64.0f);
        float scaledScaleScaled = scaledScale * FlareEntity.getIntensity(trackable, tickCount, maxAge);
        int frameI = (int)tickCount / 10;
        quaternion.rotateZ((float)frameI);
        FlareEntityRenderer.renderBillboardedQuad(bufferSource.getBuffer(AllRenderTypes.flareBloom(TEXTURE)), poseStack, quaternion, color, scaledScaleScaled, 0.25f, 0.0f, 0.0f, 1.0f, 0.5f);
        float glowScale = (float)(frameI % 3) * 0.2f + 0.3f;
        FlareEntityRenderer.renderBillboardedQuad(bufferSource.getBuffer(AllRenderTypes.flare(TEXTURE)), poseStack, quaternion, color, glowScale * scaledScaleScaled, 0.1f, 0.0f, 0.5f, 1.0f, 1.0f);
    }

    public static void renderBillboardedQuad(VertexConsumer buffer, PoseStack poseStack, Quaternionf quaternion, int color, float scale, float zOff, float u0, float v0, float u1, float v1) {
        PoseStack.Pose pose = poseStack.last();
        FlareEntityRenderer.vertex(pose, buffer, quaternion, color, scale, -scale, zOff, u1, v1);
        FlareEntityRenderer.vertex(pose, buffer, quaternion, color, scale, scale, zOff, u1, v0);
        FlareEntityRenderer.vertex(pose, buffer, quaternion, color, -scale, scale, zOff, u0, v0);
        FlareEntityRenderer.vertex(pose, buffer, quaternion, color, -scale, -scale, zOff, u0, v1);
    }

    private static void vertex(PoseStack.Pose pose, VertexConsumer consumer, Quaternionf quaternion, int color, float xo, float yo, float zo, float u, float v) {
        Vector3f vec = new Vector3f(xo, yo, zo).rotate((Quaternionfc)quaternion);
        consumer.addVertex(pose, vec.x, vec.y, vec.z).setColor(color).setUv(u, v).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public static void registerRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(AllEntities.FLARE.get(), FlareEntityRenderer::new);
    }
}

