/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares.shot_flare;

import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import wawa.flares.FlareConfig;
import wawa.flares.Flares;
import wawa.flares.mixin.LevelRendererGetter;
import wawa.flares.shot_flare.FlareData;
import wawa.flares.shot_flare.FlareEntity;
import wawa.flares.shot_flare.FlareEntityRenderer;

public class FlareHandlerClient {
    private static final HashMap<ClientLevel, HashMap<UUID, FlareData>> flares = new HashMap();
    private static final ResourceLocation FLARE_BLOOM_SHADER = Flares.resource("flare_bloom");

    public static HashMap<UUID, FlareData> getFlaresIn(ClientLevel clientLevel) {
        return flares.computeIfAbsent(clientLevel, l -> new HashMap());
    }

    public static void addFlare(ClientLevel clientLevel, FlareData data) {
        FlareData oldData = FlareHandlerClient.getFlaresIn(clientLevel).put(data.getUuid(), data);
        if (oldData != null && oldData.isLoaded()) {
            data.setLoaded(true);
        }
    }

    public static void flareEntityTick(ClientLevel clientLevel, FlareEntity flare) {
        if (flare.getRemovalReason() != null) {
            return;
        }
        FlareData data = FlareHandlerClient.getFlaresIn(clientLevel).get(flare.getUUID());
        if (data == null) {
            FlareHandlerClient.getFlaresIn(clientLevel).put(flare.getUUID(), new FlareData(true, flare));
        } else {
            data.copyFromEntity(flare);
            data.setLoaded(true);
        }
    }

    public static void setUnloaded(ClientLevel clientLevel, UUID flare) {
        FlareData data = FlareHandlerClient.getFlaresIn(clientLevel).get(flare);
        if (data != null) {
            data.setLoaded(false);
        }
    }

    public static void remove(ClientLevel clientLevel, UUID flare) {
        FlareHandlerClient.getFlaresIn(clientLevel).remove(flare);
    }

    @SubscribeEvent
    public static void tickFlares(LevelTickEvent.Pre event) {
        ClientLevel clientLevel;
        HashMap<UUID, FlareData> flareMap;
        Level level = event.getLevel();
        if (level instanceof ClientLevel && (flareMap = flares.get(clientLevel = (ClientLevel)level)) != null) {
            Iterator<Map.Entry<UUID, FlareData>> it = flareMap.entrySet().iterator();
            while (it.hasNext()) {
                FlareData flare = it.next().getValue();
                if (!flare.unloadedTick()) continue;
                it.remove();
            }
        }
    }

    public static boolean canRenderEntityDirectly(FlareData data, ClientLevel level) {
        BlockPos blockPos = data.getBlockPos();
        return level.isOutsideBuildHeight(blockPos.getY()) || Minecraft.getInstance().levelRenderer.isSectionCompiled(blockPos);
    }

    @SubscribeEvent
    public static void renderFlares(RenderLevelStageEvent event) {
        HashMap<UUID, FlareData> renderable;
        ShaderProgram shader = VeilRenderSystem.setShader((ResourceLocation)FLARE_BLOOM_SHADER);
        if (shader != null) {
            shader.bind();
            ShaderUniform bloom = shader.getUniform((CharSequence)"bloom");
            if (bloom != null) {
                bloom.setFloat(((Double)FlareConfig.CONFIG.bloomIntensity.get()).floatValue());
            }
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && (renderable = flares.get(Minecraft.getInstance().level)) != null) {
            float partialTick = event.getPartialTick().getGameTimeDeltaTicks();
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource.BufferSource bufferSource = ((LevelRendererGetter)event.getLevelRenderer()).getBuffers().bufferSource();
            renderable.forEach((uuid, data) -> {
                if (data.isLoaded() && FlareHandlerClient.canRenderEntityDirectly(data, Minecraft.getInstance().level)) {
                    return;
                }
                Vec3 pos = data.getPos().add(data.getVel().scale((double)event.getPartialTick().getGameTimeDeltaTicks())).subtract(event.getCamera().getPosition());
                double distance = pos.length();
                if (distance > 1000000.0) {
                    return;
                }
                poseStack.pushPose();
                poseStack.translate(pos.x, pos.y, pos.z);
                FlareEntityRenderer.renderFlare((MultiBufferSource)bufferSource, poseStack, (float)data.getLife() + partialTick, data.getMaxLife(), true, data.getColor(), 1.0f);
                poseStack.popPose();
            });
        }
    }
}

