/*
 * Decompiled with CFR 0.152.
 */
package wawa.flares.shot_flare;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import foundry.veil.api.network.VeilPacketManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import wawa.flares.packets.FlareDataPacket;
import wawa.flares.shot_flare.FlareData;
import wawa.flares.shot_flare.FlareEntity;

public class FlareHandlerServer
extends SavedData {
    private final Map<UUID, FlareData> flares;
    private final Set<UUID> removed;
    private static final String ID = "flares_flare_data";

    public FlareHandlerServer(Map<UUID, FlareData> flares, Set<UUID> removed) {
        this.flares = flares;
        this.removed = removed;
    }

    public FlareHandlerServer() {
        this(new HashMap<UUID, FlareData>(), new HashSet<UUID>());
    }

    public List<UUID> getRemovedAsList() {
        return this.removed.stream().toList();
    }

    public FlareData get(UUID id) {
        this.setDirty();
        return this.flares.get(id);
    }

    public void flareEntityTick(ServerLevel serverLevel, FlareEntity flare) {
        if (flare.getRemovalReason() != null) {
            return;
        }
        this.setDirty();
        FlareData data = this.flares.get(flare.getUUID());
        if (data == null) {
            data = new FlareData(true, flare);
            data.setSyncable(serverLevel.canSeeSky(flare.blockPosition()));
            this.flares.put(flare.getUUID(), data);
            if (data.isSyncable()) {
                VeilPacketManager.level((ServerLevel)serverLevel).sendPacket(new CustomPacketPayload[]{new FlareDataPacket(data)});
            }
        } else {
            if (data.isLoaded()) {
                data.copyFromEntity(flare);
            } else {
                data.applyToEntity(flare);
                data.setLoaded(true);
            }
            data.setSyncable(serverLevel.canSeeSky(flare.blockPosition()));
        }
    }

    public void setUnloaded(UUID flare) {
        FlareData data = this.flares.get(flare);
        if (data != null) {
            this.setDirty();
            data.setLoaded(false);
        }
    }

    public boolean isRemoved(UUID flare) {
        return this.removed.contains(flare);
    }

    public void remove(UUID flare) {
        this.setDirty();
        this.flares.remove(flare);
        this.removed.add(flare);
    }

    @SubscribeEvent
    public static void tickFlares(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            FlareHandlerServer.get(serverLevel).tickFlaresLevel(serverLevel);
        }
    }

    public void tickFlaresLevel(ServerLevel level) {
        ArrayList<FlareDataPacket> packets = new ArrayList<FlareDataPacket>();
        DistanceManager distanceManager = level.getChunkSource().chunkMap.getDistanceManager();
        Iterator<Map.Entry<UUID, FlareData>> it = this.flares.entrySet().iterator();
        while (it.hasNext()) {
            FlareData flare = it.next().getValue();
            if (!distanceManager.inEntityTickingRange(ChunkPos.asLong((BlockPos)flare.getBlockPos()))) {
                this.setDirty();
                flare.setLoaded(false);
            }
            if (flare.unloadedTick()) {
                this.setDirty();
                it.remove();
                this.removed.add(flare.getUuid());
            }
            if (!flare.isSyncable() || level.getServer().getTickCount() % 20 != 0) continue;
            packets.add(new FlareDataPacket(flare));
        }
        if (!packets.isEmpty()) {
            CustomPacketPayload[] packetArray = packets.toArray(new FlareDataPacket[0]);
            VeilPacketManager.level((ServerLevel)level).sendPacket(packetArray);
        }
    }

    public static FlareHandlerServer get(ServerLevel serverLevel) {
        return (FlareHandlerServer)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(FlareHandlerServer::new, FlareHandlerServer::load), ID);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag flareData = new CompoundTag();
        this.flares.forEach((id, data) -> flareData.put(id.toString(), (Tag)FlareData.CODEC.encode(data, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow()));
        compoundTag.put("flare_data", (Tag)flareData);
        compoundTag.put("expired_flares", (Tag)UUIDUtil.CODEC_SET.encode(this.removed, (DynamicOps)NbtOps.INSTANCE, (Object)new ListTag()).getOrThrow());
        return compoundTag;
    }

    public static FlareHandlerServer load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        HashMap<UUID, FlareData> flareData = new HashMap<UUID, FlareData>();
        CompoundTag nbtFlareData = tag.getCompound("flare_data");
        nbtFlareData.getAllKeys().forEach(key -> flareData.put(UUID.fromString(key), (FlareData)((Pair)FlareData.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbtFlareData.get(key)).getOrThrow()).getFirst()));
        Set expiredFlares = (Set)((Pair)UUIDUtil.CODEC_SET.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getList("expired_flares", 11)).getOrThrow()).getFirst();
        return new FlareHandlerServer(flareData, expiredFlares);
    }
}

