/*
 * Decompiled with CFR 0.152.
 */
package com.example.spammute;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpamMute
extends JavaPlugin
implements Listener {
    private Map<UUID, List<MessageData>> playerMessages;
    private Map<UUID, MuteData> mutedPlayers;
    private int messageThreshold;
    private int consecutiveThreshold;
    private int timeWindowSeconds;
    private int similarityThreshold;
    private int defaultMuteDurationMinutes;
    private boolean notifyPlayer;
    private boolean notifyStaff;
    private boolean useEssentialsForMute;
    private String muteMessage;
    private String staffNotificationMessage;
    private String playerNotificationMessage;
    private String unmutedMessage;
    private List<String> exemptPermissions;

    @Override
    public void onEnable() {
        this.playerMessages = new ConcurrentHashMap<UUID, List<MessageData>>();
        this.mutedPlayers = new ConcurrentHashMap<UUID, MuteData>();
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("spammute").setExecutor(this);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::cleanupOldMessages, 1200L, 1200L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::checkMutes, 200L, 200L);
        this.getLogger().info("SpamMute has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("SpamMute has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.messageThreshold = config.getInt("detection.message-threshold", 5);
        this.consecutiveThreshold = config.getInt("detection.consecutive-threshold", 3);
        this.timeWindowSeconds = config.getInt("detection.time-window-seconds", 10);
        this.similarityThreshold = config.getInt("detection.similarity-threshold", 80);
        this.defaultMuteDurationMinutes = config.getInt("mute.default-duration-minutes", 10);
        this.notifyPlayer = config.getBoolean("notifications.notify-player", true);
        this.notifyStaff = config.getBoolean("notifications.notify-staff", true);
        this.useEssentialsForMute = config.getBoolean("mute.use-essentials", false);
        this.muteMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.mute-message", "&cYou have been muted for spamming."));
        this.staffNotificationMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.staff-notification", "&c{player} has been muted for spamming."));
        this.playerNotificationMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.player-notification", "&cYou have been muted for {duration} minutes for spamming."));
        this.unmutedMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.unmuted-message", "&aYou are no longer muted."));
        this.exemptPermissions = config.getStringList("exempt-permissions");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.playerMessages.containsKey(playerId)) {
            this.playerMessages.put(playerId, new ArrayList());
        }
        if (this.mutedPlayers.containsKey(playerId)) {
            MuteData muteData = this.mutedPlayers.get(playerId);
            long remainingMinutes = (muteData.expirationTime - System.currentTimeMillis()) / 60000L;
            if (remainingMinutes > 0L) {
                Bukkit.getScheduler().runTaskLater((Plugin)this, () -> player.sendMessage(String.valueOf((Object)ChatColor.RED) + "You are currently muted for spam. Remaining time: " + remainingMinutes + " minutes."), 40L);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        String message = event.getMessage();
        for (String permission : this.exemptPermissions) {
            if (!player.hasPermission(permission)) continue;
            return;
        }
        if (this.isPlayerMuted(playerId)) {
            event.setCancelled(true);
            player.sendMessage(this.muteMessage);
            return;
        }
        this.recordMessage(playerId, message);
        SpamResult spamResult = this.checkForSpam(playerId, message);
        if (spamResult.isSpam) {
            this.mutePlayer(player, this.defaultMuteDurationMinutes, spamResult.reason);
            event.setCancelled(true);
        }
    }

    private boolean isPlayerMuted(UUID playerId) {
        Player player;
        if (this.mutedPlayers.containsKey(playerId)) {
            return true;
        }
        if (this.useEssentialsForMute && Bukkit.getPluginManager().isPluginEnabled("Essentials") && (player = Bukkit.getPlayer(playerId)) != null) {
            try {
                User user = ((Essentials)Essentials.getPlugin(Essentials.class)).getUser(player);
                return user != null && user.isMuted();
            }
            catch (Exception e) {
                this.getLogger().warning("Error checking Essentials mute status: " + e.getMessage());
            }
        }
        return false;
    }

    private void recordMessage(UUID playerId, String message) {
        List messages = this.playerMessages.computeIfAbsent(playerId, k -> new ArrayList());
        messages.add(new MessageData(message, System.currentTimeMillis()));
    }

    private SpamResult checkForSpam(UUID playerId, String message) {
        List<MessageData> messages = this.playerMessages.get(playerId);
        if (messages == null || messages.size() < 2) {
            return new SpamResult(false, "");
        }
        long currentTime = System.currentTimeMillis();
        long windowStart = currentTime - (long)this.timeWindowSeconds * 1000L;
        ArrayList<MessageData> recentMessages = new ArrayList<MessageData>();
        for (MessageData msgData : messages) {
            if (msgData.timestamp < windowStart) continue;
            recentMessages.add(msgData);
        }
        if (recentMessages.size() >= this.consecutiveThreshold) {
            return new SpamResult(true, "rapid consecutive messages");
        }
        if (recentMessages.size() < this.messageThreshold) {
            return new SpamResult(false, "");
        }
        int similarCount = 0;
        for (MessageData msgData : recentMessages) {
            if (this.calculateSimilarity(message, msgData.message) < this.similarityThreshold) continue;
            ++similarCount;
        }
        if (similarCount >= this.messageThreshold) {
            return new SpamResult(true, "similar message spam");
        }
        return new SpamResult(false, "");
    }

    private int calculateSimilarity(String s1, String s2) {
        if (s1.equals(s2)) {
            return 100;
        }
        int distance = this.levenshteinDistance(s1.toLowerCase(), s2.toLowerCase());
        int maxLength = Math.max(s1.length(), s2.length());
        return maxLength == 0 ? 100 : (int)(100.0 * (1.0 - (double)distance / (double)maxLength));
    }

    private int levenshteinDistance(String s1, String s2) {
        int[][] dp = new int[s1.length() + 1][s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            for (int j = 0; j <= s2.length(); ++j) {
                dp[i][j] = i == 0 ? j : (j == 0 ? i : Math.min(Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1), dp[i - 1][j - 1] + (s1.charAt(i - 1) == s2.charAt(j - 1) ? 0 : 1)));
            }
        }
        return dp[s1.length()][s2.length()];
    }

    private void mutePlayer(Player player, int durationMinutes, String reason) {
        UUID playerId = player.getUniqueId();
        long expirationTime = System.currentTimeMillis() + (long)(durationMinutes * 60) * 1000L;
        this.playerMessages.remove(playerId);
        if (this.useEssentialsForMute && Bukkit.getPluginManager().isPluginEnabled("Essentials")) {
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                try {
                    Essentials essentials = (Essentials)Essentials.getPlugin(Essentials.class);
                    User user = essentials.getUser(player);
                    Date expiryDate = new Date(expirationTime);
                    user.setMuted(true);
                    user.setMuteTimeout(expiryDate.getTime());
                    this.getLogger().info("Player " + player.getName() + " muted via Essentials for " + reason);
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to mute using Essentials: " + e.getMessage());
                    this.mutedPlayers.put(playerId, new MuteData(expirationTime, reason));
                }
            });
        } else {
            this.mutedPlayers.put(playerId, new MuteData(expirationTime, reason));
        }
        this.handleNotifications(player, reason);
    }

    private void handleNotifications(Player player, String reason) {
        String message;
        if (this.notifyPlayer) {
            message = this.playerNotificationMessage.replace("{duration}", String.valueOf(this.defaultMuteDurationMinutes)).replace("{reason}", reason);
            player.sendMessage(message);
        }
        if (this.notifyStaff) {
            message = this.staffNotificationMessage.replace("{player}", player.getName()).replace("{reason}", reason);
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                if (!player2.hasPermission("spammute.notify")) continue;
                player2.sendMessage(message);
            }
            this.getLogger().info(ChatColor.stripColor(message));
        }
    }

    private void cleanupOldMessages() {
        long currentTime = System.currentTimeMillis();
        long windowStart = currentTime - (long)(this.timeWindowSeconds * 2) * 1000L;
        for (UUID playerId : this.playerMessages.keySet()) {
            List<MessageData> messages = this.playerMessages.get(playerId);
            if (messages == null) continue;
            messages.removeIf(msgData -> msgData.timestamp < windowStart);
        }
    }

    private void checkMutes() {
        long currentTime = System.currentTimeMillis();
        HashSet<UUID> toRemove = new HashSet<UUID>();
        for (Map.Entry<UUID, MuteData> entry : this.mutedPlayers.entrySet()) {
            UUID playerId = entry.getKey();
            MuteData muteData = entry.getValue();
            if (currentTime < muteData.expirationTime) continue;
            toRemove.add(playerId);
            Player player = Bukkit.getPlayer(playerId);
            if (player == null || !player.isOnline()) continue;
            player.sendMessage(this.unmutedMessage);
        }
        for (UUID playerId : toRemove) {
            this.mutedPlayers.remove(playerId);
        }
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("spammute")) {
            if (args.length == 0) {
                sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "SpamMute v" + this.getDescription().getVersion());
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Usage:");
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/spammute reload - Reload the configuration");
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/spammute unmute <player> - Unmute a player");
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/spammute mute <player> <duration> - Manually mute a player");
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("spammute.reload")) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                this.reloadConfig();
                this.loadConfig();
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "SpamMute configuration reloaded.");
                return true;
            }
            if (args[0].equalsIgnoreCase("unmute")) {
                if (!sender.hasPermission("spammute.unmute")) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /spammute unmute <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer(args[1]);
                if (target == null) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Player not found.");
                    return true;
                }
                UUID targetId = target.getUniqueId();
                if (this.useEssentialsForMute && Bukkit.getPluginManager().isPluginEnabled("Essentials")) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> {
                        try {
                            Essentials essentials = (Essentials)Essentials.getPlugin(Essentials.class);
                            User user = essentials.getUser(target);
                            if (user.isMuted()) {
                                user.setMuted(false);
                                target.sendMessage(this.unmutedMessage);
                                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + target.getName() + " has been unmuted.");
                            } else {
                                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + target.getName() + " is not muted.");
                            }
                        }
                        catch (Exception e) {
                            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Error unmuting player: " + e.getMessage());
                        }
                    });
                } else if (this.mutedPlayers.containsKey(targetId)) {
                    this.mutedPlayers.remove(targetId);
                    target.sendMessage(this.unmutedMessage);
                    sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + target.getName() + " has been unmuted.");
                } else {
                    sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + target.getName() + " is not muted.");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("mute")) {
                if (!sender.hasPermission("spammute.mute")) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /spammute mute <player> [duration]");
                    return true;
                }
                Player target = Bukkit.getPlayer(args[1]);
                if (target == null) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Player not found.");
                    return true;
                }
                int duration = this.defaultMuteDurationMinutes;
                if (args.length >= 3) {
                    try {
                        duration = Integer.parseInt(args[2]);
                        if (duration <= 0) {
                            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Duration must be a positive number.");
                            return true;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Invalid duration. Please provide a number in minutes.");
                        return true;
                    }
                }
                this.mutePlayer(target, duration, "manual mute by " + sender.getName());
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + target.getName() + " has been muted for " + duration + " minutes.");
                return true;
            }
            sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "SpamMute v" + this.getDescription().getVersion());
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Usage:");
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/spammute reload - Reload the configuration");
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/spammute unmute <player> - Unmute a player");
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/spammute mute <player> <duration> - Manually mute a player");
            return true;
        }
        return false;
    }

    private static class MuteData {
        long expirationTime;
        String reason;

        MuteData(long expirationTime, String reason) {
            this.expirationTime = expirationTime;
            this.reason = reason;
        }
    }

    private static class SpamResult {
        boolean isSpam;
        String reason;

        SpamResult(boolean isSpam, String reason) {
            this.isSpam = isSpam;
            this.reason = reason;
        }
    }

    private static class MessageData {
        String message;
        long timestamp;

        MessageData(String message, long timestamp) {
            this.message = message;
            this.timestamp = timestamp;
        }
    }
}

