/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.lmspaster.network;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import me.fallenbreath.lmspaster.LitematicaServerPasterMod;
import me.fallenbreath.lmspaster.mixins.ServerPlayNetworkHandlerAccessor;
import me.fallenbreath.lmspaster.network.LmsNetwork;
import me.fallenbreath.lmspaster.network.LmsPasterPacket;
import me.fallenbreath.lmspaster.utils.NbtUtils;
import me.fallenbreath.lmspaster.utils.PlayerUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3244;

public class ServerNetworkHandler {
    private static final Map<class_3244, StringBuilder> VERY_LONG_CHATS = new WeakHashMap<class_3244, StringBuilder>();

    private static Optional<StringBuilder> getVeryLongChatBuilder(class_3222 player) {
        return Optional.ofNullable(VERY_LONG_CHATS.get(player.field_13987));
    }

    public static void handleClientPacket(LmsPasterPacket packet, class_3222 player) {
        String playerName = player.method_5477().getString();
        int id = packet.getPacketId();
        class_2487 nbt = packet.getNbt();
        switch (id) {
            case 0: {
                String clientModVersion = NbtUtils.getStringOrEmpty(nbt, "mod_version");
                LitematicaServerPasterMod.LOGGER.info("Player {} connected with {} @ {}", new Object[]{playerName, "Litematica Server Paster", clientModVersion});
                player.field_13987.method_14364((class_2596)LmsNetwork.S2C.packet(0, nbt2 -> nbt2.method_10582("mod_version", LitematicaServerPasterMod.VERSION)));
                player.field_13987.method_14364((class_2596)LmsNetwork.S2C.packet(1, nbt2 -> nbt2.method_10539("ids", LmsNetwork.C2S.ALL_PACKET_IDS)));
                break;
            }
            case 1: {
                LitematicaServerPasterMod.LOGGER.debug("Received chat from player {}", (Object)playerName);
                String message = NbtUtils.getStringOrEmpty(nbt, "chat");
                ServerNetworkHandler.triggerCommand(player, playerName, message);
                break;
            }
            case 2: {
                LitematicaServerPasterMod.LOGGER.debug("Received VERY_LONG_CHAT_START from player {}", (Object)playerName);
                VERY_LONG_CHATS.put(player.field_13987, new StringBuilder());
                break;
            }
            case 3: {
                String segment = NbtUtils.getStringOrEmpty(nbt, "segment");
                LitematicaServerPasterMod.LOGGER.debug("Received VERY_LONG_CHAT_CONTENT from player {} with length {}", (Object)playerName, (Object)segment.length());
                ServerNetworkHandler.getVeryLongChatBuilder(player).ifPresent(builder -> builder.append(segment));
                break;
            }
            case 4: {
                LitematicaServerPasterMod.LOGGER.debug("Received VERY_LONG_CHAT_END from player {}", (Object)playerName);
                ServerNetworkHandler.getVeryLongChatBuilder(player).ifPresent(builder -> ServerNetworkHandler.triggerCommand(player, playerName, builder.toString()));
                VERY_LONG_CHATS.remove(player.field_13987);
            }
        }
    }

    private static void triggerCommand(class_3222 player, String playerName, String command) {
        if (command.isEmpty()) {
            LitematicaServerPasterMod.LOGGER.warn("Player {} sent an empty command", (Object)playerName);
        } else {
            LitematicaServerPasterMod.LOGGER.debug("Player {} is sending a command with length {}", (Object)playerName, (Object)command.length());
            Objects.requireNonNull(PlayerUtils.getServerFromPlayer(player)).execute(() -> ((ServerPlayNetworkHandlerAccessor)player.field_13987).invokeExecuteCommand(command));
        }
    }
}

