/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.lmspaster.network;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import me.fallenbreath.lmspaster.LitematicaServerPasterMod;
import me.fallenbreath.lmspaster.network.LmsNetwork;
import me.fallenbreath.lmspaster.network.LmsPasterPacket;
import me.fallenbreath.lmspaster.utils.NbtUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;

public class ClientNetworkHandler {
    private static final int[] MINIMUM_SUPPORT_PACKETS = new int[]{0, 1};
    private static int[] supportPackets = new int[0];

    public static void handleServerPacket(LmsPasterPacket packet, class_746 player) {
        int id = packet.getPacketId();
        class_2487 nbt = packet.getNbt();
        switch (id) {
            case 0: {
                String serverModVersion = NbtUtils.getStringOrEmpty(nbt, "mod_version");
                LitematicaServerPasterMod.LOGGER.info("Server is installed with mod {} @ {}", (Object)"Litematica Server Paster", (Object)serverModVersion);
                supportPackets = (int[])MINIMUM_SUPPORT_PACKETS.clone();
                break;
            }
            case 1: {
                supportPackets = NbtUtils.getIntArrayOrEmpty(nbt, "ids");
                LitematicaServerPasterMod.LOGGER.debug("Packet IDs supported by the server: {}", (Object)supportPackets);
            }
        }
    }

    public static void sendHiToTheServer(class_634 clientPlayNetworkHandler) {
        supportPackets = new int[0];
        clientPlayNetworkHandler.method_2883((class_2596)LmsNetwork.C2S.packet(0, nbt2 -> nbt2.method_10582("mod_version", LitematicaServerPasterMod.VERSION)));
    }

    public static boolean isServerPasterAvailable() {
        return supportPackets.length > 0;
    }

    public static boolean doesServerAcceptsVeryLongChat() {
        return Arrays.stream(supportPackets).anyMatch(id -> id == 2);
    }

    private static boolean isStringVeryLong(String string) {
        return string.getBytes(StandardCharsets.UTF_8).length > 32667;
    }

    public static boolean canSendCommand(String command) {
        if (command.isEmpty()) {
            return false;
        }
        if (ClientNetworkHandler.doesServerAcceptsVeryLongChat()) {
            return true;
        }
        return !ClientNetworkHandler.isStringVeryLong(command);
    }

    public static void sendCommand(String command) {
        if (ClientNetworkHandler.isStringVeryLong(command)) {
            if (ClientNetworkHandler.doesServerAcceptsVeryLongChat()) {
                ClientNetworkHandler.sendVeryLongCommand(command);
            } else {
                LitematicaServerPasterMod.LOGGER.warn("Tried to send over-length command but server does not support very long chat. Command length {}", (Object)command.length());
            }
            return;
        }
        class_634 networkHandler = class_310.method_1551().method_1562();
        if (networkHandler != null) {
            networkHandler.method_2883((class_2596)LmsNetwork.C2S.packet(1, nbt2 -> nbt2.method_10582("chat", command)));
        }
    }

    private static void sendVeryLongCommand(String command) {
        class_634 networkHandler = class_310.method_1551().method_1562();
        if (networkHandler != null) {
            int segmentLength = 8000;
            networkHandler.method_2883((class_2596)LmsNetwork.C2S.packet(2, nbt2 -> {}));
            for (int i = 0; i < command.length(); i += 8000) {
                int j = Math.min(command.length(), i + 8000);
                String segment = command.substring(i, j);
                networkHandler.method_2883((class_2596)LmsNetwork.C2S.packet(3, nbt2 -> nbt2.method_10582("segment", segment)));
            }
            networkHandler.method_2883((class_2596)LmsNetwork.C2S.packet(4, nbt2 -> {}));
        }
    }
}

