/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.workstations.block.custom;

import net.aepherastudios.workstations.block.entity.LesserFurnaceCoreBlockEntity;
import net.aepherastudios.workstations.item.custom.MultiblockHammerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class LesserFurnaceCoreBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty ASSEMBLED = BooleanProperty.m_61465_((String)"assembled");

    public LesserFurnaceCoreBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ASSEMBLED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof LesserFurnaceCoreBlockEntity)) {
            return InteractionResult.PASS;
        }
        LesserFurnaceCoreBlockEntity core = (LesserFurnaceCoreBlockEntity)blockEntity;
        if (heldItem.m_41720_() instanceof MultiblockHammerItem) {
            if (!core.isAssembled()) {
                core.validateFurnace();
                return InteractionResult.CONSUME;
            }
            core.disassembleFurnace();
            return InteractionResult.CONSUME;
        }
        if (!core.isAssembled()) {
            pLevel.m_5594_(null, pPos, SoundEvents.f_11669_, SoundSource.BLOCKS, 0.75f, 0.75f);
            pPlayer.m_5661_((Component)Component.m_237115_((String)"subtitles.workstations.unassembled_error"), true);
            return InteractionResult.CONSUME;
        }
        this.openMenu(pLevel, pPos, pPlayer);
        return InteractionResult.CONSUME;
    }

    public void disassemble(Level pLevel, BlockPos pPos) {
        BlockState current = pLevel.m_8055_(pPos);
        pLevel.m_7731_(pPos, (BlockState)current.m_61124_((Property)ASSEMBLED, (Comparable)Boolean.valueOf(false)), 3);
    }

    public void assemble(Level pLevel, BlockPos pPos) {
        BlockState current = pLevel.m_8055_(pPos);
        pLevel.m_7731_(pPos, (BlockState)current.m_61124_((Property)ASSEMBLED, (Comparable)Boolean.valueOf(true)), 3);
    }

    protected void openMenu(Level pLevel, BlockPos pPos, Player pPlayer) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof LesserFurnaceCoreBlockEntity) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)((MenuProvider)blockentity));
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockentity;
        if (pStack.m_41788_() && (blockentity = pLevel.m_7702_(pPos)) instanceof AbstractFurnaceBlockEntity) {
            ((AbstractFurnaceBlockEntity)blockentity).m_58638_(pStack.m_41786_());
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof LesserFurnaceCoreBlockEntity) {
            LesserFurnaceCoreBlockEntity coreBE = (LesserFurnaceCoreBlockEntity)blockEntity;
            if (!level.f_46443_ && coreBE.isAssembled()) {
                coreBE.disassembleFurnace();
            }
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LIT, ASSEMBLED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new LesserFurnaceCoreBlockEntity(pPos, pState);
    }
}

