/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.workstations.client.menu.custom;

import com.google.common.collect.Lists;
import java.util.List;
import net.aepherastudios.workstations.block.IWBlocks;
import net.aepherastudios.workstations.client.IWMenuTypes;
import net.aepherastudios.workstations.recipe.IWRecipes;
import net.aepherastudios.workstations.recipe.custom.WoodcuttingRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WoodcutterMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<WoodcuttingRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            WoodcutterMenu.this.m_6199_((Container)this);
            WoodcutterMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public WoodcutterMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public WoodcutterMenu(int pContainerId, Inventory pPlayerInventory, final ContainerLevelAccess pAccess) {
        super((MenuType)IWMenuTypes.WOODCUTTER_MENU.get(), pContainerId);
        this.access = pAccess;
        this.level = pPlayerInventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack pItemStack) {
                return false;
            }

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                pStack.m_41678_(pPlayer.m_9236_(), pPlayer, pStack.m_41613_());
                WoodcutterMenu.this.resultContainer.m_58395_(pPlayer, this.getRelevantItems());
                ItemStack itemstack = WoodcutterMenu.this.inputSlot.m_6201_(1);
                if (!itemstack.m_41619_()) {
                    WoodcutterMenu.this.setupResultSlot();
                }
                pAccess.m_39292_((pLevel, pPos) -> {
                    long l = pLevel.m_46467_();
                    if (WoodcutterMenu.this.lastSoundTime != l) {
                        pLevel.m_5594_((Player)null, pPos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        WoodcutterMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(pPlayer, pStack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(WoodcutterMenu.this.inputSlot.m_7993_());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public WoodcutterMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)data.m_130135_()));
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<WoodcuttingRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player pPlayer) {
        return WoodcutterMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)IWBlocks.WOODCUTTER.get()));
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.m_6422_(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public void m_6199_(Container pInventory) {
        ItemStack itemstack = this.inputSlot.m_7993_();
        if (!itemstack.m_150930_(this.input.m_41720_())) {
            this.input = itemstack.m_41777_();
            this.setupRecipeList(pInventory, itemstack);
        }
    }

    private void setupRecipeList(Container pContainer, ItemStack pStack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!pStack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)IWRecipes.WOODCUTTING.get(), pContainer, this.level);
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            WoodcuttingRecipe woodcuttingRecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack itemstack = woodcuttingRecipe.m_5874_(this.container, this.level.m_9598_());
            if (itemstack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)woodcuttingRecipe);
                this.resultSlot.m_5852_(itemstack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)IWMenuTypes.WOODCUTTER_MENU.get();
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.resultContainer && super.m_5882_(pStack, pSlot);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 1) {
                item.m_7836_(itemstack1, pPlayer.m_9236_(), pPlayer);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)IWRecipes.WOODCUTTING.get(), (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (pIndex >= 2 && pIndex < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : pIndex >= 29 && pIndex < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, this.container));
    }
}

