/*
 * Decompiled with CFR 0.152.
 */
package io.github.dimaskama.visualkeys.client;

import com.mojang.serialization.Codec;
import io.github.dimaskama.visualkeys.client.KeyboardRenderOptions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public class KeyEntry {
    public final int code;
    public final Type type;
    public final String name;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final ArrayList<Bind> binds = new ArrayList();
    @Nullable
    public List<class_2561> tooltipTexts;
    @Nullable
    public class_2561 firstBindText = null;

    public KeyEntry(int code, Type type, String name, int x, int y, int width, int height) {
        this.code = code;
        this.type = type;
        this.name = name;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX(KeyboardRenderOptions options) {
        return this.x + this.type.getOffsetX(options);
    }

    public int getY(KeyboardRenderOptions options) {
        return this.y + this.type.getOffsetY(options);
    }

    public static enum Type implements class_3542
    {
        MAIN("main"),
        FUNCTION("function"),
        MID("mid"),
        NUMPAD("numpad");

        public static final Codec<Type> CODEC;
        private final String key;

        private Type(String key) {
            this.key = key;
        }

        public String method_15434() {
            return this.key;
        }

        public boolean isVisible(KeyboardRenderOptions options) {
            return switch (this.ordinal()) {
                case 1 -> options.functionVisible;
                case 2 -> options.midVisible;
                case 3 -> options.numpadVisible;
                default -> true;
            };
        }

        public int getOffsetX(KeyboardRenderOptions options) {
            if (this == NUMPAD && !options.midVisible) {
                return -325;
            }
            return 0;
        }

        public int getOffsetY(KeyboardRenderOptions options) {
            if (!(this != MAIN && this != NUMPAD || options.functionVisible || options.midVisible)) {
                return -150;
            }
            return 0;
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }

    public record Bind(int code, class_2561 text, class_2561 textWithCategory) {
    }
}

