/*
 * Decompiled with CFR 0.152.
 */
package io.github.dimaskama.visualkeys.client;

import io.github.dimaskama.visualkeys.client.KeyEntry;
import io.github.dimaskama.visualkeys.client.KeyboardRenderOptions;
import io.github.dimaskama.visualkeys.client.VisualKeys;
import io.github.dimaskama.visualkeys.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class KeyboardRenderer {
    private static final class_2960 KEYS_TEXTURE = class_2960.method_60655((String)"visualkeys", (String)"textures/gui/key_buttons.png");

    public static void render(class_332 context, Iterable<KeyEntry> keys, KeyboardRenderOptions options) {
        int texPadding = 2;
        int padding = 5;
        int x = options.keyboardX;
        int y = options.keyboardY;
        float scale = options.keyboardScale;
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)x, (float)y);
        class_1041 window = class_310.method_1551().method_22683();
        if (((ModConfig.Data)VisualKeys.CONFIG.getData()).keyboardTextured) {
            for (KeyEntry key : keys) {
                float f;
                float u;
                if (!key.type.isVisible(options)) continue;
                code = key.code;
                pressed = code >= 0 && class_3675.method_15987((class_1041)window, (int)code);
                int w = key.width;
                int h = key.height;
                float kX1 = (float)(key.getX(options) + texPadding) * scale;
                float kY1 = (float)(key.getY(options) + texPadding) * scale;
                float kW = (float)(w - (texPadding << 1)) * scale;
                float kH = (float)(h - (texPadding << 1)) * scale;
                float f2 = u = pressed ? (float)w * 0.2f : 0.0f;
                if (h == 200) {
                    f = 160.0f;
                } else {
                    switch (w) {
                        case 125: {
                            f = 20.0f;
                            break;
                        }
                        case 150: {
                            f = 40.0f;
                            break;
                        }
                        case 175: {
                            f = 60.0f;
                            break;
                        }
                        case 200: {
                            f = 80.0f;
                            break;
                        }
                        case 225: {
                            f = 100.0f;
                            break;
                        }
                        case 275: {
                            f = 120.0f;
                            break;
                        }
                        case 625: {
                            f = 140.0f;
                            break;
                        }
                        default: {
                            f = 0.0f;
                        }
                    }
                }
                float v = f;
                context.method_25302(class_10799.field_56883, KEYS_TEXTURE, (int)kX1, (int)kY1, u, v, (int)kW, (int)kH, (int)(0.2f * (float)w), (int)(0.2f * (float)h), 256, 256);
            }
        } else {
            for (KeyEntry key : keys) {
                if (!key.type.isVisible(options)) continue;
                code = key.code;
                pressed = code >= 0 && class_3675.method_15987((class_1041)window, (int)code);
                float kX1 = (float)(key.getX(options) + padding) * scale;
                float kY1 = (float)(key.getY(options) + padding) * scale;
                float kX2 = kX1 + (float)(key.width - (padding << 1)) * scale;
                float kY2 = kY1 + (float)(key.height - (padding << 1)) * scale;
                context.method_25294((int)kX1, (int)kY1, (int)kX2, (int)kY2, pressed ? -1719697486 : -13421646);
            }
        }
        float textScale = scale * 2.0f;
        context.method_51448().scale(textScale, textScale);
        class_327 textRenderer = class_310.method_1551().field_1772;
        long time = class_156.method_658();
        for (KeyEntry key : keys) {
            if (!key.type.isVisible(options)) continue;
            int sX = key.getX(options) + padding >> 1;
            int sY = key.getY(options) + padding >> 1;
            context.method_25303(textRenderer, key.name, sX + 5, sY + 4, -1);
            if (key.firstBindText == null) continue;
            int sW = key.width - (padding << 1) >> 1;
            int sH = key.height - (padding << 1) >> 1;
            KeyboardRenderer.renderScrollingText(context, textRenderer, key.firstBindText, sX + 5, sY + 15, sW - 8, sH - 20, time);
        }
        context.method_51448().popMatrix();
    }

    public static void renderMouseOverlay(class_332 context, Iterable<KeyEntry> keys, KeyboardRenderOptions options, int mouseX, int mouseY) {
        int mX = (int)((float)(mouseX - options.keyboardX) / options.keyboardScale);
        int mY = (int)((float)(mouseY - options.keyboardY) / options.keyboardScale);
        if (mX < 0 || mY < 0 || mX >= options.getCurrentWidth() || mY >= options.getCurrentHeight()) {
            return;
        }
        for (KeyEntry key : keys) {
            ArrayList<KeyEntry.Bind> binds = key.binds;
            if (binds.isEmpty()) continue;
            int x = key.getX(options);
            int y = key.getY(options);
            if (mX < x || mY < y || mX >= x + key.width || mY >= y + key.height) continue;
            context.method_51434(class_310.method_1551().field_1772, Objects.requireNonNullElseGet(key.tooltipTexts, () -> {
                key.tooltipTexts = binds.stream().map(KeyEntry.Bind::textWithCategory).toList();
                return key.tooltipTexts;
            }), mouseX, mouseY);
            break;
        }
    }

    private static void renderScrollingText(class_332 context, class_327 textRenderer, class_2561 text, int x, int y, int width, int height, long time) {
        int scrollTime = 1000;
        int textWidth = textRenderer.method_27525((class_5348)text);
        if (textWidth > width) {
            boolean scissor;
            List list = textRenderer.method_1728((class_5348)text, width);
            int h = list.size() * 10 - 1;
            boolean bl = scissor = h > height;
            if (scissor) {
                context.method_44379(x, y, x + width + 2, y + height + 2);
                int mod = (int)(time % (long)(scrollTime << 2));
                int maxScroll = h - height;
                int scroll = mod < scrollTime ? 0 : (mod < scrollTime << 1 ? (int)((float)(mod - scrollTime) / (float)scrollTime * (float)maxScroll) : (mod < (scrollTime << 1) + scrollTime ? maxScroll : (int)((float)((scrollTime << 2) - mod) / (float)scrollTime * (float)maxScroll)));
                y -= scroll;
            } else {
                y += height - h;
            }
            for (class_5481 t : list) {
                context.method_35720(textRenderer, t, x + (width - textRenderer.method_30880(t)), y, -1);
                y += 10;
            }
            if (scissor) {
                context.method_44380();
            }
        } else {
            context.method_27535(textRenderer, text, x + (width - textWidth), y + height - 9, -1);
        }
    }
}

