/*
 * Decompiled with CFR 0.152.
 */
package io.github.dimaskama.visualkeys.client;

import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import io.github.dimaskama.visualkeys.client.KeyEntry;
import io.github.dimaskama.visualkeys.client.KeyboardRenderer;
import io.github.dimaskama.visualkeys.client.screen.KeyboardScreen;
import io.github.dimaskama.visualkeys.config.ModConfig;
import io.github.dimaskama.visualkeys.mixin.KeyBindingAccessor;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisualKeys
implements ClientModInitializer {
    public static final String MOD_ID = "visualkeys";
    public static final Logger LOGGER = LogManager.getLogger((String)"VisualKeys");
    public static final ModConfig CONFIG = new ModConfig("config/visualkeys.json");
    public static final QwertyKeyboard QWERTY = new QwertyKeyboard();

    public void onInitializeClient() {
        CONFIG.loadOrCreate();
        ((ModConfig.Data)VisualKeys.CONFIG.getData()).enabled &= ((ModConfig.Data)VisualKeys.CONFIG.getData()).saveEnabledState;
        QWERTY.init();
    }

    public static void onRender(class_332 context) {
        if (((ModConfig.Data)VisualKeys.CONFIG.getData()).enabled) {
            KeyboardRenderer.render(context, (Iterable<KeyEntry>)VisualKeys.QWERTY.map.values(), ((ModConfig.Data)VisualKeys.CONFIG.getData()).hudRenderOptions);
        }
    }

    public static void onUpdateKeyBindings() {
        Stream<KeyEntry.Bind> binds = KeyBindingAccessor.visualkeys_getKeysById().values().stream().filter(b -> ((KeyBindingAccessor)b).visualkeys_getBoundKey().method_1442() == class_3675.class_307.field_1668).map(b -> {
            class_5250 text = class_2561.method_43471((String)b.method_1431());
            return new KeyEntry.Bind(((KeyBindingAccessor)b).visualkeys_getBoundKey().method_1444(), (class_2561)text, (class_2561)class_2561.method_43473().method_10852(b.method_1423().method_74697()).method_27693(": ").method_10852((class_2561)text));
        });
        if (FabricLoader.getInstance().isModLoaded("malilib")) {
            binds = Stream.concat(binds, InputEventHandler.getKeybindManager().getKeybindCategories().stream().flatMap(c -> {
                ArrayList<KeyEntry.Bind> list = new ArrayList<KeyEntry.Bind>();
                for (IHotkey h : c.getHotkeys()) {
                    if (h.getKeybind().getKeys().isEmpty()) continue;
                    class_5250 text = class_2561.method_43470((String)h.getPrettyName());
                    list.add(new KeyEntry.Bind((Integer)h.getKeybind().getKeys().getLast(), (class_2561)text, (class_2561)class_2561.method_43470((String)c.getModName()).method_27693(": ").method_10852((class_2561)text)));
                }
                return list.stream();
            }));
        }
        for (KeyEntry entry : VisualKeys.QWERTY.map.values()) {
            entry.binds.clear();
            entry.tooltipTexts = null;
            entry.firstBindText = null;
        }
        binds.forEach(bind -> {
            KeyEntry entry = (KeyEntry)VisualKeys.QWERTY.map.get(bind.code());
            if (entry != null) {
                entry.binds.addFirst((KeyEntry.Bind)bind);
                entry.firstBindText = bind.text();
            }
        });
    }

    public static class_4185 createOpenKeyboardButton(class_310 client, class_437 screen) {
        return class_4185.method_46430((class_2561)class_2561.method_43471((String)"visualkeys.open_keyboard"), button -> client.method_1507((class_437)new KeyboardScreen(screen))).method_46437(100, 20).method_46431();
    }

    public static String keyCategoryToString(class_304.class_11900 category) {
        class_2960 id = category.comp_4879();
        return "minecraft".equals(id.method_12836()) ? id.method_12832() : id.toString();
    }

    public static class QwertyKeyboard {
        public final Int2ObjectMap<KeyEntry> map = new Int2ObjectArrayMap();

        public void init() {
            this.putKey(256, KeyEntry.Type.FUNCTION, "Esc", 0, 0);
            this.putKey(290, KeyEntry.Type.FUNCTION, "F1", 200, 0);
            this.putKey(291, KeyEntry.Type.FUNCTION, "F2", 300, 0);
            this.putKey(292, KeyEntry.Type.FUNCTION, "F3", 400, 0);
            this.putKey(293, KeyEntry.Type.FUNCTION, "F4", 500, 0);
            this.putKey(294, KeyEntry.Type.FUNCTION, "F5", 650, 0);
            this.putKey(295, KeyEntry.Type.FUNCTION, "F6", 750, 0);
            this.putKey(296, KeyEntry.Type.FUNCTION, "F7", 850, 0);
            this.putKey(297, KeyEntry.Type.FUNCTION, "F8", 950, 0);
            this.putKey(298, KeyEntry.Type.FUNCTION, "F9", 1100, 0);
            this.putKey(299, KeyEntry.Type.FUNCTION, "F10", 1200, 0);
            this.putKey(300, KeyEntry.Type.FUNCTION, "F11", 1300, 0);
            this.putKey(301, KeyEntry.Type.FUNCTION, "F12", 1400, 0);
            this.putKey(96, "~", 0, 150);
            this.putKey(49, "1", 100, 150);
            this.putKey(50, "2", 200, 150);
            this.putKey(51, "3", 300, 150);
            this.putKey(52, "4", 400, 150);
            this.putKey(53, "5", 500, 150);
            this.putKey(54, "6", 600, 150);
            this.putKey(55, "7", 700, 150);
            this.putKey(56, "8", 800, 150);
            this.putKey(57, "9", 900, 150);
            this.putKey(48, "0", 1000, 150);
            this.putKey(45, "-", 1100, 150);
            this.putKey(61, "=", 1200, 150);
            this.putKey(259, "Backspace", 1300, 150, 200, 100);
            this.putKey(258, "Tab", 0, 250, 150, 100);
            this.putKey(81, "Q", 150, 250);
            this.putKey(87, "W", 250, 250);
            this.putKey(69, "E", 350, 250);
            this.putKey(82, "R", 450, 250);
            this.putKey(84, "T", 550, 250);
            this.putKey(89, "Y", 650, 250);
            this.putKey(85, "U", 750, 250);
            this.putKey(73, "I", 850, 250);
            this.putKey(79, "O", 950, 250);
            this.putKey(80, "P", 1050, 250);
            this.putKey(91, "[", 1150, 250);
            this.putKey(93, "]", 1250, 250);
            this.putKey(92, "\\", 1350, 250, 150, 100);
            this.putKey(280, "CapsLock", 0, 350, 175, 100);
            this.putKey(65, "A", 175, 350);
            this.putKey(83, "S", 275, 350);
            this.putKey(68, "D", 375, 350);
            this.putKey(70, "F", 475, 350);
            this.putKey(71, "G", 575, 350);
            this.putKey(72, "H", 675, 350);
            this.putKey(74, "J", 775, 350);
            this.putKey(75, "K", 875, 350);
            this.putKey(76, "L", 975, 350);
            this.putKey(59, ";", 1075, 350);
            this.putKey(39, "'", 1175, 350);
            this.putKey(257, "Enter", 1275, 350, 225, 100);
            this.putKey(340, "Shift", 0, 450, 225, 100);
            this.putKey(90, "Z", 225, 450);
            this.putKey(88, "X", 325, 450);
            this.putKey(67, "C", 425, 450);
            this.putKey(86, "V", 525, 450);
            this.putKey(66, "B", 625, 450);
            this.putKey(78, "N", 725, 450);
            this.putKey(77, "M", 825, 450);
            this.putKey(44, ",", 925, 450);
            this.putKey(46, ".", 1025, 450);
            this.putKey(47, "/", 1125, 450);
            this.putKey(344, "Shift", 1225, 450, 275, 100);
            this.putKey(341, "Ctrl", 0, 550, 125, 100);
            this.putKey(-4, "Win", 125, 550, 125, 100);
            this.putKey(342, "Alt", 250, 550, 125, 100);
            this.putKey(32, "Space", 375, 550, 625, 100);
            this.putKey(346, "Alt", 1000, 550, 125, 100);
            this.putKey(-3, "Win", 1125, 550, 125, 100);
            this.putKey(-2, "Fn", 1250, 550, 125, 100);
            this.putKey(345, "Ctrl", 1375, 550, 125, 100);
            this.putKey(283, KeyEntry.Type.MID, "PrtScn", 1525, 0);
            this.putKey(281, KeyEntry.Type.MID, "ScrLck", 1625, 0);
            this.putKey(284, KeyEntry.Type.MID, "Pause", 1725, 0);
            this.putKey(260, KeyEntry.Type.MID, "Insert", 1525, 150);
            this.putKey(268, KeyEntry.Type.MID, "Home", 1625, 150);
            this.putKey(266, KeyEntry.Type.MID, "PgUp", 1725, 150);
            this.putKey(261, KeyEntry.Type.MID, "Delete", 1525, 250);
            this.putKey(269, KeyEntry.Type.MID, "End", 1625, 250);
            this.putKey(267, KeyEntry.Type.MID, "PgDown", 1725, 250);
            this.putKey(265, KeyEntry.Type.MID, "Up", 1625, 450);
            this.putKey(263, KeyEntry.Type.MID, "Left", 1525, 550);
            this.putKey(264, KeyEntry.Type.MID, "Down", 1625, 550);
            this.putKey(262, KeyEntry.Type.MID, "Right", 1725, 550);
            this.putKey(282, KeyEntry.Type.NUMPAD, "NumLk", 1850, 150);
            this.putKey(331, KeyEntry.Type.NUMPAD, "/", 1950, 150);
            this.putKey(332, KeyEntry.Type.NUMPAD, "*", 2050, 150);
            this.putKey(333, KeyEntry.Type.NUMPAD, "-", 2150, 150);
            this.putKey(327, KeyEntry.Type.NUMPAD, "7", 1850, 250);
            this.putKey(328, KeyEntry.Type.NUMPAD, "8", 1950, 250);
            this.putKey(329, KeyEntry.Type.NUMPAD, "9", 2050, 250);
            this.putKey(334, KeyEntry.Type.NUMPAD, "+", 2150, 250, 100, 200);
            this.putKey(324, KeyEntry.Type.NUMPAD, "4", 1850, 350);
            this.putKey(325, KeyEntry.Type.NUMPAD, "5", 1950, 350);
            this.putKey(326, KeyEntry.Type.NUMPAD, "6", 2050, 350);
            this.putKey(321, KeyEntry.Type.NUMPAD, "1", 1850, 450);
            this.putKey(322, KeyEntry.Type.NUMPAD, "2", 1950, 450);
            this.putKey(323, KeyEntry.Type.NUMPAD, "3", 2050, 450);
            this.putKey(335, KeyEntry.Type.NUMPAD, "Enter", 2150, 450, 100, 200);
            this.putKey(320, KeyEntry.Type.NUMPAD, "0", 1850, 550, 200, 100);
            this.putKey(330, KeyEntry.Type.NUMPAD, ".", 2050, 550);
        }

        private void putKey(int code, String name, int x, int y) {
            this.putKey(code, KeyEntry.Type.MAIN, name, x, y);
        }

        private void putKey(int code, String name, int x, int y, int width, int height) {
            this.putKey(code, KeyEntry.Type.MAIN, name, x, y, width, height);
        }

        private void putKey(int code, KeyEntry.Type type, String name, int x, int y) {
            this.putKey(code, type, name, x, y, 100, 100);
        }

        private void putKey(int code, KeyEntry.Type type, String name, int x, int y, int width, int height) {
            this.map.put(code, (Object)new KeyEntry(code, type, name, x, y, width, height));
        }
    }
}

