/*
 * Decompiled with CFR 0.152.
 */
package io.github.dimaskama.visualkeys.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.dimaskama.visualkeys.client.VisualKeys;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;

public abstract class JsonConfig<D> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final transient String path;
    private final D data;

    public JsonConfig(String path) {
        this.path = path;
        this.data = this.createDefaultData();
    }

    protected abstract Codec<D> getCodec();

    protected abstract D createDefaultData();

    public String getPath() {
        return this.path;
    }

    public D getData() {
        return this.data;
    }

    public void loadOrCreate() {
        File file = new File(this.getPath());
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                VisualKeys.LOGGER.warn("Can't create config: " + file.getAbsolutePath());
                return;
            }
            try {
                this.saveWithoutCatch();
            }
            catch (IOException e) {
                VisualKeys.LOGGER.warn("Exception occurred while writing new config. ", (Throwable)e);
            }
        } else {
            this.load(file);
        }
    }

    private void load(File file) {
        try (FileReader f = new FileReader(file);){
            this.deserialize(JsonParser.parseReader((Reader)f));
        }
        catch (Exception e) {
            VisualKeys.LOGGER.warn("Exception occurred while reading config. ", (Throwable)e);
        }
    }

    protected void deserialize(JsonElement element) {
        Object d = ((Pair)this.getCodec().decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow()).getFirst();
        for (Field field : d.getClass().getDeclaredFields()) {
            try {
                if (!JsonConfig.isAcceptedModifiers(field.getModifiers())) continue;
                field.set(this.data, field.get(d));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public void save() {
        this.save(true);
    }

    public void save(boolean log) {
        try {
            this.saveWithoutCatch();
            if (log) {
                VisualKeys.LOGGER.info("Config saved: " + this.getPath());
            }
        }
        catch (IOException e) {
            VisualKeys.LOGGER.warn("Exception occurred while saving config. ", (Throwable)e);
        }
    }

    public void saveWithoutCatch() throws IOException {
        try (FileWriter w = new FileWriter(this.getPath());){
            GSON.toJson(this.serialize(), (Appendable)w);
        }
    }

    protected JsonElement serialize() {
        return (JsonElement)this.getCodec().encode(this.data, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow();
    }

    public void reset() {
        D newData = this.createDefaultData();
        for (Field field : newData.getClass().getDeclaredFields()) {
            if (!JsonConfig.isAcceptedModifiers(field.getModifiers())) continue;
            try {
                field.set(this.data, field.get(newData));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static boolean isAcceptedModifiers(int mod) {
        return (mod & 0x90) == 0 && (mod & 1) != 0;
    }
}

