/*
 * Decompiled with CFR 0.152.
 */
package io.github.dimaskama.visualkeys.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.dimaskama.visualkeys.client.KeyboardRenderOptions;
import io.github.dimaskama.visualkeys.config.JsonConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModConfig
extends JsonConfig<Data> {
    public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(d -> d.enabled), (App)Codec.BOOL.fieldOf("save_enabled_state").forGetter(d -> d.saveEnabledState), (App)Codec.BOOL.fieldOf("keyboard_textured").forGetter(d -> d.keyboardTextured), (App)KeyboardRenderOptions.CODEC.fieldOf("hud_render_options").forGetter(d -> d.hudRenderOptions), (App)Codec.STRING.listOf().optionalFieldOf("collapsed_categories", List.of()).forGetter(Data::getCollapsedCategoriesAsList)).apply((Applicative)instance, Data::new));
    private boolean dirty;

    public ModConfig(String path) {
        super(path);
    }

    @Override
    protected Codec<Data> getCodec() {
        return CODEC;
    }

    @Override
    protected Data createDefaultData() {
        return new Data(false, false, true, new KeyboardRenderOptions(0, 0, 0.25f, true, true, true), List.of());
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void saveIfDirty() {
        if (this.dirty) {
            this.save();
            this.dirty = false;
        }
    }

    public static class Data {
        public boolean enabled;
        public boolean saveEnabledState;
        public boolean keyboardTextured;
        public KeyboardRenderOptions hudRenderOptions;
        public Set<String> collapsedCategories;

        public Data(boolean enabled, boolean saveEnabledState, boolean keyboardTextured, KeyboardRenderOptions hudRenderOptions, List<String> collapsedCategories) {
            this.enabled = enabled;
            this.saveEnabledState = saveEnabledState;
            this.keyboardTextured = keyboardTextured;
            this.hudRenderOptions = hudRenderOptions;
            this.collapsedCategories = new HashSet<String>(collapsedCategories);
        }

        public List<String> getCollapsedCategoriesAsList() {
            return List.copyOf(this.collapsedCategories);
        }
    }
}

