/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.copperoxidizer;

import com.easeon.ss.copperoxidizer.Easeon;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class OxidationHandler {
    private static final Map<class_2248, class_2248> OXIDATION_MAP = new HashMap<class_2248, class_2248>();

    private static void addCopperBlockMapping(String base, String exposed, String weathered, String oxidized) {
        try {
            class_2248 baseBlock = (class_2248)class_7923.field_41175.method_63535(class_2960.method_60656((String)base));
            class_2248 exposedBlock = (class_2248)class_7923.field_41175.method_63535(class_2960.method_60656((String)exposed));
            class_2248 weatheredBlock = (class_2248)class_7923.field_41175.method_63535(class_2960.method_60656((String)weathered));
            class_2248 oxidizedBlock = (class_2248)class_7923.field_41175.method_63535(class_2960.method_60656((String)oxidized));
            if (!baseBlock.equals(class_2246.field_10124) && !exposedBlock.equals(class_2246.field_10124)) {
                OXIDATION_MAP.put(baseBlock, exposedBlock);
                OXIDATION_MAP.put(exposedBlock, weatheredBlock);
                OXIDATION_MAP.put(weatheredBlock, oxidizedBlock);
                Easeon.LOGGER.info("Added oxidation mapping for: {}", (Object)base);
            }
        }
        catch (Exception e) {
            Easeon.LOGGER.debug("Block not found: {} (probably not in this version)", (Object)base);
        }
    }

    public static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (!Easeon.CONFIG.isEnabled()) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = player.method_5998(hand);
        if (!heldItem.method_31574(class_1802.field_8574) || !OxidationHandler.isWaterBottle(heldItem)) {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (OxidationHandler.isWaxed(block)) {
            return class_1269.field_5811;
        }
        class_2248 nextBlock = OxidationHandler.getNextOxidationStage(block);
        if (nextBlock == null) {
            return class_1269.field_5811;
        }
        if (world.method_8608()) {
            return class_1269.field_21466;
        }
        class_2680 newState = nextBlock.method_9564();
        for (class_2769 property : state.method_28501()) {
            if (!newState.method_28498(property)) continue;
            newState = OxidationHandler.copyProperty(state, newState, property);
        }
        world.method_8501(pos, newState);
        if (Easeon.CONFIG.shouldConsumeWater() && !player.method_31549().field_7477) {
            heldItem.method_7934(1);
            class_1799 emptyBottle = new class_1799((class_1935)class_1802.field_8469);
            if (!player.method_31548().method_7394(emptyBottle)) {
                player.method_7328(emptyBottle, false);
            }
        }
        if (Easeon.CONFIG.shouldShowParticles() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_65096((class_2394)class_2398.field_29642, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.3, 0.3, 0.3, 0.1);
        }
        if (Easeon.CONFIG.shouldPlaySound()) {
            world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
        }
        return class_1269.field_21466;
    }

    private static boolean isWaterBottle(class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8574)) {
            return false;
        }
        class_1844 potionContents = (class_1844)stack.method_58694(class_9334.field_49651);
        if (potionContents == null) {
            return false;
        }
        boolean hasEffects = false;
        Iterator iterator = potionContents.method_57397().iterator();
        if (iterator.hasNext()) {
            class_1293 effect = (class_1293)iterator.next();
            hasEffects = true;
        }
        return !hasEffects;
    }

    private static boolean isWaxed(class_2248 block) {
        String blockName = block.method_63499();
        return blockName.contains("waxed");
    }

    private static class_2248 getNextOxidationStage(class_2248 block) {
        return OXIDATION_MAP.get(block);
    }

    private static <T extends Comparable<T>> class_2680 copyProperty(class_2680 from, class_2680 to, class_2769<?> property) {
        return (class_2680)to.method_11657(property, from.method_11654(property));
    }

    static {
        OXIDATION_MAP.put(class_2246.field_27119, class_2246.field_27118);
        OXIDATION_MAP.put(class_2246.field_27118, class_2246.field_27117);
        OXIDATION_MAP.put(class_2246.field_27117, class_2246.field_27116);
        OXIDATION_MAP.put(class_2246.field_27124, class_2246.field_27123);
        OXIDATION_MAP.put(class_2246.field_27123, class_2246.field_27122);
        OXIDATION_MAP.put(class_2246.field_27122, class_2246.field_27121);
        OXIDATION_MAP.put(class_2246.field_27128, class_2246.field_27127);
        OXIDATION_MAP.put(class_2246.field_27127, class_2246.field_27126);
        OXIDATION_MAP.put(class_2246.field_27126, class_2246.field_27125);
        OXIDATION_MAP.put(class_2246.field_27132, class_2246.field_27131);
        OXIDATION_MAP.put(class_2246.field_27131, class_2246.field_27130);
        OXIDATION_MAP.put(class_2246.field_27130, class_2246.field_27129);
        OXIDATION_MAP.put(class_2246.field_47072, class_2246.field_47073);
        OXIDATION_MAP.put(class_2246.field_47073, class_2246.field_47074);
        OXIDATION_MAP.put(class_2246.field_47074, class_2246.field_47075);
        OXIDATION_MAP.put(class_2246.field_47040, class_2246.field_47041);
        OXIDATION_MAP.put(class_2246.field_47041, class_2246.field_47043);
        OXIDATION_MAP.put(class_2246.field_47043, class_2246.field_47042);
        OXIDATION_MAP.put(class_2246.field_47048, class_2246.field_47049);
        OXIDATION_MAP.put(class_2246.field_47049, class_2246.field_47051);
        OXIDATION_MAP.put(class_2246.field_47051, class_2246.field_47050);
        OXIDATION_MAP.put(class_2246.field_47064, class_2246.field_47065);
        OXIDATION_MAP.put(class_2246.field_47065, class_2246.field_47066);
        OXIDATION_MAP.put(class_2246.field_47066, class_2246.field_47067);
        OXIDATION_MAP.put(class_2246.field_47057, class_2246.field_47056);
        OXIDATION_MAP.put(class_2246.field_47056, class_2246.field_47055);
        OXIDATION_MAP.put(class_2246.field_47055, class_2246.field_47054);
        OxidationHandler.addCopperBlockMapping("copper_chest", "exposed_copper_chest", "weathered_copper_chest", "oxidized_copper_chest");
        OxidationHandler.addCopperBlockMapping("copper_bars", "exposed_copper_bars", "weathered_copper_bars", "oxidized_copper_bars");
        OxidationHandler.addCopperBlockMapping("copper_chain", "exposed_copper_chain", "weathered_copper_chain", "oxidized_copper_chain");
        OxidationHandler.addCopperBlockMapping("copper_lantern", "exposed_copper_lantern", "weathered_copper_lantern", "oxidized_copper_lantern");
        OxidationHandler.addCopperBlockMapping("copper_golem_statue", "exposed_copper_golem_statue", "weathered_copper_golem_statue", "oxidized_copper_golem_statue");
        OxidationHandler.addCopperBlockMapping("lightning_rod", "exposed_lightning_rod", "weathered_lightning_rod", "oxidized_lightning_rod");
        Easeon.LOGGER.info("Copper Oxidizer: {} oxidation mappings loaded", (Object)OXIDATION_MAP.size());
    }
}

