/*
 * Decompiled with CFR 0.152.
 */
package com.deft;

import com.deft.SafeStepConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ClientSafeStepManager {
    private static int tickCounter = 0;
    private static boolean wasProtectedLastTick = false;

    public static void checkSafeStep(class_746 player) {
        if (!SafeStepConfig.ENABLED) {
            wasProtectedLastTick = false;
            return;
        }
        if (++tickCounter < SafeStepConfig.CHECK_INTERVAL) {
            return;
        }
        tickCounter = 0;
        if (ClientSafeStepManager.shouldSkipPlayer(player)) {
            wasProtectedLastTick = false;
            return;
        }
        class_243 playerPos = player.method_19538();
        class_243 lookDirection = player.method_5720();
        class_243 forwardVector = new class_243(lookDirection.field_1352, 0.0, lookDirection.field_1350).method_1029();
        class_243 predictedPos = playerPos.method_1019(forwardVector.method_1021(SafeStepConfig.PREDICTION_DISTANCE));
        int dropHeight = ClientSafeStepManager.calculateDropHeight(player.method_37908(), predictedPos);
        if (dropHeight >= SafeStepConfig.DROP_HEIGHT_THRESHOLD) {
            ClientSafeStepManager.applySafeStepProtection(player, forwardVector);
            wasProtectedLastTick = true;
        } else {
            wasProtectedLastTick = false;
        }
    }

    private static boolean shouldSkipPlayer(class_746 player) {
        return player.method_31549().field_7479 || player.method_6128() || player.method_7337() || player.method_7325() || player.method_5715() || !player.method_24828() || player.method_6059(class_1294.field_5906);
    }

    private static int calculateDropHeight(class_1937 world, class_243 position) {
        class_2338 checkPos;
        class_2680 blockState;
        class_2338 startPos = class_2338.method_49637((double)position.field_1352, (double)(position.field_1351 - 0.1), (double)position.field_1350);
        int dropHeight = 0;
        for (int i = 0; i < SafeStepConfig.MAX_SCAN_DEPTH && ((blockState = world.method_8320(checkPos = startPos.method_10087(i))).method_26215() || blockState.method_26220((class_1922)world, checkPos).method_1110()); ++i) {
            ++dropHeight;
        }
        return dropHeight;
    }

    private static void applySafeStepProtection(class_746 player, class_243 forwardVector) {
        class_243 currentVelocity = player.method_18798();
        player.method_18800(0.0, currentVelocity.field_1351, 0.0);
        if (SafeStepConfig.NUDGE_BACK_DISTANCE > 0.0) {
            class_243 nudgeBack = forwardVector.method_1021(-SafeStepConfig.NUDGE_BACK_DISTANCE);
            player.method_5814(player.method_23317() + nudgeBack.field_1352, player.method_23318(), player.method_23321() + nudgeBack.field_1350);
        }
        player.field_6017 = 0.0f;
        if (SafeStepConfig.PLAY_WARNING_SOUNDS && !wasProtectedLastTick) {
            player.method_5783((class_3414)class_3417.field_14622.comp_349(), SafeStepConfig.WARNING_SOUND_VOLUME, SafeStepConfig.WARNING_SOUND_PITCH);
        }
        if (SafeStepConfig.SHOW_WARNING_MESSAGES && !wasProtectedLastTick) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eSafe Step: Dangerous drop detected!"), true);
        }
    }
}

