/*
 * Decompiled with CFR 0.152.
 */
package com.deft;

import com.deft.DeftsafetySteps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class SafeStepConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;
    public static boolean ENABLED;
    public static double PREDICTION_DISTANCE;
    public static int DROP_HEIGHT_THRESHOLD;
    public static int MAX_SCAN_DEPTH;
    public static double NUDGE_BACK_DISTANCE;
    public static int CHECK_INTERVAL;
    public static boolean PLAY_WARNING_SOUNDS;
    public static boolean SHOW_WARNING_MESSAGES;
    public static float WARNING_SOUND_VOLUME;
    public static float WARNING_SOUND_PITCH;

    public static void init(File configDir) {
        configFile = new File(configDir, "deft-safe-step.json");
        SafeStepConfig.load();
    }

    public static void load() {
        if (configFile == null || !configFile.exists()) {
            SafeStepConfig.save();
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            if (data != null) {
                ENABLED = data.enabled;
                PREDICTION_DISTANCE = data.predictionDistance;
                DROP_HEIGHT_THRESHOLD = data.dropHeightThreshold;
                MAX_SCAN_DEPTH = data.maxScanDepth;
                NUDGE_BACK_DISTANCE = data.nudgeBackDistance;
                CHECK_INTERVAL = data.checkInterval;
                PLAY_WARNING_SOUNDS = data.playWarningSounds;
                SHOW_WARNING_MESSAGES = data.showWarningMessages;
                WARNING_SOUND_VOLUME = data.warningSoundVolume;
                WARNING_SOUND_PITCH = data.warningSoundPitch;
            }
            SafeStepConfig.validateConfig();
            DeftsafetySteps.LOGGER.info("Deft Safe Step configuration loaded");
        }
        catch (IOException e) {
            DeftsafetySteps.LOGGER.error("Failed to load config: {}", (Object)e.getMessage());
            SafeStepConfig.save();
        }
    }

    public static void save() {
        if (configFile == null) {
            return;
        }
        SafeStepConfig.validateConfig();
        ConfigData data = new ConfigData();
        data.enabled = ENABLED;
        data.predictionDistance = PREDICTION_DISTANCE;
        data.dropHeightThreshold = DROP_HEIGHT_THRESHOLD;
        data.maxScanDepth = MAX_SCAN_DEPTH;
        data.nudgeBackDistance = NUDGE_BACK_DISTANCE;
        data.checkInterval = CHECK_INTERVAL;
        data.playWarningSounds = PLAY_WARNING_SOUNDS;
        data.showWarningMessages = SHOW_WARNING_MESSAGES;
        data.warningSoundVolume = WARNING_SOUND_VOLUME;
        data.warningSoundPitch = WARNING_SOUND_PITCH;
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            DeftsafetySteps.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    public static void validateConfig() {
        PREDICTION_DISTANCE = Math.max(0.1, Math.min(2.0, PREDICTION_DISTANCE));
        DROP_HEIGHT_THRESHOLD = Math.max(1, Math.min(10, DROP_HEIGHT_THRESHOLD));
        MAX_SCAN_DEPTH = Math.max(2, Math.min(20, MAX_SCAN_DEPTH));
        NUDGE_BACK_DISTANCE = Math.max(0.0, Math.min(0.5, NUDGE_BACK_DISTANCE));
        CHECK_INTERVAL = Math.max(1, Math.min(20, CHECK_INTERVAL));
        WARNING_SOUND_VOLUME = Math.max(0.0f, Math.min(1.0f, WARNING_SOUND_VOLUME));
        WARNING_SOUND_PITCH = Math.max(0.5f, Math.min(2.0f, WARNING_SOUND_PITCH));
    }

    static {
        ENABLED = true;
        PREDICTION_DISTANCE = 0.6;
        DROP_HEIGHT_THRESHOLD = 2;
        MAX_SCAN_DEPTH = 6;
        NUDGE_BACK_DISTANCE = 0.1;
        CHECK_INTERVAL = 3;
        PLAY_WARNING_SOUNDS = true;
        SHOW_WARNING_MESSAGES = true;
        WARNING_SOUND_VOLUME = 0.3f;
        WARNING_SOUND_PITCH = 2.0f;
    }

    private static class ConfigData {
        boolean enabled = true;
        double predictionDistance = 0.6;
        int dropHeightThreshold = 2;
        int maxScanDepth = 6;
        double nudgeBackDistance = 0.1;
        int checkInterval = 3;
        boolean playWarningSounds = true;
        boolean showWarningMessages = true;
        float warningSoundVolume = 0.3f;
        float warningSoundPitch = 2.0f;

        private ConfigData() {
        }
    }
}

