/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opoliscompat.kubejs;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.opoliscompat.kubejs.NonNullListChanceResultComponent;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChanceResultComponent
implements RecipeComponent<ChanceResult> {
    public static final ChanceResultComponent CHANCE_RESULT = new ChanceResultComponent();
    public static final RecipeComponentType<?> CONDITION = RecipeComponentType.unit((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"chance_result"), (RecipeComponent)CHANCE_RESULT);

    public RecipeComponentType<?> type() {
        return CONDITION;
    }

    public Codec<ChanceResult> codec() {
        return ChanceResult.CODEC;
    }

    public TypeInfo typeInfo() {
        return TypeInfo.OBJECT;
    }

    public RecipeComponent<NonNullList<ChanceResult>> asNonNullList() {
        return new NonNullListChanceResultComponent(this);
    }

    public ChanceResult wrap(RecipeScriptContext cx, Object from) {
        if (from instanceof ChanceResult) {
            ChanceResult cr = (ChanceResult)from;
            return cr;
        }
        if (from instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)from;
            int length = Math.toIntExact(nativeArray.getLength());
            if (length < 1) {
                throw new IllegalArgumentException("ChanceResult array must have at least 1 element (item)");
            }
            Object itemObj = nativeArray.get(0);
            if (!(itemObj instanceof String)) {
                throw new IllegalArgumentException("First element in array must be a string like 'item' or '3x item'");
            }
            String itemStr = (String)itemObj;
            ItemStack stack = this.parseCountedItemString(itemStr);
            float chance = 1.0f;
            if (length > 1) {
                try {
                    chance = Float.parseFloat(String.valueOf(nativeArray.get(1)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new ChanceResult(stack, chance);
        }
        if (from instanceof NativeObject) {
            ItemStack stack;
            NativeObject nativeObj = (NativeObject)from;
            Object itemObj = nativeObj.get((Object)"item");
            Object chanceObj = nativeObj.get((Object)"chance");
            Object countAtTopLevel = nativeObj.get((Object)"count");
            if (itemObj == null) {
                throw new IllegalArgumentException("ChanceResult missing 'item' field");
            }
            if (itemObj instanceof String) {
                String itemStr = (String)itemObj;
                stack = this.parseCountedItemString(itemStr);
                if (countAtTopLevel != null) {
                    try {
                        double d = Double.parseDouble(String.valueOf(countAtTopLevel));
                        stack.setCount((int)d);
                    }
                    catch (NumberFormatException d) {}
                }
            } else if (itemObj instanceof NativeObject) {
                ResourceLocation rl;
                Item item;
                NativeObject itemNativeObj = (NativeObject)itemObj;
                Object idObj = itemNativeObj.get((Object)"id");
                Object countObj = itemNativeObj.get((Object)"count");
                if (idObj == null) {
                    throw new IllegalArgumentException("ChanceResult item missing 'id' field");
                }
                String idStr = String.valueOf(idObj);
                int count = 1;
                if (countObj != null) {
                    try {
                        double d = Double.parseDouble(String.valueOf(countObj));
                        count = (int)d;
                    }
                    catch (NumberFormatException d) {
                        // empty catch block
                    }
                }
                if ((item = (Item)BuiltInRegistries.ITEM.get(rl = ResourceLocation.parse((String)idStr))) == null) {
                    throw new IllegalArgumentException("Invalid item ID: " + idStr);
                }
                stack = new ItemStack((ItemLike)item, count);
            } else {
                throw new IllegalArgumentException("Invalid 'item' field type: " + String.valueOf(itemObj.getClass()));
            }
            float chance = 1.0f;
            if (chanceObj != null) {
                try {
                    chance = Float.parseFloat(String.valueOf(chanceObj));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new ChanceResult(stack, chance);
        }
        if (from instanceof String) {
            String s = (String)from;
            ItemStack stack = this.parseCountedItemString(s);
            return new ChanceResult(stack, 1.0f);
        }
        throw new IllegalArgumentException("Cannot convert object to ChanceResult: " + String.valueOf(from));
    }

    private ItemStack parseCountedItemString(String input) {
        if ((input = input.trim()).matches("^\\d+x\\s+.+$")) {
            String[] parts = input.split("\\s+", 2);
            int count = Integer.parseInt(parts[0].replace("x", ""));
            String itemId = parts[1];
            ResourceLocation rl = ResourceLocation.parse((String)itemId);
            Item item = (Item)BuiltInRegistries.ITEM.get(rl);
            if (item == null) {
                throw new IllegalArgumentException("Invalid item ID: " + itemId);
            }
            return new ItemStack((ItemLike)item, count);
        }
        ResourceLocation rl = ResourceLocation.parse((String)input);
        Item item = (Item)BuiltInRegistries.ITEM.get(rl);
        if (item == null) {
            throw new IllegalArgumentException("Invalid item ID: " + input);
        }
        return new ItemStack((ItemLike)item);
    }
}

