/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opoliscompat.kubejs;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.opoliscompat.kubejs.ChanceResultComponent;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;

public class NonNullListChanceResultComponent
implements RecipeComponent<NonNullList<ChanceResult>> {
    private final RecipeComponent<ChanceResult> baseComponent;
    private final Codec<NonNullList<ChanceResult>> codec;
    private final TypeInfo typeInfo;
    public static final NonNullListChanceResultComponent NON_NULL_LIST_CHANCE_RESULT_COMPONENT = new NonNullListChanceResultComponent(ChanceResultComponent.CHANCE_RESULT);
    public static final RecipeComponentType<?> CONDITION = RecipeComponentType.unit((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"nonnull_list_chance_result"), (RecipeComponent)NON_NULL_LIST_CHANCE_RESULT_COMPONENT);

    public NonNullListChanceResultComponent(RecipeComponent<ChanceResult> baseComponent) {
        this.baseComponent = baseComponent;
        this.codec = baseComponent.codec().listOf().xmap(list -> {
            NonNullList nnList = NonNullList.create();
            nnList.addAll((Collection)list);
            return nnList;
        }, List::copyOf);
        this.typeInfo = TypeInfo.of(NonNullList.class);
    }

    public RecipeComponentType<?> type() {
        return CONDITION;
    }

    public Codec<NonNullList<ChanceResult>> codec() {
        return this.codec;
    }

    public TypeInfo typeInfo() {
        return this.typeInfo;
    }

    public NonNullList<ChanceResult> wrap(RecipeScriptContext cx, Object from) {
        NonNullList nnList = NonNullList.create();
        if (from instanceof NonNullList) {
            NonNullList nnl = (NonNullList)from;
            return nnl;
        }
        if (from instanceof List) {
            List list = (List)from;
            for (Object o : list) {
                if (o instanceof NativeArray) {
                    NativeArray nativeArray = (NativeArray)o;
                    if (nativeArray.getLength() < 1L) {
                        throw new IllegalArgumentException("ChanceResult array element must have at least one item (item string)");
                    }
                    Object itemStr = nativeArray.get(0);
                    float chance = 1.0f;
                    if (nativeArray.getLength() > 1L) {
                        Object chanceObj = nativeArray.get(1);
                        try {
                            chance = Float.parseFloat(String.valueOf(chanceObj));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ChanceResult cr = (ChanceResult)this.baseComponent.wrap(cx, itemStr);
                    nnList.add((Object)new ChanceResult(cr.stack(), chance));
                    continue;
                }
                nnList.add((Object)((ChanceResult)this.baseComponent.wrap(cx, o)));
            }
            return nnList;
        }
        nnList.add((Object)((ChanceResult)this.baseComponent.wrap(cx, from)));
        return nnList;
    }
}

