/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events;

import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.SocketManager;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_642;

public class ServerEvents {
    private static final List<String> MINEBOX_HOSTNAMES = List.of("minebox.fr", "minebox.co");
    private final State modState;

    public ServerEvents(State modState) {
        this.modState = modState;
        this.registerServerJoinEvent();
        this.registerServerLeaveEvent();
    }

    private void registerServerJoinEvent() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            String serverAddress;
            class_642 serverEntry = client.method_1558();
            if (serverEntry != null && this.isMineboxServer(serverAddress = serverEntry.field_3761)) {
                SocketManager.getSocket().connect();
            }
        });
    }

    private void registerServerLeaveEvent() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (SocketManager.getSocket().connected()) {
                SocketManager.getSocket().disconnect();
                this.modState.getAudioManager().closeMicrophoneAndSpeaker();
            }
            this.modState.reset();
        });
    }

    private boolean isMineboxServer(String hostname) {
        String lowerHostname = hostname.toLowerCase();
        return MINEBOX_HOSTNAMES.stream().anyMatch(lowerHostname::contains);
    }
}

