/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.hud;

import io.dampen59.mineboxadditions.features.hud.elements.Element;
import io.dampen59.mineboxadditions.features.hud.elements.stack.StackElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_332;

public abstract class Hud {
    private final Supplier<Boolean> onGetState;
    private final Consumer<Boolean> onSetState;
    private final Supplier<Integer> onGetX;
    private final Consumer<Integer> onSetX;
    private final Supplier<Integer> onGetY;
    private final Consumer<Integer> onSetY;
    public final StackElement mainStack;
    private final Map<String, Element> namedElements = new HashMap<String, Element>();

    public Hud(Supplier<Boolean> getState, Consumer<Boolean> setState, Supplier<Integer> getX, Consumer<Integer> setX, Supplier<Integer> getY, Consumer<Integer> setY) {
        this.onGetState = getState;
        this.onSetState = setState;
        this.onGetX = getX;
        this.onGetY = getY;
        this.onSetX = setX;
        this.onSetY = setY;
        this.mainStack = this.init();
    }

    public abstract StackElement init();

    public boolean getState() {
        return this.onGetState.get();
    }

    public void setState(boolean state) {
        this.onSetState.accept(state);
    }

    public int getX() {
        return this.onGetX.get();
    }

    public void setX(int x) {
        this.onSetX.accept(x);
    }

    public int getY() {
        return this.onGetY.get();
    }

    public void setY(int y) {
        this.onSetY.accept(y);
    }

    public int getWidth() {
        return this.mainStack.getWidth();
    }

    public int getHeight() {
        return this.mainStack.getHeight();
    }

    public void addNamedElement(String name, Element element) {
        if (element != null) {
            this.namedElements.put(name, element);
        }
    }

    public <T extends Element> T getNamedElement(String name, Class<T> clazz) {
        Element element = this.namedElements.get(name);
        if (clazz.isInstance(element)) {
            return (T)((Element)clazz.cast(element));
        }
        throw new IllegalStateException();
    }

    public void draw(class_332 context) {
        this.mainStack.setColor(0x40000000);
        this.mainStack.draw(context, this.getX(), this.getY());
    }

    public void drawDisabled(class_332 context) {
        this.mainStack.setColor(0x40FF0000);
        this.mainStack.draw(context, this.getX(), this.getY());
    }
}

