/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.hud;

import io.dampen59.mineboxadditions.features.hud.Hud;
import io.dampen59.mineboxadditions.features.hud.huds.MermaidHud;
import io.dampen59.mineboxadditions.features.hud.huds.ShopHud;
import io.dampen59.mineboxadditions.features.hud.huds.WeatherHud;
import io.dampen59.mineboxadditions.features.hud.huds.haversack.HaversackHud;
import io.dampen59.mineboxadditions.features.hud.huds.haversack.HaversackManager;
import io.dampen59.mineboxadditions.features.hud.huds.itempickup.ItemPickupHud;
import io.dampen59.mineboxadditions.features.hud.huds.itempickup.ItemPickupManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public enum HudManager {
    INSTANCE;

    private final Map<Class<? extends Hud>, Hud> huds = new HashMap<Class<? extends Hud>, Hud>();

    public <T extends Hud> void add(T hud) {
        this.huds.putIfAbsent(hud.getClass(), hud);
    }

    public <T extends Hud> T get(Class<T> clazz) {
        return (T)((Hud)clazz.cast(this.huds.get(clazz)));
    }

    public Collection<Hud> getAll() {
        return this.huds.values();
    }

    public void init() {
        this.initHuds();
        new HaversackManager();
        new ItemPickupManager();
    }

    private void initHuds() {
        this.add(new ShopHud());
        this.add(new MermaidHud());
        this.add(new WeatherHud.RainHud());
        this.add(new WeatherHud.StormHud());
        this.add(new WeatherHud.FullMoonHud());
        this.add(new HaversackHud.RateHud());
        this.add(new HaversackHud.FullHud());
        this.add(new ItemPickupHud());
    }
}

