/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.hud.huds.haversack;

import io.dampen59.mineboxadditions.features.hud.HudManager;
import io.dampen59.mineboxadditions.features.hud.huds.haversack.HaversackHud;
import io.dampen59.mineboxadditions.utils.Utils;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_7417;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9779;

public class HaversackManager {
    private int lastAmountInside = -1;
    private long lastMonoTimeNs = -1L;
    private double fillRatePerSecond = 0.0;
    private String timeUntilFull = "";
    private static final long MIN_INTERVAL_NS = 300000000L;
    private static final double EMA_ALPHA = 0.3;

    public HaversackManager() {
        ClientTickEvents.END_CLIENT_TICK.register(this::handle);
        HudRenderCallback.EVENT.register(this::render);
    }

    private void handle(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null || !Utils.isOnMinebox()) {
            return;
        }
        Stream.of(client.field_1724.method_6079()).filter(stack -> !stack.method_7960()).forEach(this::handleDurability);
        client.field_1724.method_31548().method_67533().stream().filter(stack -> !stack.method_7960()).forEach(this::handleDurability);
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof class_476) {
            class_476 containerScreen = (class_476)class_4372;
            ((class_1707)containerScreen.method_17577()).field_7761.forEach(slot -> {
                class_1799 stack = slot.method_7677();
                if (!stack.method_7960()) {
                    this.handleDurability(stack);
                }
            });
        }
    }

    private void render(class_332 context, class_9779 tickCounter) {
        if (this.fillRatePerSecond != 0.0) {
            HaversackHud.RateHud rate = HudManager.INSTANCE.get(HaversackHud.RateHud.class);
            rate.update(this.fillRatePerSecond);
            if (rate.getState()) {
                rate.draw(context);
            }
            HaversackHud.FullHud full = HudManager.INSTANCE.get(HaversackHud.FullHud.class);
            full.update(this.timeUntilFull);
            if (full.getState()) {
                full.draw(context);
            }
        }
    }

    private void handleDurability(class_1799 stack) {
        class_9279 itemData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return;
        }
        class_2487 nbtData = itemData.method_57461();
        if (nbtData == null || !nbtData.method_10545("mbitems:id")) {
            return;
        }
        String id = nbtData.method_10558("mbitems:id").orElse("");
        class_9290 loreComponent = (class_9290)stack.method_58694(class_9334.field_49632);
        if (loreComponent == null) {
            return;
        }
        for (class_2561 lore : loreComponent.comp_2400()) {
            class_7417 class_74172 = lore.method_10851();
            if (!(class_74172 instanceof class_2588)) continue;
            class_2588 translatableContent = (class_2588)class_74172;
            if (!id.contains("haversack") || !translatableContent.method_11022().contains("mbx.items.infinite_bag.amount_inside")) continue;
            this.handleHaversackDurability(stack, nbtData, translatableContent);
        }
    }

    private void handleHaversackDurability(class_1799 stack, class_2487 nbtData, class_2588 content) {
        int maxQuantity;
        String[] parts = content.method_29434(0).getString().split("/");
        if (parts.length < 2) {
            return;
        }
        try {
            maxQuantity = Integer.parseInt(parts[1].trim());
        }
        catch (NumberFormatException e) {
            return;
        }
        class_2487 persistentData = nbtData.method_10562("mbitems:persistent").orElse(null);
        if (persistentData == null) {
            return;
        }
        int amountInside = persistentData.method_10550("mbitems:amount_inside").orElse(-1);
        if (amountInside < 0) {
            return;
        }
        long now = System.nanoTime();
        if (this.lastMonoTimeNs < 0L || this.lastAmountInside < 0) {
            this.lastMonoTimeNs = now;
            this.lastAmountInside = amountInside;
            this.timeUntilFull = "";
            return;
        }
        long dtNs = now - this.lastMonoTimeNs;
        if (dtNs < 300000000L) {
            return;
        }
        int dAmount = amountInside - this.lastAmountInside;
        if (dAmount <= 0 || dtNs <= 0L) {
            this.lastMonoTimeNs = now;
            this.lastAmountInside = amountInside;
            this.fillRatePerSecond = Math.max(0.0, this.fillRatePerSecond * 0.8);
            this.timeUntilFull = this.fillRatePerSecond > 0.0 ? Utils.formatTime((long)((double)(maxQuantity - amountInside) / this.fillRatePerSecond)) : "\u221e";
            return;
        }
        double dtSec = (double)dtNs / 1.0E9;
        double instantRate = (double)dAmount / dtSec;
        this.fillRatePerSecond = 0.3 * instantRate + 0.7 * this.fillRatePerSecond;
        this.lastMonoTimeNs = now;
        this.lastAmountInside = amountInside;
        int remaining = Math.max(0, maxQuantity - amountInside);
        if (this.fillRatePerSecond > 1.0E-4 && Double.isFinite(this.fillRatePerSecond)) {
            long secondsLeft = (long)Math.ceil((double)remaining / this.fillRatePerSecond);
            this.timeUntilFull = Utils.formatTime(secondsLeft);
        } else {
            this.timeUntilFull = "\u221e";
        }
    }
}

