/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class WeatherUtils {
    private static final int CLEAR_CODEPOINT = 1048782;
    private static final int RAIN_CODEPOINT = 1048783;
    private static final int STORM_CODEPOINT = 0x1000D0;
    private static final String[] TIMES_OF_DAY = new String[]{"night", "morning", "afternoon", "evening"};

    public static ForecastResult parseWeatherForecast(int dayIndex, String dialog) {
        String dialogLower = dialog.toLowerCase(Locale.ROOT);
        List<String> glyphs = WeatherUtils.extractWeatherGlyphs(dialogLower);
        if (glyphs.size() < 4) {
            return null;
        }
        LinkedHashMap<String, WeatherType> forecast = new LinkedHashMap<String, WeatherType>();
        for (int i = 0; i < 4; ++i) {
            forecast.put(TIMES_OF_DAY[i], WeatherUtils.stringToWeather(glyphs.get(i)));
        }
        return new ForecastResult(dayIndex, forecast);
    }

    public static boolean isFullWeatherMessage(String dialog) {
        return dialog.codePoints().filter(cp -> cp == 0x1000D0 || cp == 1048783 || cp == 1048782).limit(4L).count() >= 4L;
    }

    private static List<String> extractWeatherGlyphs(String dialog) {
        ArrayList<String> glyphs = new ArrayList<String>();
        dialog.codePoints().forEach(cp -> {
            if (cp == 0x1000D0 || cp == 1048783 || cp == 1048782) {
                String glyph = new String(Character.toChars(cp));
                glyphs.add(glyph);
            }
        });
        return glyphs;
    }

    private static WeatherType stringToWeather(String glyph) {
        int cp = glyph.codePointAt(0);
        return switch (cp) {
            case 0x1000D0 -> WeatherType.STORM;
            case 1048783 -> WeatherType.RAIN;
            case 1048782 -> WeatherType.CLEAR;
            default -> WeatherType.UNKNOWN;
        };
    }

    public static JSONObject parseWeatherForecastJson(ForecastResult result) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("day", result.dayIndex);
        JSONObject forecast = new JSONObject();
        for (Map.Entry<String, WeatherType> entry : result.forecast.entrySet()) {
            forecast.put(entry.getKey(), (Object)entry.getValue().name());
        }
        json.put("forecast", (Object)forecast);
        return json;
    }

    public static enum WeatherType {
        CLEAR,
        RAIN,
        STORM,
        UNKNOWN;

    }

    public static class ForecastResult {
        public final int dayIndex;
        public final Map<String, WeatherType> forecast;

        public ForecastResult(int dayIndex, Map<String, WeatherType> forecast) {
            this.dayIndex = dayIndex;
            this.forecast = forecast;
        }
    }
}

