/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions;

import io.dampen59.mineboxadditions.minebox.ExtraInventoryItem;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Config(name="mineboxadditions")
@Environment(value=EnvType.CLIENT)
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public String socketServerAddress = "http://mbxadditions.dampen59.io:3000";
    @ConfigEntry.Gui.Excluded
    public String selectedMicName = "";
    @ConfigEntry.Gui.Excluded
    public String selectedSpeakerName = "";
    @ConfigEntry.Gui.Excluded
    public float micGainDb = 0.0f;
    @ConfigEntry.Gui.Excluded
    public float speakerVolumeMultiplier = 1.0f;
    @ConfigEntry.Gui.Excluded
    public int rainHudX = 5;
    @ConfigEntry.Gui.Excluded
    public int rainHudY = 60;
    @ConfigEntry.Gui.Excluded
    public int stormHudX = 5;
    @ConfigEntry.Gui.Excluded
    public int stormHudY = 72;
    @ConfigEntry.Gui.Excluded
    public int shopHudX = 5;
    @ConfigEntry.Gui.Excluded
    public int shopHudY = 40;
    @ConfigEntry.Gui.Excluded
    public int fullMoonHudX = 14;
    @ConfigEntry.Gui.Excluded
    public int fullMoonHudY = 5;
    @ConfigEntry.Gui.Excluded
    public int haverSackFillRateX = 10;
    @ConfigEntry.Gui.Excluded
    public int haverSackFillRateY = 10;
    @ConfigEntry.Gui.Excluded
    public int haversackFullInX = 10;
    @ConfigEntry.Gui.Excluded
    public int haversackFullInY = 25;
    @ConfigEntry.Gui.Excluded
    public int mermaidRequestHudX = 10;
    @ConfigEntry.Gui.Excluded
    public int getMermaidRequestHudY = 40;
    @ConfigEntry.Gui.Excluded
    public int itemPickupHudX = 0;
    @ConfigEntry.Gui.Excluded
    public int itemPickupHudY = 0;
    @ConfigEntry.Gui.CollapsibleObject
    public ShopsAlertsSettings shopsAlertsSettings = new ShopsAlertsSettings();
    @ConfigEntry.Gui.CollapsibleObject
    public DurabilitySettings durabilitySettings = new DurabilitySettings();
    @ConfigEntry.Gui.CollapsibleObject
    public DisplaySettings displaySettings = new DisplaySettings();
    public boolean autoIslandOnLogin = false;
    @ConfigEntry.Gui.Excluded
    public Map<Integer, Map<Integer, ExtraInventoryItem>> storedItemSets = new HashMap<Integer, Map<Integer, ExtraInventoryItem>>();
    @ConfigEntry.Gui.Excluded
    public Map<Integer, String> setNames = new HashMap<Integer, String>();
    @ConfigEntry.Gui.Excluded
    public Map<String, HarvestablesPrefs> harvestablesPrefs = new HashMap<String, HarvestablesPrefs>();

    public ModConfig() {
        for (int i = 0; i < 4; ++i) {
            this.storedItemSets.put(i, new HashMap());
            this.setNames.put(i, "Set " + (i + 1));
        }
    }

    public void setItemInSlot(int setIndex, int slotId, ExtraInventoryItem item) {
        if (setIndex >= 0 && setIndex < 4) {
            this.storedItemSets.get(setIndex).put(slotId, item);
        }
    }

    public ExtraInventoryItem getItemInSlot(int setIndex, int slotId) {
        if (setIndex >= 0 && setIndex < 4) {
            return this.storedItemSets.get(setIndex).get(slotId);
        }
        return null;
    }

    public Map<Integer, ExtraInventoryItem> getSet(int setIndex) {
        return this.storedItemSets.getOrDefault(setIndex, new HashMap());
    }

    public void clearSet(int setIndex) {
        if (setIndex >= 0 && setIndex < 4) {
            Map<Integer, ExtraInventoryItem> set = this.storedItemSets.get(setIndex);
            if (set != null) {
                set.clear();
            } else {
                this.storedItemSets.put(setIndex, new HashMap());
            }
        }
    }

    public void setSetName(int setIndex, String name) {
        if (setIndex >= 0 && setIndex < 4) {
            this.setNames.put(setIndex, name);
        }
    }

    public String getSetName(int setIndex) {
        return this.setNames.getOrDefault(setIndex, "Set " + (setIndex + 1));
    }

    @Environment(value=EnvType.CLIENT)
    public static class ShopsAlertsSettings {
        public boolean getMouseAlerts = true;
        public boolean getBakeryAlerts = true;
        public boolean getBuckstarAlerts = true;
        public boolean getCocktailAlerts = true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DurabilitySettings {
        public boolean haversackDurability = false;
        public boolean harvesterDurability = false;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DisplaySettings {
        @ConfigEntry.Gui.CollapsibleObject
        public ItemPickupSettings itemPickupSettings = new ItemPickupSettings();
        @ConfigEntry.Gui.CollapsibleObject
        public ItemRaritySettings itemRaritySettings = new ItemRaritySettings();
        @ConfigEntry.Gui.CollapsibleObject
        public FishingSettings fishingSettings = new FishingSettings();
        public boolean displayMuseumMissingItems = true;
        public boolean displayFullMoon = false;
        public boolean displayNextRain = true;
        public boolean displayNextStorm = true;
        public boolean displayHaversackFillRate = true;
        public boolean displayHaversackFullIn = true;
        public boolean displayMermaidRequest = true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class HarvestablesPrefs {
        public Map<String, Boolean> categoryEnabled = new HashMap<String, Boolean>();
        public Map<String, Map<String, Boolean>> itemEnabled = new HashMap<String, Map<String, Boolean>>();
        public Map<String, Map<String, Integer>> itemColor = new HashMap<String, Map<String, Integer>>();
    }

    @Environment(value=EnvType.CLIENT)
    public static class FishingSettings {
        public boolean showFishDrops = true;
        @ConfigEntry.BoundedDiscrete(min=1L, max=50L)
        public int fishDropRadius = 25;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ItemRaritySettings {
        public boolean displayItemsRarity = false;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.DROPDOWN)
        public RaritiesDisplayMode displayMode = RaritiesDisplayMode.FILL;
        @ConfigEntry.BoundedDiscrete(min=1L, max=100L)
        public int backgroundOpacity = 50;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ItemPickupSettings {
        public boolean displayItemsPickups = false;
        @ConfigEntry.BoundedDiscrete(min=1L, max=10L)
        public int maxPickupNotifications = 5;
        @ConfigEntry.BoundedDiscrete(min=1L, max=10L)
        public int pickupNotificationDuration = 2;
        public boolean mergeLines = true;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum RaritiesDisplayMode {
        FILL,
        CIRCLE;

    }
}

