/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.audio;

import de.maxhenkel.opus4j.OpusDecoder;
import de.maxhenkel.opus4j.OpusEncoder;
import io.dampen59.mineboxadditions.audio.AudioMixer;
import io.dampen59.mineboxadditions.state.AudioDeviceState;
import io.dampen59.mineboxadditions.state.State;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AudioManager {
    private final State modState;
    private TargetDataLine microphone;
    private SourceDataLine speaker;
    private final byte[] buffer = new byte[1920];
    private OpusEncoder encoder = null;
    private OpusDecoder decoder = null;
    private final Map<String, OpusDecoder> decoders = new HashMap<String, OpusDecoder>();
    private boolean isRecording = false;
    private AudioMixer mixer;

    public AudioManager(State modState) {
        this.modState = modState;
        this.modState.setAudioManager(this);
        try {
            this.encoder = new OpusEncoder(48000, 1, OpusEncoder.Application.VOIP);
            this.decoder = new OpusDecoder(48000, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openMicrophone() throws LineUnavailableException {
        if (this.microphone != null && this.microphone.isOpen()) {
            this.microphone.stop();
            this.microphone.flush();
            this.microphone.close();
        }
        AudioFormat format = new AudioFormat(48000.0f, 16, 1, true, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        Mixer.Info selectedMic = AudioDeviceState.selectedInput;
        Mixer mixer = selectedMic != null ? AudioSystem.getMixer(selectedMic) : AudioSystem.getMixer(null);
        this.microphone = (TargetDataLine)mixer.getLine(info);
        this.microphone.open(format);
        this.microphone.start();
        this.isRecording = true;
        this.startMicrophoneCapture();
    }

    public void openSpeaker() throws LineUnavailableException {
        if (this.speaker != null && this.speaker.isOpen()) {
            this.speaker.stop();
            this.speaker.flush();
            this.speaker.close();
        }
        AudioFormat format = new AudioFormat(48000.0f, 16, 2, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        Mixer.Info selectedOutput = AudioDeviceState.selectedOutput;
        Mixer mixer = selectedOutput != null ? AudioSystem.getMixer(selectedOutput) : AudioSystem.getMixer(null);
        this.speaker = (SourceDataLine)mixer.getLine(info);
        this.speaker.open(format);
        this.speaker.start();
    }

    public void openMicrophone(Mixer mixer) throws LineUnavailableException {
        if (this.microphone != null && this.microphone.isOpen()) {
            this.microphone.stop();
            this.microphone.flush();
            this.microphone.close();
        }
        AudioFormat format = new AudioFormat(48000.0f, 16, 1, true, false);
        this.microphone = (TargetDataLine)mixer.getLine(new DataLine.Info(TargetDataLine.class, format));
        this.microphone.open(format);
        this.microphone.start();
        this.isRecording = true;
        this.startMicrophoneCapture();
    }

    public void openSpeaker(Mixer mixer) throws LineUnavailableException {
        if (this.speaker != null && this.speaker.isOpen()) {
            this.speaker.stop();
            this.speaker.flush();
            this.speaker.close();
        }
        AudioFormat format = new AudioFormat(48000.0f, 16, 2, true, false);
        this.speaker = (SourceDataLine)mixer.getLine(new DataLine.Info(SourceDataLine.class, format));
        this.speaker.open(format);
        this.speaker.start();
        this.mixer = new AudioMixer(this.speaker);
    }

    public OpusDecoder getDecoder() {
        return this.decoder;
    }

    public Map<String, OpusDecoder> getDecoders() {
        return this.decoders;
    }

    public OpusEncoder getEncoder() {
        return this.encoder;
    }

    public SourceDataLine getSpeaker() {
        return this.speaker;
    }

    public TargetDataLine getMicrophone() {
        return this.microphone;
    }

    public AudioMixer getMixer() {
        return this.mixer;
    }

    public void closeMicrophoneAndSpeaker() {
        if (this.mixer != null) {
            this.mixer.stop();
            this.mixer = null;
        }
        if (this.speaker != null) {
            this.speaker.flush();
            this.speaker.stop();
            this.speaker.close();
        }
        this.isRecording = false;
        if (this.microphone != null) {
            this.microphone.flush();
            this.microphone.stop();
            this.microphone.close();
        }
    }

    private void startMicrophoneCapture() {
        new Thread(() -> {
            try {
                byte[] inputBuffer = new byte[2048];
                byte[] pcmBuffer = new byte[1920];
                int pcmOffset = 0;
                float linearGain = (float)Math.pow(10.0, (double)AudioDeviceState.micGainDb / 20.0);
                long frameDurationNs = 20000000L;
                long nextSendTime = System.nanoTime();
                while (this.isRecording) {
                    int bytesRead = this.microphone.read(inputBuffer, 0, inputBuffer.length);
                    int consumed = 0;
                    while (consumed < bytesRead) {
                        int remaining = 1920 - pcmOffset;
                        int toCopy = Math.min(remaining, bytesRead - consumed);
                        System.arraycopy(inputBuffer, consumed, pcmBuffer, pcmOffset, toCopy);
                        consumed += toCopy;
                        if ((pcmOffset += toCopy) != 1920) continue;
                        short[] rawAudio = new short[960];
                        for (int i = 0; i < 960; ++i) {
                            short sample = (short)(pcmBuffer[2 * i + 1] << 8 | pcmBuffer[2 * i] & 0xFF);
                            int amplified = Math.round((float)sample * linearGain);
                            rawAudio[i] = (short)Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, amplified));
                        }
                        byte[] encoded = this.encoder.encode(rawAudio);
                        this.modState.getSocket().emit("C2SAudioData", new Object[]{encoded});
                        pcmOffset = 0;
                        long now = System.nanoTime();
                        long sleepNs = nextSendTime - now;
                        if (sleepNs > 0L) {
                            Thread.sleep(sleepNs / 1000000L, (int)(sleepNs % 1000000L));
                        }
                        nextSendTime += frameDurationNs;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (this.microphone != null) {
                    this.microphone.flush();
                    this.microphone.drain();
                }
            }
        }).start();
    }
}

