/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events;

import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.state.State;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class SkyEvent {
    private final State modState;

    public SkyEvent(State prmModState) {
        this.modState = prmModState;
        this.onTick();
        HudRenderCallback.EVENT.register(this::onRenderHud);
    }

    public void onTick() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null) {
                int moonPhase = client.field_1687.method_30273();
                if (this.modState.getCurrentMoonPhase() != 0) {
                    // empty if block
                }
                this.modState.setCurrentMoonPhase(moonPhase);
            }
        });
    }

    private boolean isFullMoon() {
        return this.modState.getCurrentMoonPhase() == 0;
    }

    private void onRenderHud(class_332 drawContext, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1690.field_1842) {
            return;
        }
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        if (this.isFullMoon() && config.displaySettings.displayFullMoon) {
            class_2960 texture = class_2960.method_60655((String)"mineboxadditions", (String)"textures/gui/moon_phases/full_moon.png");
            drawContext.method_25290(class_10799.field_56883, texture, config.fullMoonHudX, config.fullMoonHudY, 0.0f, 0.0f, 24, 24, 24, 24);
        }
        Object rainText = client.field_1687.method_8419() ? "Next Rain: Now !" : "Next Rain: " + this.formatNextEventCountdown(this.modState.getWeatherState().getRainTimestamps());
        Object stormText = client.field_1687.method_8546() ? "Next Storm: Now !" : "Next Storm: " + this.formatNextEventCountdown(this.modState.getWeatherState().getStormTimestamps());
        if (config.displaySettings.displayNextRain) {
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)rainText), config.rainHudX, config.rainHudY, -1, true);
        }
        if (config.displaySettings.displayNextStorm) {
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)stormText), config.stormHudX, config.stormHudY, -1, true);
        }
    }

    private String formatNextEventCountdown(List<Integer> timestamps) {
        if (timestamps == null || timestamps.isEmpty()) {
            return "Unknown";
        }
        List<Integer> snapshot = SkyEvent.snapshotList(timestamps);
        if (snapshot.isEmpty()) {
            return "Unknown";
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        Integer next = null;
        for (Integer ts : snapshot) {
            if (ts == null || ts <= now || next != null && ts >= next) continue;
            next = ts;
        }
        if (next == null) {
            return "Unknown";
        }
        int secondsLeft = next - now;
        int hours = secondsLeft / 3600;
        int minutes = secondsLeft % 3600 / 60;
        int seconds = secondsLeft % 60;
        return String.format("in %02d:%02d:%02d", hours, minutes, seconds);
    }

    private static List<Integer> snapshotList(List<Integer> src) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                return new ArrayList<Integer>(src);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        ArrayList<Integer> fallback = new ArrayList<Integer>();
        try {
            for (Integer i : src) {
                fallback.add(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }
}

