/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events;

import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.minebox.MineboxFishingShoal;
import io.dampen59.mineboxadditions.minebox.MineboxHarvestable;
import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.ImageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_7417;
import net.minecraft.class_8113;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class WorldRendererEvent {
    private static final class_2960 BEACON_BEAM_TEX = class_2960.method_60654((String)"textures/entity/beacon_beam.png");
    private static int tickCounter = 0;

    public WorldRendererEvent() {
        WorldRenderEvents.AFTER_ENTITIES.register(WorldRendererEvent::onRender);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null) {
                return;
            }
            if (++tickCounter < 200) {
                return;
            }
            tickCounter = 0;
            HashSet<String> liveUuids = new HashSet<String>();
            for (class_1297 entity : client.field_1687.method_18112()) {
                liveUuids.add(entity.method_5667().toString());
            }
            MineboxAdditionsClient.INSTANCE.modState.cleanStaleEntityTextCache(liveUuids);
        });
    }

    public static void onRender(WorldRenderContext context) {
        State state = MineboxAdditionsClient.INSTANCE.modState;
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        class_310 mc = class_310.method_1551();
        if (!state.isConnectedToMinebox()) {
            return;
        }
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        if (config.displaySettings.fishingSettings.showFishDrops) {
            class_238 searchBox = mc.field_1724.method_5829().method_1014((double)config.displaySettings.fishingSettings.fishDropRadius);
            HashMap<class_1297, String> shoalEntities = new HashMap<class_1297, String>();
            for (class_1297 entity2 : mc.field_1687.method_8333((class_1297)mc.field_1724, searchBox, e -> e instanceof class_8113.class_8123)) {
                String key2 = WorldRendererEvent.getCachedEntityTextKey(entity2);
                if (key2 == null || !key2.startsWith("mbx.harvestables.shoal")) continue;
                shoalEntities.put(entity2, key2);
            }
            if (!shoalEntities.isEmpty()) {
                shoalEntities.forEach((entity, key) -> WorldRendererEvent.doRenderShoalBillboard(entity, key, context, state));
            }
        }
        WorldRendererEvent.renderHarvestableBeams(context);
    }

    private static void renderHarvestableBeams(WorldRenderContext ctx) {
        class_310 mc = class_310.method_1551();
        class_638 world = ctx.world();
        if (world == null || mc.field_1724 == null) {
            return;
        }
        State state = MineboxAdditionsClient.INSTANCE.modState;
        class_2960 worldId = world.method_27983().method_29177();
        String islandKeyPath = worldId.method_12832();
        List<MineboxHarvestable> items = state.getMineboxHarvestables(islandKeyPath);
        if ((items == null || items.isEmpty()) && ((items = state.getMineboxHarvestables(worldId.toString())) == null || items.isEmpty())) {
            return;
        }
        ModConfig cfg = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        ModConfig.HarvestablesPrefs prefs = cfg.harvestablesPrefs.get(islandKeyPath);
        if (prefs == null) {
            return;
        }
        class_4587 ms = ctx.matrixStack();
        class_4597 prov = ctx.consumers();
        if (ms == null || prov == null) {
            return;
        }
        float tickDelta = ctx.tickCounter().method_60637(false);
        float time = (float)mc.field_1687.method_8510() + tickDelta;
        float scroll = time / 40.0f % 1.0f;
        int rd = (Integer)mc.field_1690.method_42503().method_41753();
        double maxDist = rd * 16 + 64;
        double maxDistSq = maxDist * maxDist;
        class_243 cam = ctx.camera().method_19326();
        ms.method_22903();
        ms.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);
        for (MineboxHarvestable it : items) {
            int z;
            double dz;
            int y;
            double dy;
            int x;
            double dx;
            boolean itemOn;
            String name;
            String cat = it.getCategory() != null ? it.getCategory() : "misc";
            String string = name = it.getName() != null ? it.getName() : "unknown";
            boolean catOn = prefs.categoryEnabled.getOrDefault(cat, false);
            if (!catOn || !(itemOn = prefs.itemEnabled.getOrDefault(cat, Collections.emptyMap()).getOrDefault(name, false).booleanValue())) continue;
            int rgb = prefs.itemColor.getOrDefault(cat, Collections.emptyMap()).getOrDefault(name, -1);
            List<Double> c = it.getCoordinates();
            if (c == null || c.size() < 3 || (dx = (double)(x = (int)Math.round(c.get(0))) + 0.5 - cam.field_1352) * dx + (dy = (double)(y = (int)Math.round(c.get(1))) - cam.field_1351) * dy + (dz = (double)(z = (int)Math.round(c.get(2))) + 0.5 - cam.field_1350) * dz > maxDistSq) continue;
            class_243 playerPos = mc.field_1724.method_19538();
            double ndx = (double)x + 0.5 - playerPos.field_1352;
            double ndy = (double)y - playerPos.field_1351;
            double ndz = (double)z + 0.5 - playerPos.field_1350;
            if (ndx * ndx + ndy * ndy + ndz * ndz < 16.0) continue;
            WorldRendererEvent.drawBeaconBeam(ms, prov, new class_2338(x, y, z), 192, 0.35f, scroll, rgb);
        }
        ms.method_22909();
    }

    private static void drawBeaconBeam(class_4587 ms, class_4597 prov, class_2338 base, int height, float radiusIgnored, float vOffset, int rgb) {
        class_4588 vc = prov.getBuffer(class_1921.method_23592((class_2960)BEACON_BEAM_TEX, (boolean)true));
        Matrix4f m = ms.method_23760().method_23761();
        float cx = (float)base.method_10263() + 0.5f;
        float cz = (float)base.method_10260() + 0.5f;
        float y0 = base.method_10264();
        float y1 = y0 + (float)height;
        float innerR = 0.2f;
        float outerR = 0.25f;
        float rot = (float)((double)vOffset * Math.PI * 2.0);
        float sin = (float)Math.sin(rot);
        float cos = (float)Math.cos(rot);
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = vOffset;
        float v1 = vOffset + (float)height / 32.0f;
        int cr = rgb >> 16 & 0xFF;
        int cg = rgb >> 8 & 0xFF;
        int cb = rgb & 0xFF;
        float[][] inner = new float[4][2];
        float[][] outer = new float[4][2];
        WorldRendererEvent.fillRotatedSquare(inner, 0.2f, cos, sin);
        WorldRendererEvent.fillRotatedSquare(outer, 0.25f, cos, sin);
        int aInner = 200;
        for (int i = 0; i < 4; ++i) {
            int j = i + 1 & 3;
            WorldRendererEvent.addBeamSide(vc, m, cx + inner[i][0], cz + inner[i][1], cx + inner[j][0], cz + inner[j][1], y0, y1, 0.0f, v0, 1.0f, v1, cr, cg, cb, 200);
        }
        int aOuter = 64;
        for (int i = 0; i < 4; ++i) {
            int j = i + 1 & 3;
            WorldRendererEvent.addBeamSide(vc, m, cx + outer[i][0], cz + outer[i][1], cx + outer[j][0], cz + outer[j][1], y0, y1, 0.0f, v0, 1.0f, v1, cr, cg, cb, 64);
        }
    }

    private static void fillRotatedSquare(float[][] out, float r, float cos, float sin) {
        float[][] base = new float[][]{{r, -r}, {r, r}, {-r, r}, {-r, -r}};
        for (int i = 0; i < 4; ++i) {
            float x = base[i][0];
            float z = base[i][1];
            out[i][0] = x * cos - z * sin;
            out[i][1] = x * sin + z * cos;
        }
    }

    private static void addBeamSide(class_4588 vc, Matrix4f m, float x0, float z0, float x1, float z1, float y0, float y1, float u0, float v0, float u1, float v1, int r, int g, int b, int a) {
        int light = 0xF000F0;
        vc.method_22918(m, x0, y0, z0).method_1336(r, g, b, a).method_22913(u0, v1).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(m, x1, y0, z1).method_1336(r, g, b, a).method_22913(u1, v1).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(m, x1, y1, z1).method_1336(r, g, b, a).method_22913(u1, v0).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(m, x0, y1, z0).method_1336(r, g, b, a).method_22913(u0, v0).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
    }

    private static void doRenderShoalBillboard(class_1297 entity, String translationKey, WorldRenderContext context, State state) {
        if (!WorldRendererEvent.isBillboardEntity(entity)) {
            return;
        }
        if (!translationKey.contains("shoal")) {
            return;
        }
        String shoalName = translationKey.split("harvestables\\.")[1].split("\\.name")[0];
        class_4587 matrices = context.matrixStack();
        class_4597 vertexConsumers = context.consumers();
        if (matrices == null || vertexConsumers == null) {
            return;
        }
        matrices.method_22903();
        class_243 entityPos = entity.method_19538().method_1020(context.camera().method_19326());
        matrices.method_22904(entityPos.field_1352, entityPos.field_1351 - 0.5, entityPos.field_1350);
        List<class_2960> textures = WorldRendererEvent.getTexture(shoalName, (class_1937)context.world(), state);
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        float yaw = camera.method_19330();
        float pitch = camera.method_19329();
        float textureSize = 0.5f;
        float spacing = 0.2f;
        int count = textures.size();
        float totalWidth = textureSize * (float)count + spacing * (float)(count - 1);
        float startOffset = -totalWidth / 2.0f + textureSize / 2.0f;
        for (int i = 0; i < textures.size(); ++i) {
            class_2960 texture = textures.get(i);
            class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)texture));
            matrices.method_22903();
            float xOffset = startOffset + (float)i * (textureSize + spacing);
            matrices.method_22907((Quaternionfc)new Quaternionf().rotationYXZ((float)Math.toRadians(-yaw), (float)Math.toRadians(pitch), 0.0f));
            matrices.method_46416(xOffset, 0.0f, 0.0f);
            Matrix4f matrix = matrices.method_23760().method_23761();
            float half = textureSize / 2.0f;
            buffer.method_22918(matrix, -half, -half, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 0.0f, 1.0f);
            buffer.method_22918(matrix, -half, half, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 0.0f, 1.0f);
            buffer.method_22918(matrix, half, half, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 0.0f, 1.0f);
            buffer.method_22918(matrix, half, -half, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 0.0f, 1.0f);
            matrices.method_22909();
        }
        matrices.method_22909();
    }

    private static List<class_2960> getTexture(String shoal, class_1937 world, State state) {
        List<MineboxFishingShoal.FishingShoalFish> fishables = state.getMbxFishables();
        ArrayList<class_2960> textures = new ArrayList<class_2960>();
        boolean isRaining = world.method_8419();
        boolean isStorming = world.method_8546();
        boolean isFullMoon = state.getCurrentMoonPhase() == 0;
        long currentWorldTicks = world.method_8532() % 24000L;
        for (MineboxFishingShoal.FishingShoalFish fish : fishables) {
            class_2960 resourceID;
            class_1060 textureManager;
            boolean weatherMet;
            if (!fish.getShoal().equals(shoal) || !WorldRendererEvent.isTimeInRange(fish, currentWorldTicks)) continue;
            MineboxFishingShoal.FishingShoalConditions conditions = fish.getConditions();
            boolean weatherRequired = Boolean.TRUE.equals(conditions.getRain()) || Boolean.TRUE.equals(conditions.getStorm()) || Boolean.TRUE.equals(conditions.getFullMoon());
            boolean bl = weatherMet = !(Boolean.TRUE.equals(conditions.getRain()) && !isRaining || Boolean.TRUE.equals(conditions.getStorm()) && !isStorming || Boolean.TRUE.equals(conditions.getFullMoon()) && !isFullMoon);
            if (weatherRequired && !weatherMet || !ImageUtils.textureExists(textureManager = class_310.method_1551().method_1531(), resourceID = fish.getResource())) continue;
            textures.add(resourceID);
        }
        return textures;
    }

    private static boolean isTimeInRange(MineboxFishingShoal.FishingShoalFish fish, long currentWorldTicks) {
        int maxTime;
        int minTime = fish.getTimeRange().get(0);
        return minTime <= (maxTime = fish.getTimeRange().get(1).intValue()) ? currentWorldTicks >= (long)minTime && currentWorldTicks <= (long)maxTime : currentWorldTicks >= (long)minTime || currentWorldTicks <= (long)maxTime;
    }

    private static boolean isBillboardEntity(class_1297 entity) {
        if (entity instanceof class_1531) {
            boolean hasEquipment;
            class_1531 stand = (class_1531)entity;
            boolean bl = hasEquipment = !stand.method_6118(class_1304.field_6169).method_7960() || !stand.method_6118(class_1304.field_6174).method_7960() || !stand.method_6118(class_1304.field_6172).method_7960() || !stand.method_6118(class_1304.field_6166).method_7960();
            if (!hasEquipment && (stand.method_5740() || stand.method_5767())) {
                return true;
            }
        }
        if (entity instanceof class_8113.class_8123) {
            return true;
        }
        boolean isStationary = entity.method_5740() || entity.method_18798().method_1027() < 1.0E-4;
        boolean hasText = WorldRendererEvent.getEntityText(entity) != null;
        boolean isSpecial = entity.method_5864() == class_1299.field_42623 || entity.method_5864() == class_1299.field_6083 || entity.method_5864() == class_1299.field_33456;
        return isStationary && hasText || isSpecial;
    }

    public static class_2561 getEntityText(class_1297 entity) {
        class_8113.class_8123 textDisplay;
        class_2561 t;
        if (entity.method_16914()) {
            return entity.method_5797();
        }
        if (entity instanceof class_8113.class_8123 && (t = (textDisplay = (class_8113.class_8123)entity).method_48915()) != null && !t.getString().isEmpty()) {
            return t;
        }
        return null;
    }

    private static String getCachedEntityTextKey(class_1297 entity) {
        State state = MineboxAdditionsClient.INSTANCE.modState;
        String uuid = entity.method_5667().toString();
        if (state.hasEntityTextCached(uuid)) {
            return state.getCachedEntityText(uuid);
        }
        String result = WorldRendererEvent.getEntityTextKeyUncached(entity);
        state.cacheEntityText(uuid, result);
        return result;
    }

    private static String getEntityTextKeyUncached(class_1297 entity) {
        class_2561 t;
        class_2561 class_25612 = t = entity.method_16914() ? entity.method_5797() : null;
        if (t == null && entity instanceof class_8113.class_8123) {
            class_8113.class_8123 td = (class_8113.class_8123)entity;
            t = td.method_48915();
        }
        if (t == null) {
            return null;
        }
        return WorldRendererEvent.extractShoalTranslationKey(t);
    }

    private static String extractShoalTranslationKey(class_2561 text) {
        if (text == null) {
            return null;
        }
        class_7417 class_74172 = text.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            String key = tc.method_11022();
            if (key != null && key.startsWith("mbx.harvestables.shoal")) {
                return key;
            }
            for (Object arg : tc.method_11023()) {
                class_2561 tArg;
                String found;
                if (!(arg instanceof class_2561) || (found = WorldRendererEvent.extractShoalTranslationKey(tArg = (class_2561)arg)) == null) continue;
                return found;
            }
        }
        for (class_2561 sibling : text.method_10855()) {
            String found = WorldRendererEvent.extractShoalTranslationKey(sibling);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

