/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events.inventory;

import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class InventoryEvent {
    private final State modState;
    private final class_310 client = class_310.method_1551();
    private final Map<Integer, Integer> previousInventoryCounts = new HashMap<Integer, Integer>();
    private final List<ItemPickupNotification> itemPickupNotifications = new ArrayList<ItemPickupNotification>();
    private int lastAmountInside = -1;
    private long lastCheckTime = System.currentTimeMillis();
    private double fillRatePerSecond = 0.0;
    private String timeUntilFull = "";

    public InventoryEvent(State modState) {
        this.modState = modState;
        HudRenderCallback.EVENT.register(this::renderItemsPickups);
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.onTick());
    }

    private void onTick() {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        if (this.client.field_1724 == null || this.client.field_1687 == null || !this.modState.isConnectedToMinebox()) {
            return;
        }
        Stream.of(this.client.field_1724.method_6079()).filter(stack -> !stack.method_7960()).forEach(this::handleDurability);
        this.client.field_1724.method_31548().method_67533().stream().filter(stack -> !stack.method_7960()).forEach(this::handleDurability);
        class_437 class_4372 = this.client.field_1755;
        if (class_4372 instanceof class_476) {
            class_476 containerScreen = (class_476)class_4372;
            ((class_1707)containerScreen.method_17577()).field_7761.forEach(slot -> {
                class_1799 stack = slot.method_7677();
                if (!stack.method_7960()) {
                    this.handleDurability(stack);
                }
            });
        }
        if (config.displaySettings.itemPickupSettings.displayItemsPickups) {
            int displayDurationTicks = config.displaySettings.itemPickupSettings.pickupNotificationDuration * 20;
            int maxNotifications = config.displaySettings.itemPickupSettings.maxPickupNotifications;
            boolean mergeNotifications = config.displaySettings.itemPickupSettings.mergeLines;
            this.updateInventorySnapshot(displayDurationTicks, maxNotifications, mergeNotifications);
            this.tickItemPickupNotifications();
        }
    }

    private void tickItemPickupNotifications() {
        this.itemPickupNotifications.removeIf(notification -> --notification.displayTicks <= 0);
    }

    private void updateInventorySnapshot(int notificationDuration, int maxNotifications, boolean mergeNotifications) {
        if (this.client.field_1755 != null || this.client.field_1724 == null || this.client.field_1724.method_31548() == null) {
            return;
        }
        class_2371 currentInventory = this.client.field_1724.method_31548().method_67533();
        for (int slot = 0; slot < currentInventory.size(); ++slot) {
            class_1799 currentStack = (class_1799)currentInventory.get(slot);
            int currentCount = currentStack.method_7947();
            int previousCount = this.previousInventoryCounts.getOrDefault(slot, 0);
            if (currentStack.method_7960() || currentCount <= previousCount) continue;
            int gainedCount = currentCount - previousCount;
            this.addOrUpdateItemPickup(currentStack.method_7972(), gainedCount, notificationDuration, maxNotifications, mergeNotifications);
        }
        this.updatePreviousInventoryCounts((class_2371<class_1799>)currentInventory);
    }

    private void updatePreviousInventoryCounts(class_2371<class_1799> currentInventory) {
        this.previousInventoryCounts.clear();
        for (int slot = 0; slot < currentInventory.size(); ++slot) {
            this.previousInventoryCounts.put(slot, ((class_1799)currentInventory.get(slot)).method_7947());
        }
    }

    private void addOrUpdateItemPickup(class_1799 stack, int count, int duration, int maxNotifications, boolean merge) {
        if (merge) {
            for (ItemPickupNotification notif : this.itemPickupNotifications) {
                if (!class_1799.method_31577((class_1799)notif.itemStack, (class_1799)stack)) continue;
                notif.count += count;
                notif.displayTicks = duration;
                return;
            }
        }
        this.itemPickupNotifications.add(new ItemPickupNotification(stack, count, duration));
        if (this.itemPickupNotifications.size() > maxNotifications) {
            this.itemPickupNotifications.removeFirst();
        }
    }

    private void renderItemsPickups(class_332 drawContext, class_9779 tickCounter) {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        if (!config.displaySettings.itemPickupSettings.displayItemsPickups) {
            return;
        }
        if (config.itemPickupHudX == 0 || config.itemPickupHudY == 0) {
            int screenWidth = this.client.method_22683().method_4486();
            int screenHeight = this.client.method_22683().method_4502();
            config.itemPickupHudX = screenWidth / 2 + 10;
            config.itemPickupHudY = screenHeight / 2 - 20;
            AutoConfig.getConfigHolder(ModConfig.class).save();
        }
        int x = config.itemPickupHudX;
        int baseY = config.itemPickupHudY;
        for (int i = 0; i < this.itemPickupNotifications.size(); ++i) {
            ItemPickupNotification notif = this.itemPickupNotifications.get(i);
            int y = baseY - i * 20;
            drawContext.method_51427(notif.itemStack, x, y);
            String text = "+ " + notif.count + " ";
            drawContext.method_27535(this.client.field_1772, (class_2561)class_2561.method_43470((String)text).method_10852(notif.itemStack.method_7964()), x + 20, y + 4, -1);
        }
        if (this.fillRatePerSecond != 0.0) {
            String rateText = String.format("Haversack Fill Rate: %.2f/s", this.fillRatePerSecond);
            if (config.displaySettings.displayHaversackFillRate) {
                drawContext.method_27535(this.client.field_1772, (class_2561)class_2561.method_43470((String)rateText), config.haverSackFillRateX, config.haverSackFillRateY, -1);
            }
            String timeText = "Haversack Full in: " + this.timeUntilFull;
            if (config.displaySettings.displayHaversackFullIn) {
                drawContext.method_27535(this.client.field_1772, (class_2561)class_2561.method_43470((String)timeText), config.haversackFullInX, config.haversackFullInY, -1);
            }
        }
    }

    private void handleDurability(class_1799 stack) {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        class_9279 itemData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return;
        }
        class_2487 nbtData = itemData.method_57461();
        if (nbtData == null || !nbtData.method_10545("mbitems:id")) {
            return;
        }
        String id = nbtData.method_10558("mbitems:id").orElse("");
        class_9290 loreComponent = (class_9290)stack.method_58694(class_9334.field_49632);
        if (loreComponent == null) {
            return;
        }
        for (class_2561 lore : loreComponent.comp_2400()) {
            class_7417 class_74172 = lore.method_10851();
            if (!(class_74172 instanceof class_2588)) continue;
            class_2588 translatableContent = (class_2588)class_74172;
            if (id.contains("haversack") && translatableContent.method_11022().contains("mbx.items.infinite_bag.amount_inside")) {
                if (!config.durabilitySettings.haversackDurability) continue;
                this.handleHaversackDurability(stack, nbtData, translatableContent);
                continue;
            }
            if (!id.contains("harvester_") || !translatableContent.method_11022().contains("mbx.durability") || !config.durabilitySettings.harvesterDurability) continue;
            this.handleHarvesterDurability(stack, translatableContent);
        }
    }

    private void handleHaversackDurability(class_1799 stack, class_2487 nbtData, class_2588 content) {
        class_5348 quantityArg = content.method_29434(0);
        String[] parts = quantityArg.getString().split("/");
        if (parts.length < 2) {
            return;
        }
        int maxQuantity = Integer.parseInt(parts[1]);
        class_2487 persistentData = nbtData.method_10562("mbitems:persistent").orElse(null);
        int amountInside = persistentData.method_10550("mbitems:amount_inside").orElse(0);
        long currentTime = System.currentTimeMillis();
        if (this.lastAmountInside >= 0) {
            long deltaTime = currentTime - this.lastCheckTime;
            if (deltaTime >= 1000L) {
                int deltaAmount = amountInside - this.lastAmountInside;
                this.fillRatePerSecond = (double)deltaAmount / ((double)deltaTime / 1000.0);
                this.lastCheckTime = currentTime;
                this.lastAmountInside = amountInside;
                int remaining = maxQuantity - amountInside;
                if (this.fillRatePerSecond > 0.0) {
                    long secondsLeft = (long)((double)remaining / this.fillRatePerSecond);
                    this.timeUntilFull = Utils.formatTime(secondsLeft);
                } else {
                    this.timeUntilFull = "\u221e";
                }
            }
        } else {
            this.lastAmountInside = amountInside;
            this.lastCheckTime = currentTime;
            this.timeUntilFull = "";
        }
        class_9326 changes = class_9326.method_57841().method_57854(class_9334.field_49629, (Object)(maxQuantity - amountInside)).method_57854(class_9334.field_50072, (Object)maxQuantity).method_57853(class_9334.field_49630).method_57852();
        stack.method_7974(amountInside);
        stack.method_59692(changes);
    }

    private void handleHarvesterDurability(class_1799 stack, class_2588 content) {
        class_5348 durabilityArg = content.method_29434(0);
        String durabilityStr = durabilityArg.getString();
        if (!durabilityStr.contains("/")) {
            return;
        }
        String[] parts = durabilityStr.split("/");
        if (parts.length < 2) {
            return;
        }
        int currentDurability = Integer.parseInt(parts[0]);
        int maxDurability = Integer.parseInt(parts[1]);
        class_9326 changes = class_9326.method_57841().method_57854(class_9334.field_49629, (Object)(maxDurability - currentDurability)).method_57854(class_9334.field_50072, (Object)maxDurability).method_57853(class_9334.field_49630).method_57852();
        stack.method_7974(maxDurability - currentDurability);
        stack.method_59692(changes);
    }

    @Environment(value=EnvType.CLIENT)
    private static class ItemPickupNotification {
        final class_1799 itemStack;
        int count;
        int displayTicks;

        ItemPickupNotification(class_1799 itemStack, int count, int displayTicks) {
            this.itemStack = itemStack;
            this.count = count;
            this.displayTicks = displayTicks;
        }
    }
}

