/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.gui;

import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.gui.components.ItemListWidget;
import io.dampen59.mineboxadditions.minebox.MineboxHarvestable;
import io.dampen59.mineboxadditions.minebox.MineboxItem;
import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.ImageUtils;
import io.dampen59.mineboxadditions.utils.RaritiesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntConsumer;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class HarvestablesScreen
extends class_437 {
    private static final int PADDING = 8;
    private static final int ROW_H = 20;
    private final class_310 mc = class_310.method_1551();
    private String islandKeyPath;
    private List<MineboxHarvestable> data = List.of();
    private final Map<String, List<MineboxHarvestable>> byCategory = new HashMap<String, List<MineboxHarvestable>>();
    private final Map<MineboxHarvestable, List<MineboxHarvestable>> groupMembers = new HashMap<MineboxHarvestable, List<MineboxHarvestable>>();
    private final Map<String, class_4286> catChecks = new HashMap<String, class_4286>();
    private final Map<MineboxHarvestable, class_4286> itemChecks = new HashMap<MineboxHarvestable, class_4286>();
    private final Map<MineboxHarvestable, class_4185> colorButtons = new HashMap<MineboxHarvestable, class_4185>();
    private final Map<MineboxHarvestable, Integer> currentColors = new HashMap<MineboxHarvestable, Integer>();
    private int scrollY = 0;
    private int contentHeight = 0;
    private ModConfig.HarvestablesPrefs prefs;

    public HarvestablesScreen() {
        super((class_2561)class_2561.method_43470((String)"Harvestables"));
    }

    /*
     * WARNING - void declaration
     */
    protected void method_25426() {
        void var7_12;
        int startY;
        String cat;
        super.method_25426();
        class_2960 worldId = this.mc.field_1687 != null ? this.mc.field_1687.method_27983().method_29177() : class_2960.method_60655((String)"minecraft", (String)"overworld");
        this.islandKeyPath = worldId.method_12832();
        ModConfig cfg = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        this.prefs = cfg.harvestablesPrefs.computeIfAbsent(this.islandKeyPath, k -> new ModConfig.HarvestablesPrefs());
        State modState = MineboxAdditionsClient.INSTANCE.modState;
        List<MineboxHarvestable> raw = modState.getMineboxHarvestables(this.islandKeyPath);
        if (raw == null || raw.isEmpty()) {
            raw = modState.getMineboxHarvestables(worldId.toString());
        }
        this.data = raw != null ? raw : List.of();
        HashMap<String, Map> grouped = new HashMap<String, Map>();
        for (MineboxHarvestable mineboxHarvestable : this.data) {
            cat = mineboxHarvestable.getCategory() != null ? mineboxHarvestable.getCategory() : "misc";
            String name = mineboxHarvestable.getName() != null ? mineboxHarvestable.getName() : "unknown";
            grouped.computeIfAbsent(cat, k -> new HashMap()).computeIfAbsent(name, k -> new ArrayList()).add(mineboxHarvestable);
        }
        this.byCategory.clear();
        this.groupMembers.clear();
        for (Map.Entry entry : grouped.entrySet()) {
            cat = (String)entry.getKey();
            ArrayList<MineboxHarvestable> reps = new ArrayList<MineboxHarvestable>();
            for (Map.Entry nameEntry : ((Map)entry.getValue()).entrySet()) {
                List members = (List)nameEntry.getValue();
                MineboxHarvestable rep = (MineboxHarvestable)members.get(0);
                reps.add(rep);
                this.groupMembers.put(rep, members);
            }
            reps.sort(Comparator.comparing(h -> h.getName() == null ? "" : h.getName()));
            this.byCategory.put(cat, reps);
        }
        this.preloadAllHarvestableTextures();
        this.method_37067();
        this.catChecks.clear();
        this.itemChecks.clear();
        this.colorButtons.clear();
        this.currentColors.clear();
        int n = startY = 36;
        for (String cat2 : this.sortedCategories()) {
            boolean catChecked = this.prefs.categoryEnabled.getOrDefault(cat2, true);
            class_4286 catCb = class_4286.method_54787((class_2561)class_2561.method_43470((String)cat2), (class_327)this.field_22793).method_54789(24, (int)var7_12).method_54794(catChecked).method_54788();
            this.method_37063((class_364)catCb);
            this.catChecks.put(cat2, catCb);
            var7_12 += 20;
            for (MineboxHarvestable rep : this.byCategory.get(cat2)) {
                String name = rep.getName() != null ? rep.getName() : "unknown";
                boolean itemChecked = this.prefs.itemEnabled.getOrDefault(cat2, Collections.emptyMap()).getOrDefault(name, true);
                int savedColor = this.prefs.itemColor.getOrDefault(cat2, Collections.emptyMap()).getOrDefault(name, -1);
                int count = this.groupMembers.getOrDefault(rep, List.of()).size();
                String label = name + " (" + count + ")";
                class_4286 itCb = class_4286.method_54787((class_2561)class_2561.method_43470((String)""), (class_327)this.field_22793).method_54789(44, (int)var7_12).method_54794(itemChecked).method_54788();
                this.method_37063((class_364)itCb);
                this.itemChecks.put(rep, itCb);
                class_4185 swatch = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), b -> this.field_22787.method_1507((class_437)new ColorPickerScreen(this.savedColorOrCurrent(rep), picked -> {
                    this.currentColors.put(rep, picked);
                    this.prefs.itemColor.computeIfAbsent(cat2, k -> new HashMap()).put(name, picked);
                    this.field_22787.method_1507((class_437)this);
                }, this))).method_46434(this.field_22789 - 8 - 18, (int)(var7_12 + 3), 14, 14).method_46431();
                this.method_37063((class_364)swatch);
                this.colorButtons.put(rep, swatch);
                this.currentColors.put(rep, savedColor);
                var7_12 += 20;
            }
        }
        this.contentHeight = var7_12 - startY;
    }

    private List<String> sortedCategories() {
        ArrayList<String> keys = new ArrayList<String>(this.byCategory.keySet());
        Collections.sort(keys);
        return keys;
    }

    private int savedColorOrCurrent(MineboxHarvestable rep) {
        return this.currentColors.getOrDefault(rep, -1);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        int listTop = 36;
        int listBottom = this.field_22790 - 8 - 26;
        int listH = Math.max(0, listBottom - listTop);
        int maxScroll = Math.max(0, this.contentHeight - listH);
        if (mouseY >= (double)listTop && mouseY <= (double)listBottom && maxScroll > 0) {
            this.scrollY = (int)Math.max(0.0, Math.min((double)maxScroll, (double)this.scrollY - vertical * 20.0));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontal, vertical);
    }

    public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
        draw.method_51433(this.field_22793, "Harvestables \u2014 " + this.islandKeyPath + " (" + this.data.size() + ")", 8, 10, -1, false);
        int listTop = 36;
        int listBottom = this.field_22790 - 8 - 26;
        int listLeft = 8;
        int listRight = this.field_22789 - 8;
        draw.method_25294(listLeft - 2, listTop - 2, listRight + 2, listBottom + 2, Integer.MIN_VALUE);
        draw.method_44379(listLeft, listTop, listRight, listBottom);
        int y = listTop - this.scrollY;
        for (String string : this.sortedCategories()) {
            class_4286 catCb = this.catChecks.get(string);
            if (catCb != null) {
                catCb.method_48229(listLeft + 16, y);
            }
            y += 20;
            for (MineboxHarvestable rep : this.byCategory.getOrDefault(string, List.of())) {
                class_4185 sw;
                class_4286 itCb = this.itemChecks.get(rep);
                if (itCb != null) {
                    itCb.method_48229(listLeft + 36, y);
                }
                if ((sw = this.colorButtons.get(rep)) != null) {
                    sw.method_48229(listRight - 18, y + 3);
                }
                y += 20;
            }
        }
        super.method_25394(draw, mouseX, mouseY, delta);
        int rowY = listTop - this.scrollY;
        for (String cat : this.sortedCategories()) {
            rowY += 20;
            for (MineboxHarvestable rep : this.byCategory.getOrDefault(cat, List.of())) {
                int cbX = listLeft + 36;
                int afterCb = cbX + 20;
                int iconX = afterCb + 4;
                int iconY = rowY + 2;
                String id = rep.getName() != null ? rep.getName() : "unknown";
                MineboxItem item = MineboxAdditionsClient.INSTANCE.modState.getItemById(id);
                class_2960 icon = ItemListWidget.ItemEntry.getTexture(id);
                if (icon == null && (icon = HarvestablesScreen.resolveHarvestableIcon(id)) != null) {
                    ItemListWidget.ItemEntry.getTextureCache().put(id, icon);
                    if (item != null) {
                        HarvestablesScreen.preloadIngredientTextures(item);
                    }
                }
                if (icon != null) {
                    draw.method_25290(class_10799.field_56883, icon, iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
                }
                int textX = iconX + (icon != null ? 20 : 0);
                int nameY = rowY + 4;
                class_2561 nameText = item != null ? MineboxItem.getDisplayName(item) : class_2561.method_43471((String)("mbx.harvestables." + id + ".name"));
                int nameColor = -1;
                if (item != null && item.getRarity() != null) {
                    nameColor = RaritiesUtils.getRarityColor(item.getRarity().toLowerCase()).getRGB() | 0xFF000000;
                }
                draw.method_51439(this.field_22793, nameText, textX, nameY, nameColor, false);
                int nameW = this.field_22793.method_27525((class_5348)nameText);
                int cnt = this.groupMembers.getOrDefault(rep, List.of()).size();
                String cntStr = " (" + cnt + ")";
                draw.method_51433(this.field_22793, cntStr, textX + nameW, nameY, -5592406, false);
                rowY += 20;
            }
        }
        for (Map.Entry<MineboxHarvestable, class_4185> entry : this.colorButtons.entrySet()) {
            class_4185 sw = entry.getValue();
            int col = this.currentColors.getOrDefault(entry.getKey(), -1) | 0xFF000000;
            String hash = "#";
            int tw = this.field_22793.method_1727(hash);
            Objects.requireNonNull(this.field_22793);
            int th = 9;
            int cx = sw.method_46426() + (sw.method_25368() - tw) / 2;
            int cy = sw.method_46427() + (sw.method_25364() - th) / 2 + 1;
            draw.method_51433(this.field_22793, hash, cx, cy, col, false);
        }
        draw.method_44380();
    }

    public void method_25419() {
        ModConfig cfg = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        ModConfig.HarvestablesPrefs p = cfg.harvestablesPrefs.computeIfAbsent(this.islandKeyPath, k -> new ModConfig.HarvestablesPrefs());
        p.categoryEnabled.clear();
        for (String cat : this.byCategory.keySet()) {
            class_4286 cb = this.catChecks.get(cat);
            if (cb == null) continue;
            p.categoryEnabled.put(cat, cb.method_20372());
        }
        p.itemEnabled.clear();
        p.itemColor.clear();
        for (String cat : this.byCategory.keySet()) {
            HashMap<String, Boolean> itemsChecked = new HashMap<String, Boolean>();
            HashMap<String, Integer> itemsColor = new HashMap<String, Integer>();
            for (MineboxHarvestable rep : this.byCategory.get(cat)) {
                String name = rep.getName() != null ? rep.getName() : "unknown";
                class_4286 cb = this.itemChecks.get(rep);
                if (cb != null) {
                    itemsChecked.put(name, cb.method_20372());
                }
                int col = this.currentColors.getOrDefault(rep, -1);
                itemsColor.put(name, col);
            }
            p.itemEnabled.put(cat, itemsChecked);
            p.itemColor.put(cat, itemsColor);
        }
        AutoConfig.getConfigHolder(ModConfig.class).save();
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    private static String idOf(MineboxHarvestable h) {
        String n = h.getName();
        return n != null && !n.isEmpty() ? n : "unknown";
    }

    private static class_2960 resolveHarvestableIcon(String id) {
        String b64;
        class_2960 cached = ItemListWidget.ItemEntry.getTexture(id);
        if (cached != null) {
            return cached;
        }
        MineboxItem item = MineboxAdditionsClient.INSTANCE.modState.getItemById(id);
        if (item != null && (b64 = item.getTexture()) != null && !b64.isEmpty()) {
            try {
                String textureName = "textures/items/" + id + ".png";
                return ImageUtils.createTextureFromBase64(b64, textureName);
            }
            catch (Exception e) {
                System.err.println("Failed to decode texture for harvestable " + id);
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void preloadIngredientTextures(MineboxItem item) {
        if (item.getRecipe() == null || item.getRecipe().getIngredients() == null) {
            return;
        }
        Map<String, class_2960> cache = ItemListWidget.ItemEntry.getTextureCache();
        for (MineboxItem.Ingredient ing : item.getRecipe().getIngredients()) {
            if (!ing.isVanilla()) {
                MineboxItem sub = ing.getCustomItem();
                if (sub == null) continue;
                String sid = sub.getId();
                if (!cache.containsKey(sid)) {
                    try {
                        String textureName = "textures/items/" + sid + ".png";
                        class_2960 icon = ImageUtils.createTextureFromBase64(sub.getTexture(), textureName);
                        if (icon != null) {
                            cache.put(sid, icon);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to decode ingredient texture for " + sid);
                        e.printStackTrace();
                    }
                }
                HarvestablesScreen.preloadIngredientTextures(sub);
                continue;
            }
            String vid = ing.getId();
            cache.putIfAbsent(vid, class_2960.method_60655((String)"minecraft", (String)("textures/item/" + vid + ".png")));
        }
    }

    private void preloadAllHarvestableTextures() {
        Map<String, class_2960> cache = ItemListWidget.ItemEntry.getTextureCache();
        for (List<MineboxHarvestable> reps : this.byCategory.values()) {
            for (MineboxHarvestable rep : reps) {
                class_2960 icon;
                String id = rep.getName();
                if (id == null || id.isEmpty() || cache.containsKey(id) || (icon = HarvestablesScreen.resolveHarvestableIcon(id)) == null) continue;
                cache.put(id, icon);
                MineboxItem item = MineboxAdditionsClient.INSTANCE.modState.getItemById(id);
                if (item == null) continue;
                HarvestablesScreen.preloadIngredientTextures(item);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ColorPickerScreen
    extends class_437 {
        private final int initialColor;
        private final IntConsumer onPicked;
        private final class_437 parent;
        private class_342 hexField;
        private int color;
        private final List<class_4185> presetButtons = new ArrayList<class_4185>();
        private final Map<class_4185, Integer> presetColors = new HashMap<class_4185, Integer>();

        protected ColorPickerScreen(int initialColor, IntConsumer onPicked, class_437 parent) {
            super((class_2561)class_2561.method_43470((String)"Pick Color"));
            this.color = this.initialColor = initialColor & 0xFFFFFF;
            this.onPicked = onPicked;
            this.parent = parent;
        }

        protected void method_25426() {
            int cx = this.field_22789 / 2;
            int y = 40;
            this.hexField = new class_342(this.field_22793, cx - 60, y, 120, 20, (class_2561)class_2561.method_43470((String)"Hex"));
            this.hexField.method_1880(7);
            this.hexField.method_1852("#" + ColorPickerScreen.toHex(this.color));
            this.hexField.method_1863(this::onHexChanged);
            this.method_37063((class_364)this.hexField);
            y += 26;
            int[] presets = new int[]{0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 65535, 0xFF00FF, 16753920};
            int startX = cx - presets.length * 22 / 2;
            for (int i = 0; i < presets.length; ++i) {
                int c = presets[i];
                class_4185 presetBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), b -> {
                    this.color = c;
                    this.hexField.method_1852("#" + ColorPickerScreen.toHex(this.color));
                }).method_46434(startX + i * 22, y, 18, 18).method_46431();
                this.method_37063((class_364)presetBtn);
                this.presetButtons.add(presetBtn);
                this.presetColors.put(presetBtn, c);
            }
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), b -> {
                this.onPicked.accept(this.color);
                this.method_25419();
            }).method_46434(cx - 80, y += 28, 70, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46434(cx + 10, y, 70, 20).method_46431());
        }

        private void onHexChanged(String text) {
            int parsed = ColorPickerScreen.parseHexPartial(text, this.color);
            if (parsed != -1) {
                this.color = parsed;
            }
        }

        public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
            int cx = this.field_22789 / 2;
            draw.method_51433(this.field_22793, "Pick Beam Color", cx - 50, 16, 0xFFFFFF, false);
            int px0 = cx - 40;
            int py0 = 20;
            int px1 = cx + 40;
            int py1 = 36;
            int col = 0xFF000000 | this.color;
            draw.method_25294(px0 - 1, py0 - 1, px1 + 1, py1 + 1, -16777216);
            draw.method_25294(px0, py0, px1, py1, col);
            super.method_25394(draw, mouseX, mouseY, delta);
            for (class_4185 btn : this.presetButtons) {
                int c = this.presetColors.getOrDefault(btn, -1) | 0xFF000000;
                String hash = "#";
                int tw = this.field_22793.method_1727(hash);
                Objects.requireNonNull(this.field_22793);
                int th = 9;
                int cxTxt = btn.method_46426() + (btn.method_25368() - tw) / 2;
                int cyTxt = btn.method_46427() + (btn.method_25364() - th) / 2 + 1;
                draw.method_51433(this.field_22793, hash, cxTxt, cyTxt, c, false);
            }
        }

        public void method_25419() {
            this.field_22787.method_1507(this.parent);
        }

        private static String toHex(int rgb) {
            Object s = Integer.toHexString(rgb & 0xFFFFFF).toUpperCase(Locale.ROOT);
            while (((String)s).length() < 6) {
                s = "0" + (String)s;
            }
            return s;
        }

        private static int parseHexPartial(String text, int fallback) {
            if (text == null) {
                return -1;
            }
            String t = text.trim();
            if (t.startsWith("#")) {
                t = t.substring(1);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < t.length(); ++i) {
                char ch = t.charAt(i);
                if (!(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f') && (ch < 'A' || ch > 'F')) continue;
                sb.append(ch);
            }
            Object hex = sb.toString();
            if (((String)hex).isEmpty()) {
                return -1;
            }
            if (((String)hex).length() == 3) {
                char r = ((String)hex).charAt(0);
                char g = ((String)hex).charAt(1);
                char b = ((String)hex).charAt(2);
                hex = "" + r + r + g + g + b + b;
            } else {
                if (((String)hex).length() > 6) {
                    hex = ((String)hex).substring(0, 6);
                }
                if (((String)hex).length() < 6) {
                    hex = String.format(Locale.ROOT, "%-6s", hex).replace(' ', '0');
                }
            }
            try {
                return Integer.parseInt((String)hex, 16) & 0xFFFFFF;
            }
            catch (Exception e) {
                return fallback & 0xFFFFFF;
            }
        }
    }
}

