/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.gui;

import io.dampen59.mineboxadditions.ModConfig;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class HudEditorScreen
extends class_437 {
    private final ModConfig config;
    private DragTarget dragging = null;
    private int offsetX;
    private int offsetY;
    private static final int PICKUPS_H = 20;
    private static final int PICKUPS_W = 180;

    public HudEditorScreen(ModConfig config) {
        super((class_2561)class_2561.method_43470((String)"HUD Editor"));
        this.config = config;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isInBounds(mouseX, mouseY, this.config.rainHudX, this.config.rainHudY)) {
                this.dragging = DragTarget.RAIN;
                this.offsetX = (int)mouseX - this.config.rainHudX;
                this.offsetY = (int)mouseY - this.config.rainHudY;
                return true;
            }
            if (this.isInBounds(mouseX, mouseY, this.config.stormHudX, this.config.stormHudY)) {
                this.dragging = DragTarget.STORM;
                this.offsetX = (int)mouseX - this.config.stormHudX;
                this.offsetY = (int)mouseY - this.config.stormHudY;
                return true;
            }
            if (this.isInBounds(mouseX, mouseY, this.config.shopHudX, this.config.shopHudY)) {
                this.dragging = DragTarget.SHOP;
                this.offsetX = (int)mouseX - this.config.shopHudX;
                this.offsetY = (int)mouseY - this.config.shopHudY;
                return true;
            }
            if (this.isInBounds(mouseX, mouseY, this.config.fullMoonHudX, this.config.fullMoonHudY)) {
                this.dragging = DragTarget.FULL_MOON;
                this.offsetX = (int)mouseX - this.config.fullMoonHudX;
                this.offsetY = (int)mouseY - this.config.fullMoonHudY;
                return true;
            }
            if (this.isInBounds(mouseX, mouseY, this.config.haverSackFillRateX, this.config.haverSackFillRateY)) {
                this.dragging = DragTarget.HS_FILL_RATE;
                this.offsetX = (int)mouseX - this.config.haverSackFillRateX;
                this.offsetY = (int)mouseY - this.config.haverSackFillRateY;
                return true;
            }
            if (this.isInBounds(mouseX, mouseY, this.config.haversackFullInX, this.config.haversackFullInY)) {
                this.dragging = DragTarget.HS_FULL_IN;
                this.offsetX = (int)mouseX - this.config.haversackFullInX;
                this.offsetY = (int)mouseY - this.config.haversackFullInY;
                return true;
            }
            if (this.isInBounds(mouseX, mouseY, this.config.mermaidRequestHudX, this.config.getMermaidRequestHudY)) {
                this.dragging = DragTarget.MERMAID_OFFER;
                this.offsetX = (int)mouseX - this.config.mermaidRequestHudX;
                this.offsetY = (int)mouseY - this.config.getMermaidRequestHudY;
                return true;
            }
            if (this.isInBounds(mouseX, mouseY, this.config.itemPickupHudX, this.config.itemPickupHudY, 180, 20)) {
                this.dragging = DragTarget.ITEM_PICKUPS;
                this.offsetX = (int)mouseX - this.config.itemPickupHudX;
                this.offsetY = (int)mouseY - this.config.itemPickupHudY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.dragging = null;
        AutoConfig.getConfigHolder(ModConfig.class).save();
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging != null) {
            if (this.dragging == DragTarget.RAIN) {
                this.config.rainHudX = (int)mouseX - this.offsetX;
                this.config.rainHudY = (int)mouseY - this.offsetY;
            } else if (this.dragging == DragTarget.STORM) {
                this.config.stormHudX = (int)mouseX - this.offsetX;
                this.config.stormHudY = (int)mouseY - this.offsetY;
            } else if (this.dragging == DragTarget.SHOP) {
                this.config.shopHudX = (int)mouseX - this.offsetX;
                this.config.shopHudY = (int)mouseY - this.offsetY;
            } else if (this.dragging == DragTarget.FULL_MOON) {
                this.config.fullMoonHudX = (int)mouseX - this.offsetX;
                this.config.fullMoonHudY = (int)mouseY - this.offsetY;
            } else if (this.dragging == DragTarget.HS_FILL_RATE) {
                this.config.haverSackFillRateX = (int)mouseX - this.offsetX;
                this.config.haverSackFillRateY = (int)mouseY - this.offsetY;
            } else if (this.dragging == DragTarget.HS_FULL_IN) {
                this.config.haversackFullInX = (int)mouseX - this.offsetX;
                this.config.haversackFullInY = (int)mouseY - this.offsetY;
            } else if (this.dragging == DragTarget.MERMAID_OFFER) {
                this.config.mermaidRequestHudX = (int)mouseX - this.offsetX;
                this.config.getMermaidRequestHudY = (int)mouseY - this.offsetY;
            } else if (this.dragging == DragTarget.ITEM_PICKUPS) {
                this.config.itemPickupHudX = (int)mouseX - this.offsetX;
                this.config.itemPickupHudY = (int)mouseY - this.offsetY;
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.drawLabel(context, this.config.rainHudX, this.config.rainHudY, "Next Rain: 00:00:00");
        this.drawLabel(context, this.config.stormHudX, this.config.stormHudY, "Next Storm: 00:00:00");
        this.drawLabel(context, this.config.shopHudX, this.config.shopHudY, "Shop name: Shop offer");
        class_2960 texture = class_2960.method_60655((String)"mineboxadditions", (String)"textures/gui/moon_phases/full_moon.png");
        context.method_25290(class_10799.field_56883, texture, this.config.fullMoonHudX, this.config.fullMoonHudY, 0.0f, 0.0f, 24, 24, 24, 24);
        this.drawLabel(context, this.config.haverSackFillRateX, this.config.haverSackFillRateY, "Haversack Fill Rate: 0.0/s");
        this.drawLabel(context, this.config.haversackFullInX, this.config.haversackFullInY, "Haversack Full in: 00:00:00");
        this.drawLabel(context, this.config.mermaidRequestHudX, this.config.getMermaidRequestHudY, "Mermaid request: 1x Bedrock");
        this.drawPickupsPreview(context, this.config.itemPickupHudX, this.config.itemPickupHudY);
    }

    private void drawLabel(class_332 context, int x, int y, String text) {
        context.method_25294(x - 2, y - 2, x + 130, y + 12, 0x55000000);
        context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)text), x, y, -1, false);
    }

    private boolean isInBounds(double mouseX, double mouseY, int x, int y) {
        return mouseX >= (double)x && mouseX <= (double)(x + 130) && mouseY >= (double)y && mouseY <= (double)(y + 12);
    }

    private boolean isInBounds(double mouseX, double mouseY, int x, int y, int w, int h) {
        return mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
    }

    private void drawPickupsPreview(class_332 ctx, int x, int y) {
        ctx.method_25294(x - 2, y - 2, x + 180 + 2, y + 20 + 2, 0x55000000);
        ctx.method_25294(x, y + 2, x + 16, y + 18, 0x77FFFFFF);
        int rowY = y + 4;
        ctx.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"+ 1 ").method_10852((class_2561)class_2561.method_43470((String)"Bedrock (Item Pickups)")), x + 20, rowY, -1, true);
    }

    public boolean method_25421() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    static enum DragTarget {
        RAIN,
        STORM,
        SHOP,
        FULL_MOON,
        HS_FILL_RATE,
        HS_FULL_IN,
        MERMAID_OFFER,
        ITEM_PICKUPS;

    }
}

