/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.gui;

import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.gui.components.ItemDetailPanel;
import io.dampen59.mineboxadditions.gui.components.ItemListWidget;
import io.dampen59.mineboxadditions.minebox.MineboxItem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class MineboxAtlasScreen
extends class_437 {
    private ItemListWidget itemList;
    private class_342 searchField;
    private List<MineboxItem> allItems;
    private MineboxItem selectedItem = null;
    private ItemDetailPanel itemDetailPanel;

    public MineboxAtlasScreen() {
        super(class_2561.method_30163((String)"Minebox Atlas"));
    }

    protected void method_25426() {
        MineboxItem locked;
        int left = 10;
        int top = 45;
        int height = this.field_22790 - 100;
        class_327 textRenderer = class_310.method_1551().field_1772;
        int maxTextWidth = MineboxAdditionsClient.INSTANCE.modState.getMbxItems().stream().map(item -> {
            String line1 = class_2561.method_43471((String)("mbx.items." + item.getId() + ".name")).getString();
            String line2 = "Lvl " + item.getLevel() + " \u2022 " + item.getCategory();
            return Math.max(textRenderer.method_1727(line1), textRenderer.method_1727(line2));
        }).max(Integer::compare).orElse(0);
        int panelWidth = 24 + maxTextWidth + 10;
        this.searchField = new class_342(textRenderer, left, 15, panelWidth, 20, class_2561.method_30163((String)"Search..."));
        this.searchField.method_1863(this::updateFilteredItems);
        this.method_37063((class_364)this.searchField);
        this.itemList = new ItemListWidget(this.field_22787, left, top, panelWidth, height, 25);
        this.method_37063((class_364)this.itemList);
        this.allItems = new ArrayList<MineboxItem>(MineboxAdditionsClient.INSTANCE.modState.getMbxItems());
        this.updateFilteredItems(this.searchField.method_1882());
        int detailX = this.itemList.method_46426() + this.itemList.method_25368() + 20;
        this.itemDetailPanel = new ItemDetailPanel(this::getSelectedItem, detailX, 20, this.field_22789 - panelWidth - 50, height + 70);
        this.method_37063(this.itemDetailPanel);
        this.method_25429(this.itemDetailPanel);
        this.itemDetailPanel.initLockButton(this);
        String lockedId = MineboxAdditionsClient.INSTANCE.modState.getLockedItemId();
        if (lockedId != null && (locked = (MineboxItem)this.allItems.stream().filter(item -> item.getId().equals(lockedId)).findFirst().orElse(null)) != null) {
            this.selectedItem = locked;
            this.itemDetailPanel.lock(locked);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void updateFilteredItems(String query) {
        this.itemList.method_25339();
        this.itemList.method_44382(0.0);
        for (MineboxItem item : this.allItems) {
            if (!this.matchesQuery(item, query)) continue;
            this.itemList.method_25321(new ItemListWidget.ItemEntry(item, this));
        }
    }

    private boolean matchesQuery(MineboxItem item, String query) {
        String q = query.toLowerCase();
        return item.getId().toLowerCase().contains(q) || item.getCategory().toLowerCase().contains(q) || item.getRarity().toLowerCase().contains(q) || MineboxItem.getDisplayName(item).getString().toLowerCase().contains(q);
    }

    public void setSelectedItem(MineboxItem item) {
        this.selectedItem = item;
        if (this.itemDetailPanel != null) {
            this.itemDetailPanel.unlock();
        }
    }

    public MineboxItem getSelectedItem() {
        return this.selectedItem;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.itemDetailPanel.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.itemDetailPanel != null && this.itemDetailPanel.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }
}

