/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.gui.components;

import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.gui.components.ItemListWidget;
import io.dampen59.mineboxadditions.minebox.MineboxItem;
import io.dampen59.mineboxadditions.minebox.MineboxStat;
import io.dampen59.mineboxadditions.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ItemDetailPanel
implements class_4068,
class_364,
class_6379 {
    private final Supplier<MineboxItem> itemSupplier;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int contentHeight = 0;
    private static final int SCROLL_STEP = 12;
    private boolean isLocked = false;
    private MineboxItem lockedItem = null;
    private Integer pendingScrollOffset = null;
    private class_4185 lockButton;
    private class_342 quantityField;
    private int quantity = 1;
    private final Set<String> collapsed = new HashSet<String>();
    private final Map<String, ClickRegion> toggleRegions = new HashMap<String, ClickRegion>();

    public ItemDetailPanel(Supplier<MineboxItem> itemSupplier, int x, int y, int width, int height) {
        this.itemSupplier = itemSupplier;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void initLockButton(class_437 parent) {
        int buttonWidth = 12;
        int buttonHeight = 12;
        int buttonX = this.x + this.width - buttonWidth - 6;
        int buttonY = this.y - buttonHeight - 4;
        this.lockButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\ud83d\udd12"), btn -> {
            this.isLocked = !this.isLocked;
            this.lockButton.method_25355(class_2561.method_30163((String)(this.isLocked ? "\ud83d\udd12" : "\ud83d\udd13")));
            if (this.isLocked) {
                this.lockedItem = this.itemSupplier.get();
                if (this.lockedItem != null) {
                    MineboxAdditionsClient.INSTANCE.modState.setLockedItemId(this.lockedItem.getId());
                    MineboxAdditionsClient.INSTANCE.modState.setLockedItemScrollOffset(this.scrollOffset);
                }
            } else {
                this.unlock();
            }
        }).method_46434(buttonX, buttonY, buttonWidth, buttonHeight).method_46431();
        parent.method_37063((class_364)this.lockButton);
        this.quantityField = new class_342(class_310.method_1551().field_1772, this.x + 6, this.y - 16, 40, 12, class_2561.method_30163((String)"Qty"));
        this.quantityField.method_1880(4);
        this.quantityField.method_1852("1");
        this.quantityField.method_1863(text -> {
            try {
                int newQty = Integer.parseInt(text.trim());
                if (newQty > 0) {
                    this.quantity = newQty;
                    if (this.isLocked && this.lockedItem != null) {
                        MineboxAdditionsClient.INSTANCE.modState.setLockedItemQuantity(this.quantity);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        parent.method_37063((class_364)this.quantityField);
    }

    public void unlock() {
        this.isLocked = false;
        this.lockedItem = null;
        this.quantity = 1;
        if (this.quantityField != null) {
            this.quantityField.method_1852("1");
        }
        if (this.lockButton != null) {
            this.lockButton.method_25355(class_2561.method_30163((String)"\ud83d\udd13"));
        }
        MineboxAdditionsClient.INSTANCE.modState.setLockedItemId(null);
        MineboxAdditionsClient.INSTANCE.modState.setLockedItemScrollOffset(null);
        MineboxAdditionsClient.INSTANCE.modState.setLockedCollapsedKeys(Collections.emptySet());
    }

    public void lock(MineboxItem item) {
        int savedQty;
        this.isLocked = true;
        this.lockedItem = item;
        if (this.lockButton != null) {
            this.lockButton.method_25355(class_2561.method_30163((String)"\ud83d\udd12"));
        }
        int n = this.quantity = (savedQty = MineboxAdditionsClient.INSTANCE.modState.getLockedItemQuantity()) > 0 ? savedQty : 1;
        if (this.quantityField != null) {
            this.quantityField.method_1852(String.valueOf(this.quantity));
        }
        MineboxAdditionsClient.INSTANCE.modState.setLockedItemQuantity(this.quantity);
        Integer savedScroll = MineboxAdditionsClient.INSTANCE.modState.getLockedItemScrollOffset();
        if (savedScroll != null) {
            this.pendingScrollOffset = savedScroll;
        }
        this.collapsed.clear();
        this.collapsed.addAll(MineboxAdditionsClient.INSTANCE.modState.getLockedCollapsedKeys());
    }

    private boolean playerHasIngredient(MineboxItem.Ingredient ingredient, int multiplier) {
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        class_1661 inventory = class_310.method_1551().field_1724.method_31548();
        int requiredAmount = ingredient.getAmount() * multiplier;
        int totalCount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            String mbxItemId;
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            if (ingredient.isVanilla()) {
                class_1792 ingredientItem = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)ingredient.getId()));
                if (stack.method_7909() != ingredientItem || (totalCount += stack.method_7947()) < requiredAmount) continue;
                return true;
            }
            if (!Utils.isMineboxItem(stack) || (mbxItemId = Utils.getMineboxItemId(stack)) == null || !mbxItemId.equals(ingredient.getId()) || (totalCount += stack.method_7947()) < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        List<MineboxItem> usedIn;
        MineboxItem item;
        this.toggleRegions.clear();
        MineboxItem mineboxItem = item = this.isLocked ? this.lockedItem : this.itemSupplier.get();
        if (item == null) {
            return;
        }
        if (this.pendingScrollOffset != null) {
            this.scrollOffset = Math.max(0, this.pendingScrollOffset);
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        int lineHeight = 12;
        int leftMargin = this.x + 6;
        context.method_51448().pushMatrix();
        context.method_25294(this.x - 6, this.y - 6, this.x + this.width + 6, this.y + this.height, -1442840576);
        context.method_44379(this.x, this.y, this.x + this.width, this.y + this.height);
        context.method_51448().translate(0.0f, (float)(-this.scrollOffset));
        int drawY = this.y + 5;
        class_2960 icon = ItemListWidget.ItemEntry.getTexture(item.getId());
        int iconSize = 32;
        if (icon != null) {
            int iconX = this.x + (this.width - iconSize) / 2;
            context.method_25290(class_10799.field_56883, icon, iconX, drawY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        class_2561 nameText = MineboxItem.getDisplayName(item);
        int nameWidth = textRenderer.method_27525((class_5348)nameText);
        int nameX = this.x + (this.width - nameWidth) / 2;
        context.method_51439(textRenderer, nameText, nameX, drawY += iconSize + 4, -1, false);
        drawY += 14;
        String loreText = MineboxItem.getLoreText(item.getId());
        if (!loreText.isEmpty()) {
            String fullLore = "\u00ab " + loreText + " \u00bb";
            int n = textRenderer.method_1727(fullLore);
            int loreX = this.x + (this.width - n) / 2;
            context.method_51439(textRenderer, class_2561.method_30163((String)fullLore), loreX, drawY, -9605779, false);
            drawY += 14;
        }
        context.method_51439(textRenderer, class_2561.method_30163((String)("Level: " + item.getLevel())), leftMargin, drawY, -5592406, false);
        context.method_51439(textRenderer, class_2561.method_30163((String)("Category: " + item.getCategory())), leftMargin, drawY += 12, -5592406, false);
        context.method_51439(textRenderer, class_2561.method_30163((String)("Rarity: " + item.getRarity())), leftMargin, drawY += 12, -5592406, false);
        drawY += 12;
        if (item.getMbxStats() != null) {
            for (Map.Entry entry : item.getMbxStats().entrySet()) {
                String stat = (String)entry.getKey() + ": " + ((MineboxStat)entry.getValue()).getMin() + " - " + ((MineboxStat)entry.getValue()).getMax();
                context.method_51439(textRenderer, class_2561.method_30163((String)stat), leftMargin, drawY, -3355444, false);
                drawY += 12;
            }
        }
        if (!(usedIn = MineboxAdditionsClient.INSTANCE.modState.getMbxItems().stream().filter(other -> other.getRecipe() != null && other.getRecipe().getIngredients() != null).filter(other -> other.getRecipe().getIngredients().stream().anyMatch(ing -> !ing.isVanilla() && item.getId().equals(ing.getId()))).toList()).isEmpty()) {
            context.method_51439(textRenderer, class_2561.method_30163((String)"Used in:"), leftMargin, drawY, -10496, false);
            drawY += 12;
            for (MineboxItem parent : usedIn) {
                context.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)"\u2192 ").method_10852(MineboxItem.getDisplayName(parent)), leftMargin + 8, drawY, -1, false);
                drawY += 12;
            }
            drawY += 4;
        }
        if (item.getRecipe() != null && item.getRecipe().getIngredients() != null) {
            context.method_51439(textRenderer, class_2561.method_30163((String)"Recipe:"), leftMargin, drawY, -10496, false);
            drawY += 12;
            List<MineboxItem.Ingredient> list = item.getRecipe().getIngredients();
            for (int i = 0; i < list.size(); ++i) {
                boolean isLast = i == list.size() - 1;
                drawY = this.renderRecipeIngredient(context, textRenderer, list.get(i), leftMargin, drawY, 0, this.quantity, isLast, "root");
            }
        }
        this.contentHeight = drawY - this.y;
        this.maxScroll = Math.max(0, this.contentHeight - this.height);
        if (this.pendingScrollOffset != null) {
            this.scrollOffset = Math.max(0, Math.min(this.pendingScrollOffset, this.maxScroll));
            this.pendingScrollOffset = null;
        }
        context.method_44380();
        context.method_51448().popMatrix();
    }

    private int renderRecipeIngredient(class_332 context, class_327 textRenderer, MineboxItem.Ingredient ingredient, int x, int y, int depth, int amountMultiplier, boolean isLast, String path) {
        int iconSize = 16;
        int spacing = 6;
        int indent = (1 + depth) * 12;
        int amount = ingredient.getAmount() * amountMultiplier;
        boolean hasItem = this.playerHasIngredient(ingredient, amountMultiplier);
        int stacks = amount / 64;
        int remainder = amount % 64;
        int iconX = x + indent;
        boolean expandable = !ingredient.isVanilla() && ingredient.getCustomItem() != null && ingredient.getCustomItem().getRecipe() != null && ingredient.getCustomItem().getRecipe().getIngredients() != null && !ingredient.getCustomItem().getRecipe().getIngredients().isEmpty();
        String key = this.nodeKey(path, ingredient);
        if (expandable) {
            boolean isCollapsed = this.collapsed.contains(key);
            String twisty = isCollapsed ? "\u25b6" : "\u25bc";
            int twistyX = iconX - 10;
            Objects.requireNonNull(textRenderer);
            int twistyY = y + (16 - 9) / 2;
            context.method_51439(textRenderer, class_2561.method_30163((String)twisty), twistyX, twistyY, -3355444, false);
            this.toggleRegions.put(key, new ClickRegion(twistyX - 2, y, 12, 16));
        }
        if (ingredient.isVanilla()) {
            class_1799 stack = ingredient.getVanillaStack();
            if (!stack.method_7960()) {
                context.method_51427(stack, iconX, y);
            }
        } else {
            class_2960 icon = ingredient.getTexture();
            if (icon != null) {
                context.method_25290(class_10799.field_56883, icon, iconX, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        int textX = iconX + 16 + 4;
        Objects.requireNonNull(textRenderer);
        int textY = y + (16 - 9) / 2;
        class_5250 amountText = class_2561.method_43470((String)String.valueOf(amount));
        if (stacks > 0) {
            String stackInfo = remainder > 0 ? String.format(" (%ds + %d)", stacks, remainder) : String.format(" (%ds)", stacks);
            amountText.method_10852((class_2561)class_2561.method_43470((String)stackInfo).method_27694(style -> style.method_36139(-5272026)));
        }
        amountText.method_10852((class_2561)class_2561.method_43470((String)" \u00d7 ")).method_10852(ingredient.getDisplayName()).method_10852((class_2561)class_2561.method_43470((String)(hasItem ? " \u2705" : " \u274c")).method_27694(style -> style.method_36139(hasItem ? -11141291 : -43691)));
        context.method_51439(textRenderer, (class_2561)amountText, textX, textY, -1, false);
        y += 22;
        if (expandable && !this.collapsed.contains(key)) {
            MineboxItem subItem = ingredient.getCustomItem();
            List<MineboxItem.Ingredient> subs = subItem.getRecipe().getIngredients();
            for (int i = 0; i < subs.size(); ++i) {
                boolean lastChild = i == subs.size() - 1;
                String childPath = path + ">" + ingredient.getId() + "#" + i;
                y = this.renderRecipeIngredient(context, textRenderer, subs.get(i), x, y, depth + 1, amount, lastChild, childPath);
            }
        }
        return y;
    }

    public boolean method_25401(double mouseX, double mouseY, double h, double v) {
        if (mouseX < (double)this.x || mouseX > (double)(this.x + this.width) || mouseY < (double)this.y || mouseY > (double)(this.y + this.height)) {
            return false;
        }
        this.scrollOffset = (int)((double)this.scrollOffset - v * 12.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
        if (this.isLocked) {
            MineboxAdditionsClient.INSTANCE.modState.setLockedItemScrollOffset(this.scrollOffset);
        }
        return true;
    }

    private String nodeKey(String path, MineboxItem.Ingredient ing) {
        String id = ing.getId();
        return path + ">" + (ing.isVanilla() ? "v:" : "c:") + id;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.x || mouseX > (double)(this.x + this.width) || mouseY < (double)this.y || mouseY > (double)(this.y + this.height)) {
            return false;
        }
        double adjY = mouseY + (double)this.scrollOffset;
        for (Map.Entry<String, ClickRegion> e : this.toggleRegions.entrySet()) {
            if (!e.getValue().contains(mouseX, adjY)) continue;
            String key = e.getKey();
            boolean expand = this.collapsed.contains(key);
            if (class_437.method_25442()) {
                this.toggleSubtree(key, expand);
            } else if (expand) {
                this.collapsed.remove(key);
            } else {
                this.collapsed.add(key);
            }
            if (this.isLocked) {
                MineboxAdditionsClient.INSTANCE.modState.setLockedCollapsedKeys(new HashSet<String>(this.collapsed));
            }
            return true;
        }
        return false;
    }

    private void toggleSubtree(String rootKey, boolean expand) {
        if (expand) {
            this.collapsed.remove(rootKey);
            this.collapsed.removeIf(k -> k.startsWith(rootKey + ">"));
        } else {
            this.collapsed.add(rootKey);
        }
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    @Environment(value=EnvType.CLIENT)
    private static final class ClickRegion {
        final int x;
        final int y;
        final int w;
        final int h;

        ClickRegion(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        boolean contains(double mx, double my) {
            return mx >= (double)this.x && mx <= (double)(this.x + this.w) && my >= (double)this.y && my <= (double)(this.y + this.h);
        }
    }
}

