/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.gui.components;

import io.dampen59.mineboxadditions.gui.MineboxAtlasScreen;
import io.dampen59.mineboxadditions.minebox.MineboxItem;
import io.dampen59.mineboxadditions.utils.ImageUtils;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ItemListWidget
extends class_350<ItemEntry> {
    private final int left;

    public ItemListWidget(class_310 client, int left, int top, int width, int forcedHeight, int itemHeight) {
        super(client, width, top + forcedHeight, top, itemHeight);
        this.left = left;
        this.method_46421(left);
    }

    public int method_25342() {
        return this.left;
    }

    protected int method_65507() {
        return this.method_46426() + this.field_22758 - 6;
    }

    public int method_25322() {
        return this.field_22758 - 6;
    }

    protected void method_44398(class_332 context, int y, int entryWidth, int entryHeight, int borderColor, int fillColor) {
    }

    protected void method_47399(class_6382 builder) {
    }

    @Environment(value=EnvType.CLIENT)
    public static class ItemEntry
    extends class_350.class_351<ItemEntry> {
        private final MineboxItem item;
        private static final Map<String, class_2960> textureCache = new HashMap<String, class_2960>();
        private final MineboxAtlasScreen parent;

        public ItemEntry(MineboxItem item, MineboxAtlasScreen parent) {
            this.item = item;
            this.parent = parent;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_310 client = class_310.method_1551();
            context.method_51448().pushMatrix();
            boolean isSelected = this.parent.getSelectedItem() == this.item;
            int backgroundColor = 0;
            if (isSelected) {
                backgroundColor = 1430563583;
            } else if (hovered) {
                backgroundColor = 0x33FFFFFF;
            }
            context.method_25294(x, y, x + entryWidth, y + entryHeight + 4, backgroundColor);
            class_2960 icon = textureCache.computeIfAbsent(this.item.getId(), id -> ItemEntry.loadTexture(this.item.getId(), this.item.getTexture()));
            if (icon != null) {
                context.method_25290(class_10799.field_56883, icon, x + 4, y + 4, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            context.method_51439(client.field_1772, MineboxItem.getDisplayName(this.item), x + 24, y + 4, -1, false);
            context.method_51439(client.field_1772, class_2561.method_30163((String)("Lvl " + this.item.getLevel() + " \u2022 " + this.item.getCategory())), x + 24, y + 14, -5592406, false);
            context.method_51448().popMatrix();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.parent.setSelectedItem(this.item);
            this.preloadIngredientTextures(this.item);
            return true;
        }

        @Nullable
        private static class_2960 loadTexture(String id, String base64) {
            try {
                String textureName = "textures/items/" + id + ".png";
                return ImageUtils.createTextureFromBase64(base64, textureName);
            }
            catch (Exception e) {
                System.err.println("Failed to decode texture for item " + id);
                e.printStackTrace();
                return null;
            }
        }

        private void preloadIngredientTextures(MineboxItem item) {
            if (item.getRecipe() == null || item.getRecipe().getIngredients() == null) {
                return;
            }
            for (MineboxItem.Ingredient ingredient : item.getRecipe().getIngredients()) {
                if (!ingredient.isVanilla()) {
                    MineboxItem subItem = ingredient.getCustomItem();
                    if (subItem == null) continue;
                    textureCache.computeIfAbsent(subItem.getId(), id -> ItemEntry.loadTexture(id, subItem.getTexture()));
                    this.preloadIngredientTextures(subItem);
                    continue;
                }
                class_2960 vanillaId = class_2960.method_60655((String)"minecraft", (String)("textures/item/" + ingredient.getId() + ".png"));
                textureCache.putIfAbsent(ingredient.getId(), vanillaId);
            }
        }

        public static class_2960 getTexture(String id) {
            return textureCache.get(id);
        }

        public static Map<String, class_2960> getTextureCache() {
            return textureCache;
        }
    }
}

