/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.utils;

import de.maxhenkel.opus4j.OpusDecoder;
import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.audio.AudioMixer;
import io.dampen59.mineboxadditions.state.AudioDeviceState;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class AudioUtils {
    private static final double MAX_PROXIMITY_DISTANCE = 48.0;

    public static void playAudio(OpusDecoder decoder, byte[] audioData, String playerName) {
        short[] decodedMono;
        if (audioData == null || audioData.length == 0 || decoder == null) {
            return;
        }
        try {
            decodedMono = decoder.decode(audioData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (decodedMono == null || decodedMono.length != 960) {
            return;
        }
        float gain = AudioDeviceState.speakerVolumeMultiplier;
        for (int i = 0; i < decodedMono.length; ++i) {
            float amplified = (float)decodedMono[i] * gain;
            decodedMono[i] = (short)Math.max(-32768.0f, Math.min(32767.0f, amplified));
        }
        AudioMixer mixer = MineboxAdditionsClient.INSTANCE.modState.getAudioManager().getMixer();
        if (mixer != null) {
            mixer.push(playerName, decodedMono);
        }
    }

    public static void playProximityAudio(OpusDecoder decoder, byte[] audioData, float proximityVolume, class_1657 sourcePlayer, String playerName) {
        short[] decodedMono;
        if (audioData == null || audioData.length == 0 || decoder == null) {
            return;
        }
        try {
            decodedMono = decoder.decode(audioData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (decodedMono == null || decodedMono.length != 960) {
            return;
        }
        float totalGain = proximityVolume * AudioDeviceState.speakerVolumeMultiplier;
        float[] stereoVolumes = AudioUtils.computeSurroundVolumes(sourcePlayer);
        short[] stereoPcm = new short[1920];
        for (int i = 0; i < 960; ++i) {
            float sample = (float)decodedMono[i] * totalGain;
            float left = sample * stereoVolumes[0];
            float right = sample * stereoVolumes[1];
            stereoPcm[i * 2] = (short)Math.max(-32768.0f, Math.min(32767.0f, left));
            stereoPcm[i * 2 + 1] = (short)Math.max(-32768.0f, Math.min(32767.0f, right));
        }
        AudioMixer mixer = MineboxAdditionsClient.INSTANCE.modState.getAudioManager().getMixer();
        if (mixer != null) {
            mixer.pushStereo(playerName, stereoPcm);
        }
    }

    public static short[] convertMonoToStereo(short[] monoData) {
        short[] stereoData = new short[monoData.length * 2];
        for (int i = 0; i < monoData.length; ++i) {
            stereoData[2 * i] = monoData[i];
            stereoData[2 * i + 1] = monoData[i];
        }
        return stereoData;
    }

    public static class_1657 getNearbyPlayer(String playerName) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return null;
        }
        class_243 currentPosition = client.field_1724.method_19538();
        for (class_1657 player : client.field_1687.method_18456()) {
            double distance;
            if (player == client.field_1724 || !player.method_5477().getString().equalsIgnoreCase(playerName) || !((distance = currentPosition.method_1022(player.method_19538())) <= 48.0)) continue;
            return player;
        }
        return null;
    }

    public static float computeVolumeMultiplier(class_1657 prmPlayer) {
        class_243 otherPosition;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || prmPlayer == null) {
            return 0.0f;
        }
        class_243 currentPosition = client.field_1724.method_19538();
        double distance = currentPosition.method_1022(otherPosition = prmPlayer.method_19538());
        if (distance <= 16.0) {
            return 1.0f;
        }
        if (distance >= 48.0) {
            return 0.0f;
        }
        double fadeDistance = distance - 16.0;
        double fadeRange = 32.0;
        float volume = (float)(1.0 - fadeDistance / fadeRange);
        return Math.max(0.0f, Math.min(1.0f, volume));
    }

    public static float[] computeSurroundVolumes(class_1657 prmSourcePlayer) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || prmSourcePlayer == null) {
            return new float[]{1.0f, 1.0f};
        }
        class_243 currentPosition = client.field_1724.method_19538();
        class_243 otherPosition = prmSourcePlayer.method_19538();
        double dx = otherPosition.field_1352 - currentPosition.field_1352;
        double dz = otherPosition.field_1350 - currentPosition.field_1350;
        double angleToTarget = Math.toDegrees(Math.atan2(dz, dx));
        float playerYaw = client.field_1724.method_36454();
        double relativeAngle = angleToTarget - (double)playerYaw;
        if ((relativeAngle = (relativeAngle + 360.0) % 360.0) > 180.0) {
            relativeAngle -= 360.0;
        }
        float leftVolume = (float)(Math.cos(Math.toRadians(relativeAngle)) * 0.707);
        float rightVolume = (float)(Math.sin(Math.toRadians(relativeAngle)) * 0.707);
        leftVolume = Math.max(0.0f, Math.min(1.0f, Math.abs(leftVolume)));
        rightVolume = Math.max(0.0f, Math.min(1.0f, Math.abs(rightVolume)));
        if (Math.abs(relativeAngle) > 90.0) {
            float rearReduction = 0.8f;
            leftVolume *= rearReduction;
            rightVolume *= rearReduction;
        }
        return new float[]{leftVolume, rightVolume};
    }

    public static Mixer.Info[] getOutputMixers() {
        return (Mixer.Info[])Arrays.stream(AudioSystem.getMixerInfo()).filter(info -> {
            try {
                Mixer mixer = AudioSystem.getMixer(info);
                mixer.open();
                return mixer.isLineSupported(new DataLine.Info(SourceDataLine.class, new AudioFormat(48000.0f, 16, 2, true, false)));
            }
            catch (Exception e) {
                return false;
            }
        }).toArray(Mixer.Info[]::new);
    }

    public static Mixer.Info[] getInputMixers() {
        return (Mixer.Info[])Arrays.stream(AudioSystem.getMixerInfo()).filter(info -> {
            try {
                Mixer mixer = AudioSystem.getMixer(info);
                mixer.open();
                return mixer.isLineSupported(new DataLine.Info(TargetDataLine.class, new AudioFormat(48000.0f, 16, 1, true, false)));
            }
            catch (Exception e) {
                return false;
            }
        }).toArray(Mixer.Info[]::new);
    }

    public static Mixer.Info getMixerByName(String name, boolean input) {
        Mixer.Info[] infos;
        for (Mixer.Info info : infos = input ? AudioUtils.getInputMixers() : AudioUtils.getOutputMixers()) {
            if (!info.getName().equalsIgnoreCase(name)) continue;
            return info;
        }
        return infos.length > 0 ? infos[0] : null;
    }

    public static Mixer getMixerByName(String name) {
        if (name == null) {
            return null;
        }
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            if (!info.getName().equalsIgnoreCase(name)) continue;
            return AudioSystem.getMixer(info);
        }
        return null;
    }
}

