/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.utils;

import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.minebox.ExtraInventoryItem;
import io.dampen59.mineboxadditions.utils.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ExtraInventoryUtils {
    private static final Map<Integer, String> SLOT_CATEGORY_MAP = Map.of(2, "Helmet", 11, "Chestplate", 20, "Leggings", 29, "Boots", 1, "Necklace", 3, "Ring1", 12, "Ring2", 19, "Belt", 10, "Backpack");

    public static void storeItemInSlot(int setIndex, int slotId, class_1799 itemStack, String itemUid) {
        if (itemStack != null && !itemStack.method_7960()) {
            ExtraInventoryItem storedItem = new ExtraInventoryItem(Utils.getMineboxItemId(itemStack), itemStack.method_63015().getString(), itemUid);
            ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).setItemInSlot(setIndex, slotId, storedItem);
            AutoConfig.getConfigHolder(ModConfig.class).save();
        }
    }

    public static ExtraInventoryItem getStoredItem(int setIndex, int slotId) {
        return ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).getItemInSlot(setIndex, slotId);
    }

    public static void setSetName(int setIndex, String name) {
        ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).setSetName(setIndex, name);
        AutoConfig.getConfigHolder(ModConfig.class).save();
    }

    public static String getSetName(int setIndex) {
        return ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).getSetName(setIndex);
    }

    public static void equipSet(class_2371<class_1735> inventorySlots, int setIndex) {
        class_310 client = class_310.method_1551();
        String setName = ExtraInventoryUtils.getSetName(setIndex);
        ArrayList<CallSite> missingItems = new ArrayList<CallSite>();
        boolean foundCurrentItem = false;
        for (Map.Entry<Integer, ExtraInventoryItem> entry : ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).getSet(setIndex).entrySet()) {
            int slotId = entry.getKey();
            ExtraInventoryItem storedItem = entry.getValue();
            String storedItemUuid = storedItem.itemUid;
            for (class_1735 slot : inventorySlots) {
                String inventoryItemUuid;
                class_1799 slotItemStack;
                if (slot.field_7874 < 46 || slot.field_7874 > 89 || !slot.method_7681() || !Utils.isMineboxItem(slotItemStack = slot.method_7677()) || (inventoryItemUuid = Utils.getMineboxItemUid(slotItemStack)) == null || !Objects.equals(storedItemUuid, inventoryItemUuid)) continue;
                class_1703 screenHandler = client.field_1724.field_7512;
                client.field_1761.method_2906(screenHandler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)client.field_1724);
                client.field_1761.method_2906(screenHandler.field_7763, slotId, 0, class_1713.field_7790, (class_1657)client.field_1724);
                client.field_1761.method_2906(screenHandler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)client.field_1724);
                foundCurrentItem = true;
            }
            if (!foundCurrentItem) {
                missingItems.add((CallSite)((Object)("[" + storedItem.itemName + "]")));
                continue;
            }
            foundCurrentItem = false;
        }
        class_5250 returnMessage = null;
        returnMessage = missingItems.isEmpty() ? class_2561.method_43470((String)("\u2714 You have equipped your " + setName + " set successfully ! ")).method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true))) : class_2561.method_43470((String)("\u274c You have equipped your " + setName + " set but the following items were missing : " + missingItems.stream().map(Object::toString).collect(Collectors.joining(", ")))).method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)));
        client.field_1724.method_7353((class_2561)returnMessage, false);
    }

    public static void saveCurrentSetToSlotId(class_2371<class_1735> inventorySlots, int setId) {
        ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).clearSet(setId);
        for (Map.Entry<Integer, String> entry : SLOT_CATEGORY_MAP.entrySet()) {
            String itemUid;
            int slotId = entry.getKey();
            class_1735 slot = ExtraInventoryUtils.findSlotById(inventorySlots, slotId);
            if (slot == null || !slot.method_7681() || !Utils.isMineboxItem(slot.method_7677()) || (itemUid = Utils.getMineboxItemUid(slot.method_7677())) == null) continue;
            ExtraInventoryUtils.storeItemInSlot(setId, slotId, slot.method_7677(), itemUid);
        }
        AutoConfig.getConfigHolder(ModConfig.class).save();
    }

    private static class_1735 findSlotById(class_2371<class_1735> inventorySlots, int slotId) {
        for (class_1735 slot : inventorySlots) {
            if (slot.field_7874 != slotId) continue;
            return slot;
        }
        return null;
    }
}

