/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamresourceful.resourcefulconfig.api.client.ResourcefulConfigScreen;
import com.teamresourceful.resourcefulconfig.api.loader.Configurator;
import io.dampen59.mineboxadditions.config.Config;
import io.dampen59.mineboxadditions.config.ConfigManager;
import io.dampen59.mineboxadditions.events.ContainerOpenEvent;
import io.dampen59.mineboxadditions.events.ServerEvents;
import io.dampen59.mineboxadditions.events.SkyEvent;
import io.dampen59.mineboxadditions.events.WorldRendererEvent;
import io.dampen59.mineboxadditions.features.AutoIsland;
import io.dampen59.mineboxadditions.features.ShinyTracker;
import io.dampen59.mineboxadditions.features.atlas.MineboxAtlasScreen;
import io.dampen59.mineboxadditions.features.fishingshoal.FishingShoalDisplay;
import io.dampen59.mineboxadditions.features.harvestable.HarvestableScreen;
import io.dampen59.mineboxadditions.features.hud.HudEditorScreen;
import io.dampen59.mineboxadditions.features.hud.HudManager;
import io.dampen59.mineboxadditions.features.item.ItemTooltip;
import io.dampen59.mineboxadditions.features.shop.ShopManager;
import io.dampen59.mineboxadditions.features.voicechat.AudioDeviceScreen;
import io.dampen59.mineboxadditions.features.voicechat.AudioDeviceState;
import io.dampen59.mineboxadditions.features.voicechat.AudioManager;
import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.AudioUtils;
import io.dampen59.mineboxadditions.utils.Scheduler;
import io.dampen59.mineboxadditions.utils.SocketManager;
import io.dampen59.mineboxadditions.utils.Utils;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MineboxAdditions
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mineboxadditions");
    public static final String NAMESPACE = "mineboxadditions";
    public static MineboxAdditions INSTANCE;
    public State state = null;
    private static class_304 openModSettings;
    private static class_304 openAudioSettings;
    public static class_304 openEditMode;
    public static class_304 openHarvestables;
    public static class_304 openAtlas;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)NAMESPACE, (String)path);
    }

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(this::tick);
        ConfigManager.init();
        Utils.init();
        this.state = new State();
        SocketManager.init();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> HudManager.INSTANCE.init());
        AutoIsland.init();
        FishingShoalDisplay.init();
        ShinyTracker.init();
        ShopManager.init();
        ItemTooltip.init();
        new SkyEvent();
        new ServerEvents(this.state);
        new ContainerOpenEvent(this.state);
        new WorldRendererEvent();
        new AudioManager(this.state);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> this.registerCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        this.registerKeybinds();
        AudioDeviceState.micGainDb = Config.micGainDb;
        AudioDeviceState.selectedInput = AudioUtils.getMixerByName(Config.selectedMicName, true);
        AudioDeviceState.selectedOutput = AudioUtils.getMixerByName(Config.selectedSpeakerName, false);
        INSTANCE = this;
    }

    public void tick(class_310 client) {
        Scheduler.INSTANCE.tick();
        while (openAudioSettings.method_1436()) {
            class_310.method_1551().method_1507((class_437)new AudioDeviceScreen());
        }
        if (openEditMode.method_1436()) {
            client.method_1507((class_437)new HudEditorScreen());
        }
        if (openAtlas.method_1436()) {
            if (this.state.getMbxItems() == null || this.state.getMbxItems().isEmpty()) {
                Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.errors.missing_atlas_data").getString());
                return;
            }
            client.method_1507((class_437)new MineboxAtlasScreen());
        }
        if (openHarvestables.method_1436()) {
            client.method_1507((class_437)new HarvestableScreen());
        }
        if (openModSettings.method_1436() && client.field_1755 == null) {
            client.method_1507(ResourcefulConfigScreen.make((Configurator)ConfigManager.configurator, Config.class).build());
        }
    }

    private void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"vc").then(ClientCommandManager.literal((String)"create").executes(context -> {
            SocketManager.getSocket().emit("C2SCreateAudioRoom", new Object[0]);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"vc").then(ClientCommandManager.literal((String)"join").then(ClientCommandManager.argument((String)"code", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String code = StringArgumentType.getString((CommandContext)context, (String)"code");
            SocketManager.getSocket().emit("C2SJoinAudioRoom", new Object[]{code});
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"vc").then(ClientCommandManager.literal((String)"proximity").executes(context -> {
            SocketManager.getSocket().emit("C2SToggleProximityAudio", new Object[0]);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"vc").then(ClientCommandManager.literal((String)"leave").executes(context -> {
            SocketManager.getSocket().emit("C2SLeaveAudioRoom", new Object[0]);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"debug").executes(context -> {
            Utils.displayChatInfoMessage("=== MineboxAdditions Debug Informations ===");
            Utils.displayChatInfoMessage("Mod Version: " + Utils.getModVersion());
            Utils.displayChatInfoMessage("Socket state: " + (String)(SocketManager.getSocket().connected() ? "connected (ID : " + SocketManager.getSocket().id() + ")" : "disconnected"));
            Utils.displayChatInfoMessage("Rain Data: " + this.state.getWeatherState().getRainTimestamps().stream().map(String::valueOf).collect(Collectors.joining(", ")));
            Utils.displayChatInfoMessage("Storm Data: " + this.state.getWeatherState().getStormTimestamps().stream().map(String::valueOf).collect(Collectors.joining(", ")));
            Utils.displayChatInfoMessage("Shiny Length: " + ShinyTracker.getShinyCount());
            if (ShopManager.getMermaid().itemTranslationKey != null) {
                Utils.displayChatInfoMessage(String.format("Mermaid Data: {%s, %d}", ShopManager.getMermaid().itemTranslationKey, ShopManager.getMermaid().quantity));
            } else {
                Utils.displayChatInfoMessage("Mermaid Data: None");
            }
            Utils.displayChatInfoMessage("Museum Length: " + this.state.getMissingMuseumItemIds().size());
            return 1;
        })));
    }

    private void registerKeybinds() {
        openModSettings = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.modSettings.open", class_3675.class_307.field_1668, 79, "MineboxAdditions"));
        openAudioSettings = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.audioSettings.open", class_3675.class_307.field_1668, 76, "MineboxAdditions"));
        openEditMode = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.hudEditor.open", class_3675.class_307.field_1668, 73, "MineboxAdditions"));
        openHarvestables = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.harvestables.open", class_3675.class_307.field_1668, 80, "MineboxAdditions"));
        openAtlas = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.atlas.open", class_3675.class_307.field_1668, 344, "MineboxAdditions"));
    }
}

