/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.atlas.widgets;

import io.dampen59.mineboxadditions.MineboxAdditions;
import io.dampen59.mineboxadditions.features.atlas.widgets.ItemListWidget;
import io.dampen59.mineboxadditions.features.item.MineboxItem;
import io.dampen59.mineboxadditions.features.item.MineboxStat;
import io.dampen59.mineboxadditions.utils.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7923;

public class ItemDetailPanel
implements class_4068,
class_364,
class_6379 {
    private final Supplier<MineboxItem> itemSupplier;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int contentHeight = 0;
    private static final int SCROLL_STEP = 12;
    private boolean isLocked = false;
    private MineboxItem lockedItem = null;
    private Integer pendingScrollOffset = null;
    private class_4185 lockButton;
    private class_342 quantityField;
    private class_4185 clipboardButton;
    private int quantity = 1;
    private final Set<String> collapsed = new HashSet<String>();
    private final Map<String, ClickRegion> toggleRegions = new HashMap<String, ClickRegion>();
    private static final int UI_PADDING = 6;
    private static final int CTRL_H = 14;
    private static final int HEADER_H = 26;
    private final Map<String, List<MineboxItem>> usedInCache = new HashMap<String, List<MineboxItem>>();
    private Consumer<MineboxItem> onNavigate;
    private final List<ClickRegionUsedIn> usedInRegions = new ArrayList<ClickRegionUsedIn>();
    private String lastPreloadedItemId = null;

    public ItemDetailPanel(Supplier<MineboxItem> itemSupplier, int x, int y, int width, int height) {
        this.itemSupplier = itemSupplier;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setOnNavigate(Consumer<MineboxItem> onNavigate) {
        this.onNavigate = onNavigate;
    }

    public void initLockButton(class_437 parent) {
        int btnW = 16;
        int btnH = 16;
        int rowY = this.y + 6 + 6;
        class_327 tr = class_310.method_1551().field_1772;
        int fieldW = Math.max(36, tr.method_1727("0000") + 10);
        this.quantityField = new class_342(tr, this.x + 6, rowY, fieldW, 14, class_2561.method_30163((String)"Qty"));
        this.quantityField.method_1880(4);
        this.quantityField.method_1852(String.valueOf(this.quantity));
        this.quantityField.method_1863(text -> {
            try {
                int newQty = Integer.parseInt(text.trim());
                if (newQty > 0) {
                    this.quantity = newQty;
                    if (this.isLocked && this.lockedItem != null) {
                        MineboxAdditions.INSTANCE.state.setLockedItemQuantity(this.quantity);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        parent.method_37063((class_364)this.quantityField);
        int buttonX = this.x + this.width - btnW - 6;
        int buttonY = rowY;
        this.lockButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)(this.isLocked ? "\ud83d\udd12" : "\ud83d\udd13")), btn -> {
            this.isLocked = !this.isLocked;
            this.lockButton.method_25355(class_2561.method_30163((String)(this.isLocked ? "\ud83d\udd12" : "\ud83d\udd13")));
            if (this.isLocked) {
                this.lockedItem = this.itemSupplier.get();
                if (this.lockedItem != null) {
                    MineboxAdditions.INSTANCE.state.setLockedItemId(this.lockedItem.getId());
                    MineboxAdditions.INSTANCE.state.setLockedItemScrollOffset(this.scrollOffset);
                    MineboxAdditions.INSTANCE.state.setLockedItemQuantity(this.quantity);
                }
            } else {
                this.unlock();
            }
        }).method_46434(buttonX, buttonY, btnW, btnH).method_46431();
        parent.method_37063((class_364)this.lockButton);
        this.clipboardButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\ud83d\udccb"), btn -> {
            MineboxItem item;
            MineboxItem mineboxItem = item = this.isLocked ? this.lockedItem : this.itemSupplier.get();
            if (item == null || item.getRecipe() == null || item.getRecipe().getIngredients() == null) {
                return;
            }
            HashMap<String, Integer> flat = new HashMap<String, Integer>();
            for (MineboxItem.Ingredient ing : item.getRecipe().getIngredients()) {
                this.collectBaseIngredients(ing, this.quantity, flat);
            }
            ArrayList<CallSite> lines = new ArrayList<CallSite>();
            for (Map.Entry entry : flat.entrySet()) {
                String name;
                String[] parts = ((String)entry.getKey()).split(":", 2);
                boolean isVanilla = "v".equals(parts[0]);
                String id = parts[1];
                if (isVanilla) {
                    class_2960 rid = class_2960.method_60655((String)"minecraft", (String)id);
                    class_1792 mcItem = (class_1792)class_7923.field_41178.method_63535(rid);
                    name = class_2561.method_43471((String)mcItem.method_7876()).getString();
                } else {
                    name = MineboxItem.getDisplayName(MineboxAdditions.INSTANCE.state.getItemById(id)).getString();
                }
                lines.add((CallSite)((Object)("- " + String.valueOf(entry.getValue()) + "x " + name)));
            }
            lines.sort(String::compareToIgnoreCase);
            class_310.method_1551().field_1774.method_1455(String.join((CharSequence)"\n", lines));
            Utils.showToastNotification(class_2561.method_43471((String)"mineboxadditions.gui.atlas.clipboard.title").getString(), class_2561.method_43471((String)"mineboxadditions.gui.atlas.clipboard.desc").getString());
        }).method_46434(this.x + 6, rowY, 16, 16).method_46431();
        parent.method_37063((class_364)this.clipboardButton);
    }

    private void collectBaseIngredients(MineboxItem.Ingredient ing, int multiplier, Map<String, Integer> out) {
        boolean hasSubRecipe;
        int amount = ing.getAmount() * multiplier;
        boolean bl = hasSubRecipe = !ing.isVanilla() && ing.getCustomItem() != null && ing.getCustomItem().getRecipe() != null && ing.getCustomItem().getRecipe().getIngredients() != null && !ing.getCustomItem().getRecipe().getIngredients().isEmpty();
        if (hasSubRecipe) {
            for (MineboxItem.Ingredient sub : ing.getCustomItem().getRecipe().getIngredients()) {
                this.collectBaseIngredients(sub, amount, out);
            }
        } else {
            String key = (ing.isVanilla() ? "v:" : "c:") + ing.getId();
            out.merge(key, amount, Integer::sum);
        }
    }

    public void unlock() {
        this.isLocked = false;
        this.lockedItem = null;
        this.quantity = 1;
        if (this.quantityField != null) {
            this.quantityField.method_1852("1");
        }
        if (this.lockButton != null) {
            this.lockButton.method_25355(class_2561.method_30163((String)"\ud83d\udd13"));
        }
        MineboxAdditions.INSTANCE.state.setLockedItemId(null);
        MineboxAdditions.INSTANCE.state.setLockedItemScrollOffset(null);
        MineboxAdditions.INSTANCE.state.setLockedCollapsedKeys(Collections.emptySet());
    }

    public void lock(MineboxItem item) {
        int savedQty;
        this.isLocked = true;
        this.lockedItem = item;
        if (this.lockButton != null) {
            this.lockButton.method_25355(class_2561.method_30163((String)"\ud83d\udd12"));
        }
        int n = this.quantity = (savedQty = MineboxAdditions.INSTANCE.state.getLockedItemQuantity()) > 0 ? savedQty : 1;
        if (this.quantityField != null) {
            this.quantityField.method_1852(String.valueOf(this.quantity));
        }
        MineboxAdditions.INSTANCE.state.setLockedItemQuantity(this.quantity);
        Integer savedScroll = MineboxAdditions.INSTANCE.state.getLockedItemScrollOffset();
        if (savedScroll != null) {
            this.pendingScrollOffset = savedScroll;
        }
        this.collapsed.clear();
        this.collapsed.addAll(MineboxAdditions.INSTANCE.state.getLockedCollapsedKeys());
    }

    private boolean playerHasIngredient(MineboxItem.Ingredient ingredient, int multiplier) {
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        class_1661 inventory = class_310.method_1551().field_1724.method_31548();
        int requiredAmount = ingredient.getAmount() * multiplier;
        int totalCount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            if (Utils.isMineboxItem(stack)) {
                String mbxItemIdRaw = Utils.getMineboxItemId(stack);
                String mbxItemId = Utils.processIdMismatch(mbxItemIdRaw);
                if (mbxItemId == null || !mbxItemId.equals(ingredient.getId()) || (totalCount += stack.method_7947()) < requiredAmount) continue;
                return true;
            }
            if (!ingredient.isVanilla()) continue;
            class_1792 ingredientItem = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)ingredient.getId()));
            if (stack.method_7909() != ingredientItem || (totalCount += stack.method_7947()) < requiredAmount) continue;
            return true;
        }
        return false;
    }

    private int playerIngredientCount(MineboxItem.Ingredient ingredient) {
        if (class_310.method_1551().field_1724 == null) {
            return -1;
        }
        class_1661 inventory = class_310.method_1551().field_1724.method_31548();
        int totalCount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            if (Utils.isMineboxItem(stack)) {
                String mbxItemIdRaw = Utils.getMineboxItemId(stack);
                String mbxItemId = Utils.processIdMismatch(mbxItemIdRaw);
                if (mbxItemId == null || !mbxItemId.equals(ingredient.getId())) continue;
                totalCount += stack.method_7947();
                continue;
            }
            if (!ingredient.isVanilla()) continue;
            class_1792 ingredientItem = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)ingredient.getId()));
            if (stack.method_7909() != ingredientItem) continue;
            totalCount += stack.method_7947();
        }
        return totalCount;
    }

    /*
     * WARNING - void declaration
     */
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        List usedIn;
        int startX;
        MineboxItem item;
        this.toggleRegions.clear();
        this.usedInRegions.clear();
        MineboxItem mineboxItem = item = this.isLocked ? this.lockedItem : this.itemSupplier.get();
        if (item == null) {
            return;
        }
        if (!item.getId().equals(this.lastPreloadedItemId)) {
            this.preloadUsedInTextures(item);
        }
        if (this.pendingScrollOffset != null) {
            this.scrollOffset = Math.max(0, this.pendingScrollOffset);
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        int lineHeight = 12;
        int leftMargin = this.x + 6;
        context.method_51448().pushMatrix();
        context.method_25294(this.x - 6, this.y - 6, this.x + this.width + 6, this.y + this.height, -1442840576);
        int headerBottom = this.y + 26;
        context.method_25294(this.x, this.y, this.x + this.width, headerBottom, 0x66000000);
        String label = "Qty:";
        int labelW = textRenderer.method_1727(label);
        int fieldW = Math.max(36, textRenderer.method_1727("0000") + 10);
        if (this.quantityField != null) {
            this.quantityField.method_25358(fieldW);
        }
        int lockW = this.lockButton != null ? this.lockButton.method_25368() : 16;
        int clipW = this.clipboardButton != null ? this.clipboardButton.method_25368() : 16;
        int spacer = 6;
        int rowY = this.y + 6;
        int totalW = labelW + spacer + fieldW + spacer + lockW + spacer + clipW;
        int labelX = startX = this.x + (this.width - totalW) / 2;
        Objects.requireNonNull(textRenderer);
        int labelY = this.y + (26 - 9) / 2;
        context.method_51439(textRenderer, class_2561.method_30163((String)label), labelX, labelY, -1, false);
        if (this.quantityField != null) {
            this.quantityField.method_46421(labelX + labelW + spacer);
            this.quantityField.method_46419(rowY);
        }
        if (this.lockButton != null) {
            this.lockButton.method_46421(this.quantityField.method_46426() + fieldW + spacer);
            this.lockButton.method_46419(rowY);
        }
        if (this.clipboardButton != null) {
            this.clipboardButton.method_46421(this.lockButton.method_46426() + lockW + spacer);
            this.clipboardButton.method_46419(rowY);
        }
        context.method_44379(this.x, this.y + 26, this.x + this.width, this.y + this.height);
        context.method_51448().translate(0.0f, (float)(-this.scrollOffset));
        int drawY = this.y + 26 + 5;
        class_2960 icon = ItemListWidget.ItemEntry.getTexture(item.getId());
        int iconSize = 32;
        if (icon != null) {
            int iconX = this.x + (this.width - iconSize) / 2;
            context.method_25290(class_10799.field_56883, icon, iconX, drawY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        class_2561 nameText = MineboxItem.getDisplayName(item);
        int nameWidth = textRenderer.method_27525((class_5348)nameText);
        int nameX = this.x + (this.width - nameWidth) / 2;
        context.method_51439(textRenderer, nameText, nameX, drawY += iconSize + 4, -1, false);
        drawY += 14;
        String loreText = MineboxItem.getLoreText(item.getId());
        if (!loreText.isEmpty()) {
            String fullLore = "\u00ab " + loreText + " \u00bb";
            int n = textRenderer.method_1727(fullLore);
            int loreX = this.x + (this.width - n) / 2;
            context.method_51439(textRenderer, class_2561.method_30163((String)fullLore), loreX, drawY, -9605779, false);
            drawY += 14;
        }
        context.method_51433(textRenderer, class_2561.method_43469((String)"mineboxadditions.gui.atlas.level", (Object[])new Object[]{item.getLevel()}).getString(), leftMargin, drawY, -5592406, false);
        context.method_51433(textRenderer, class_2561.method_43469((String)"mineboxadditions.gui.atlas.category", (Object[])new Object[]{item.getCategory()}).getString(), leftMargin, drawY += 12, -5592406, false);
        context.method_51433(textRenderer, class_2561.method_43469((String)"mineboxadditions.gui.atlas.rarity", (Object[])new Object[]{item.getRarity()}).getString(), leftMargin, drawY += 12, -5592406, false);
        drawY += 24;
        if (item.getMbxStats() != null && !item.getMbxStats().isEmpty()) {
            context.method_51433(textRenderer, class_2561.method_43471((String)"mineboxadditions.gui.atlas.stats").getString(), leftMargin, drawY, -10496, false);
            drawY += 12;
            for (Map.Entry entry : item.getMbxStats().entrySet()) {
                String statKey = (String)entry.getKey();
                MineboxStat statVal = (MineboxStat)entry.getValue();
                class_2561 statName = MineboxItem.getStatName(statKey);
                class_5250 statRange = class_2561.method_43470((String)(": " + statVal.getMin() + " - " + statVal.getMax()));
                class_5250 fullStatText = class_2561.method_43470((String)"").method_10852(statName).method_10852((class_2561)statRange);
                context.method_51439(textRenderer, (class_2561)fullStatText, leftMargin, drawY, -1, false);
                drawY += 12;
            }
            drawY += 12;
        }
        if (item.getRecipe() != null && item.getRecipe().getIngredients() != null) {
            void var29_33;
            context.method_51433(textRenderer, class_2561.method_43471((String)"mineboxadditions.gui.atlas.recipe").getString(), leftMargin, drawY, -10496, false);
            drawY += 12;
            List<MineboxItem.Ingredient> ingredients = item.getRecipe().getIngredients();
            boolean bl = false;
            while (var29_33 < ingredients.size()) {
                boolean isLast = var29_33 == ingredients.size() - 1;
                drawY = this.renderRecipeIngredient(context, textRenderer, ingredients.get((int)var29_33), leftMargin, drawY, 0, this.quantity, isLast, "root");
                ++var29_33;
            }
            drawY += 4;
        }
        if (!(usedIn = this.usedInCache.computeIfAbsent(item.getId(), key -> MineboxAdditions.INSTANCE.state.getMbxItems().stream().filter(other -> other.getRecipe() != null && other.getRecipe().getIngredients() != null).filter(other -> other.getRecipe().getIngredients().stream().anyMatch(ing -> !ing.isVanilla() && item.getId().equals(ing.getId()))).toList())).isEmpty()) {
            context.method_51433(textRenderer, class_2561.method_43471((String)"mineboxadditions.gui.atlas.used_in").getString(), leftMargin, drawY, -10496, false);
            drawY += 12;
            int n = 16;
            int rowSpacing = 6;
            int textOffset = n + 4;
            for (MineboxItem parent : usedIn) {
                class_2960 parentIcon = ItemListWidget.ItemEntry.getTexture(parent.getId());
                if (parentIcon != null) {
                    context.method_25290(class_10799.field_56883, parentIcon, leftMargin, drawY, 0.0f, 0.0f, n, n, n, n);
                }
                class_2561 name = MineboxItem.getDisplayName(parent);
                Objects.requireNonNull(textRenderer);
                context.method_51439(textRenderer, name, leftMargin + textOffset, drawY + (n - 9) / 2, -1, false);
                int clickableWidth = textOffset + textRenderer.method_27525((class_5348)name);
                this.usedInRegions.add(new ClickRegionUsedIn(new ClickRegion(leftMargin, drawY, clickableWidth, n), parent));
                drawY += n + rowSpacing;
            }
            drawY += 4;
        }
        this.contentHeight = drawY - (this.y + 26);
        this.maxScroll = Math.max(0, this.contentHeight - (this.height - 26));
        if (this.pendingScrollOffset != null) {
            this.scrollOffset = Math.max(0, Math.min(this.pendingScrollOffset, this.maxScroll));
            this.pendingScrollOffset = null;
        }
        context.method_44380();
        context.method_51448().popMatrix();
    }

    private int renderRecipeIngredient(class_332 context, class_327 textRenderer, MineboxItem.Ingredient ingredient, int x, int y, int depth, int amountMultiplier, boolean isLast, String path) {
        int iconSize = 16;
        int spacing = 6;
        int indent = (1 + depth) * 12;
        int amount = ingredient.getAmount() * amountMultiplier;
        boolean hasItem = this.playerHasIngredient(ingredient, amountMultiplier);
        int ingredientCount = this.playerIngredientCount(ingredient);
        int stacks = amount / 64;
        int remainder = amount % 64;
        int iconX = x + indent;
        boolean expandable = !ingredient.isVanilla() && ingredient.getCustomItem() != null && ingredient.getCustomItem().getRecipe() != null && ingredient.getCustomItem().getRecipe().getIngredients() != null && !ingredient.getCustomItem().getRecipe().getIngredients().isEmpty();
        String key = this.nodeKey(path, ingredient);
        if (expandable) {
            boolean isCollapsed = !this.collapsed.contains(key);
            String twisty = isCollapsed ? "\u25b6" : "\u25bc";
            int twistyX = iconX - 10;
            Objects.requireNonNull(textRenderer);
            int twistyY = y + (16 - 9) / 2;
            context.method_51439(textRenderer, class_2561.method_30163((String)twisty), twistyX, twistyY, -3355444, false);
            this.toggleRegions.put(key, new ClickRegion(twistyX - 2, y, 12, 16));
        }
        if (ingredient.isVanilla()) {
            class_1799 stack = ingredient.getVanillaStack();
            if (!stack.method_7960()) {
                context.method_51427(stack, iconX, y);
            }
        } else {
            class_2960 icon = ingredient.getTexture();
            if (icon != null) {
                context.method_25290(class_10799.field_56883, icon, iconX, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        int textX = iconX + 16 + 4;
        Objects.requireNonNull(textRenderer);
        int textY = y + (16 - 9) / 2;
        class_5250 amountText = class_2561.method_43470((String)String.valueOf(amount));
        if (stacks > 0) {
            String stackInfo = remainder > 0 ? String.format(" (%ds + %d)", stacks, remainder) : String.format(" (%ds)", stacks);
            amountText.method_10852((class_2561)class_2561.method_43470((String)stackInfo).method_27694(style -> style.method_36139(-5272026)));
        }
        amountText.method_10852((class_2561)class_2561.method_43470((String)" \u00d7 ")).method_10852(ingredient.getDisplayName()).method_10852((class_2561)class_2561.method_43470((String)(hasItem ? " \u2705" : " \u274c (" + ingredientCount + "/" + amount + ")")).method_27694(style -> style.method_36139(hasItem ? -11141291 : -43691)));
        context.method_51439(textRenderer, (class_2561)amountText, textX, textY, -1, false);
        y += 22;
        if (expandable && this.collapsed.contains(key)) {
            MineboxItem subItem = ingredient.getCustomItem();
            List<MineboxItem.Ingredient> subs = subItem.getRecipe().getIngredients();
            for (int i = 0; i < subs.size(); ++i) {
                boolean lastChild = i == subs.size() - 1;
                String childPath = path + ">" + ingredient.getId() + "#" + i;
                y = this.renderRecipeIngredient(context, textRenderer, subs.get(i), x, y, depth + 1, amount, lastChild, childPath);
            }
        }
        return y;
    }

    public boolean method_25401(double mouseX, double mouseY, double h, double v) {
        if (mouseX < (double)this.x || mouseX > (double)(this.x + this.width) || mouseY < (double)(this.y + 26) || mouseY > (double)(this.y + this.height)) {
            return false;
        }
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset - (int)(v * 12.0), this.maxScroll));
        if (this.isLocked) {
            MineboxAdditions.INSTANCE.state.setLockedItemScrollOffset(this.scrollOffset);
        }
        return true;
    }

    private String nodeKey(String path, MineboxItem.Ingredient ing) {
        String id = ing.getId();
        return path + ">" + (ing.isVanilla() ? "v:" : "c:") + id;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.x || mouseX > (double)(this.x + this.width) || mouseY < (double)this.y || mouseY > (double)(this.y + this.height)) {
            return false;
        }
        double adjY = mouseY + (double)this.scrollOffset;
        for (Map.Entry<String, ClickRegion> e : this.toggleRegions.entrySet()) {
            if (!e.getValue().contains(mouseX, adjY)) continue;
            String key = e.getKey();
            boolean expand = this.collapsed.contains(key);
            if (class_437.method_25442()) {
                this.toggleSubtree(key, expand);
            } else if (expand) {
                this.collapsed.remove(key);
            } else {
                this.collapsed.add(key);
            }
            if (this.isLocked) {
                MineboxAdditions.INSTANCE.state.setLockedCollapsedKeys(new HashSet<String>(this.collapsed));
            }
            return true;
        }
        for (ClickRegionUsedIn ui : this.usedInRegions) {
            if (!ui.region.contains(mouseX, adjY)) continue;
            this.preloadTextures(ui.target);
            if (this.onNavigate != null) {
                this.onNavigate.accept(ui.target);
            }
            this.pendingScrollOffset = 0;
            return true;
        }
        return false;
    }

    private void toggleSubtree(String rootKey, boolean expand) {
        if (expand) {
            this.collapsed.remove(rootKey);
            this.collapsed.removeIf(k -> k.startsWith(rootKey + ">"));
        } else {
            this.collapsed.add(rootKey);
        }
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void setControlsVisible(boolean visible) {
        if (this.quantityField != null) {
            this.quantityField.method_1862(visible);
        }
        if (this.lockButton != null) {
            this.lockButton.field_22764 = visible;
        }
        if (this.clipboardButton != null) {
            this.clipboardButton.field_22764 = visible;
        }
    }

    private void preloadTextures(MineboxItem item) {
        if (item == null) {
            return;
        }
        ItemListWidget.ItemEntry.getTextureCache().computeIfAbsent(item.getId(), id -> ItemListWidget.ItemEntry.loadTexture(item.getId(), item.getTexture()));
        if (item.getRecipe() != null && item.getRecipe().getIngredients() != null) {
            for (MineboxItem.Ingredient ing : item.getRecipe().getIngredients()) {
                this.preloadIngredientTextures(ing);
            }
        }
    }

    private void preloadIngredientTextures(MineboxItem.Ingredient ing) {
        if (ing.isVanilla()) {
            class_2960 vanillaId = class_2960.method_60655((String)"minecraft", (String)("textures/item/" + ing.getId() + ".png"));
            ItemListWidget.ItemEntry.getTextureCache().putIfAbsent(ing.getId(), vanillaId);
            return;
        }
        MineboxItem sub = ing.getCustomItem();
        if (sub != null) {
            ItemListWidget.ItemEntry.getTextureCache().computeIfAbsent(sub.getId(), id -> ItemListWidget.ItemEntry.loadTexture(sub.getId(), sub.getTexture()));
            if (sub.getRecipe() != null && sub.getRecipe().getIngredients() != null) {
                for (MineboxItem.Ingredient subIng : sub.getRecipe().getIngredients()) {
                    this.preloadIngredientTextures(subIng);
                }
            }
        }
    }

    private void preloadUsedInTextures(MineboxItem item) {
        if (item == null) {
            return;
        }
        if (item.getId().equals(this.lastPreloadedItemId)) {
            return;
        }
        this.lastPreloadedItemId = item.getId();
        List usedIn = this.usedInCache.computeIfAbsent(item.getId(), key -> MineboxAdditions.INSTANCE.state.getMbxItems().stream().filter(other -> other.getRecipe() != null && other.getRecipe().getIngredients() != null).filter(other -> other.getRecipe().getIngredients().stream().anyMatch(ing -> !ing.isVanilla() && item.getId().equals(ing.getId()))).toList());
        for (MineboxItem parent : usedIn) {
            ItemListWidget.ItemEntry.getTextureCache().computeIfAbsent(parent.getId(), id -> ItemListWidget.ItemEntry.loadTexture(parent.getId(), parent.getTexture()));
            if (parent.getRecipe() == null || parent.getRecipe().getIngredients() == null) continue;
            for (MineboxItem.Ingredient ing : parent.getRecipe().getIngredients()) {
                this.preloadIngredientTextures(ing);
            }
        }
    }

    private static final class ClickRegionUsedIn {
        final ClickRegion region;
        final MineboxItem target;

        ClickRegionUsedIn(ClickRegion r, MineboxItem t) {
            this.region = r;
            this.target = t;
        }
    }

    private static final class ClickRegion {
        final int x;
        final int y;
        final int w;
        final int h;

        ClickRegion(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        boolean contains(double mx, double my) {
            return mx >= (double)this.x && mx <= (double)(this.x + this.w) && my >= (double)this.y && my <= (double)(this.y + this.h);
        }
    }
}

