/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.harvestable;

import io.dampen59.mineboxadditions.MineboxAdditions;
import io.dampen59.mineboxadditions.config.Config;
import io.dampen59.mineboxadditions.config.other.HarvestablesSettings;
import io.dampen59.mineboxadditions.features.harvestable.Harvestable;
import io.dampen59.mineboxadditions.state.State;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class HarvestableBeam {
    private static final class_2960 BEACON_BEAM_TEXTURE = class_2960.method_60654((String)"textures/entity/beacon_beam.png");

    public static void render(WorldRenderContext context) {
        class_310 mc = class_310.method_1551();
        class_638 world = context.world();
        if (world == null || mc.field_1724 == null) {
            return;
        }
        State state = MineboxAdditions.INSTANCE.state;
        class_2960 worldId = world.method_27983().method_29177();
        String islandKeyPath = worldId.method_12832();
        List<Harvestable> items = state.getMineboxHarvestables(islandKeyPath);
        if ((items == null || items.isEmpty()) && ((items = state.getMineboxHarvestables(worldId.toString())) == null || items.isEmpty())) {
            return;
        }
        HarvestablesSettings.Harvestable prefs = Config.harvestables.harvestables.get(islandKeyPath);
        if (prefs == null) {
            return;
        }
        class_4587 ms = context.matrixStack();
        class_4597 prov = context.consumers();
        if (ms == null || prov == null) {
            return;
        }
        float tickDelta = context.tickCounter().method_60637(false);
        float time = (float)mc.field_1687.method_8510() + tickDelta;
        float scroll = time / 40.0f % 1.0f;
        int rd = (Integer)mc.field_1690.method_42503().method_41753();
        double maxDist = rd * 16 + 64;
        double maxDistSq = maxDist * maxDist;
        class_243 cam = context.camera().method_19326();
        ms.method_22903();
        ms.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);
        for (Harvestable it : items) {
            int z;
            double dz;
            int y;
            double dy;
            int x;
            double dx;
            boolean itemOn;
            String name;
            String cat = it.getCategory() != null ? it.getCategory() : "misc";
            String string = name = it.getName() != null ? it.getName() : "unknown";
            boolean catOn = prefs.categories.getOrDefault(cat, false);
            if (!catOn || !(itemOn = prefs.items.getOrDefault(cat, Collections.emptyMap()).getOrDefault(name, false).booleanValue())) continue;
            int rgb = prefs.colors.getOrDefault(cat, Collections.emptyMap()).getOrDefault(name, -1);
            List<Double> c = it.getCoordinates();
            if (c == null || c.size() < 3 || (dx = (double)(x = (int)Math.round(c.get(0))) + 0.5 - cam.field_1352) * dx + (dy = (double)(y = (int)Math.round(c.get(1))) - cam.field_1351) * dy + (dz = (double)(z = (int)Math.round(c.get(2))) + 0.5 - cam.field_1350) * dz > maxDistSq) continue;
            class_243 playerPos = mc.field_1724.method_19538();
            double ndx = (double)x + 0.5 - playerPos.field_1352;
            double ndy = (double)y - playerPos.field_1351;
            double ndz = (double)z + 0.5 - playerPos.field_1350;
            if (ndx * ndx + ndy * ndy + ndz * ndz < 16.0) continue;
            HarvestableBeam.drawBeaconBeam(ms, prov, new class_2338(x, y, z), 192, 0.35f, scroll, rgb);
        }
        ms.method_22909();
    }

    private static void drawBeaconBeam(class_4587 ms, class_4597 prov, class_2338 base, int height, float radiusIgnored, float vOffset, int rgb) {
        class_4588 vc = prov.getBuffer(class_1921.method_23592((class_2960)BEACON_BEAM_TEXTURE, (boolean)true));
        Matrix4f m = ms.method_23760().method_23761();
        float cx = (float)base.method_10263() + 0.5f;
        float cz = (float)base.method_10260() + 0.5f;
        float y0 = base.method_10264();
        float y1 = y0 + (float)height;
        float innerR = 0.2f;
        float outerR = 0.25f;
        float rot = (float)((double)vOffset * Math.PI * 2.0);
        float sin = (float)Math.sin(rot);
        float cos = (float)Math.cos(rot);
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = vOffset;
        float v1 = vOffset + (float)height / 32.0f;
        int cr = rgb >> 16 & 0xFF;
        int cg = rgb >> 8 & 0xFF;
        int cb = rgb & 0xFF;
        float[][] inner = new float[4][2];
        float[][] outer = new float[4][2];
        HarvestableBeam.fillRotatedSquare(inner, 0.2f, cos, sin);
        HarvestableBeam.fillRotatedSquare(outer, 0.25f, cos, sin);
        int aInner = 200;
        for (int i = 0; i < 4; ++i) {
            int j = i + 1 & 3;
            HarvestableBeam.addBeamSide(vc, m, cx + inner[i][0], cz + inner[i][1], cx + inner[j][0], cz + inner[j][1], y0, y1, 0.0f, v0, 1.0f, v1, cr, cg, cb, 200);
        }
        int aOuter = 64;
        for (int i = 0; i < 4; ++i) {
            int j = i + 1 & 3;
            HarvestableBeam.addBeamSide(vc, m, cx + outer[i][0], cz + outer[i][1], cx + outer[j][0], cz + outer[j][1], y0, y1, 0.0f, v0, 1.0f, v1, cr, cg, cb, 64);
        }
    }

    private static void fillRotatedSquare(float[][] out, float r, float cos, float sin) {
        float[][] base = new float[][]{{r, -r}, {r, r}, {-r, r}, {-r, -r}};
        for (int i = 0; i < 4; ++i) {
            float x = base[i][0];
            float z = base[i][1];
            out[i][0] = x * cos - z * sin;
            out[i][1] = x * sin + z * cos;
        }
    }

    private static void addBeamSide(class_4588 vc, Matrix4f m, float x0, float z0, float x1, float z1, float y0, float y1, float u0, float v0, float u1, float v1, int r, int g, int b, int a) {
        int light = 0xF000F0;
        vc.method_22918(m, x0, y0, z0).method_1336(r, g, b, a).method_22913(u0, v1).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(m, x1, y0, z1).method_1336(r, g, b, a).method_22913(u1, v1).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(m, x1, y1, z1).method_1336(r, g, b, a).method_22913(u1, v0).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(m, x0, y1, z0).method_1336(r, g, b, a).method_22913(u0, v0).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
    }
}

