/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.shop;

import io.dampen59.mineboxadditions.MineboxAdditions;
import io.dampen59.mineboxadditions.features.hud.HudManager;
import io.dampen59.mineboxadditions.features.hud.elements.TextElement;
import io.dampen59.mineboxadditions.features.hud.huds.ShopHud;
import io.dampen59.mineboxadditions.features.shop.MineboxToast;
import io.dampen59.mineboxadditions.features.shop.Shop;
import io.dampen59.mineboxadditions.utils.SocketManager;
import io.dampen59.mineboxadditions.utils.Utils;
import java.time.LocalTime;
import java.util.Arrays;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_368;
import net.minecraft.class_5250;

public class ShopManager {
    private static final MermaidItemOffer mermaid = new MermaidItemOffer();

    public static MermaidItemOffer getMermaid() {
        return mermaid;
    }

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(ShopManager::tick);
        SocketManager.getSocket().on("S2CShopOfferEvent", ShopManager::update);
    }

    private static void tick(class_310 client) {
        if (!Utils.isOnMinebox() || client.field_1687 == null) {
            return;
        }
        if (Utils.getTime() == LocalTime.MIDNIGHT) {
            return;
        }
        TextElement text = HudManager.INSTANCE.get(ShopHud.class).getNamedElement("text", TextElement.class);
        boolean allClosed = true;
        for (Shop shop : Shop.values()) {
            if (shop.isOpen()) {
                allClosed = false;
                if (!shop.isEnabled()) continue;
                if (!shop.isAlerted()) {
                    ShopManager.showToast(shop);
                    shop.setAlerted(true);
                }
                text.setText(class_2561.method_30163((String)(shop.getName().getString() + (String)(shop.getOffer() != null ? ": " + shop.getOffer().getString() : ""))));
                continue;
            }
            shop.reset();
        }
        if (allClosed) {
            text.setText((class_2561)class_2561.method_43471((String)"mineboxadditions.shop.all_closed"));
        }
    }

    private static void update(Object[] args) {
        String shopName = (String)args[0];
        String itemName = (String)args[1];
        Shop shop = Arrays.stream(Shop.values()).filter(s -> s.name().equalsIgnoreCase(shopName)).findFirst().orElse(null);
        if (shop != null && shop.getOffer() == null) {
            shop.setOffer(itemName);
            ShopManager.showToast(shop, shop.getOffer());
        }
    }

    public static void reset() {
        for (Shop shop : Shop.values()) {
            shop.reset();
        }
    }

    public static void showToast(Shop shop) {
        ShopManager.showToast(shop, null);
    }

    public static void showToast(Shop shop, class_2561 offer) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return;
        }
        class_5250 text = offer != null ? class_2561.method_43469((String)("mineboxadditions." + shop.name().toLowerCase() + ".toast.offer"), (Object[])new Object[]{offer}) : class_2561.method_43471((String)("mineboxadditions." + shop.name().toLowerCase() + ".toast"));
        client.method_1566().method_1999((class_368)new MineboxToast(client.field_1772, MineboxAdditions.id("textures/gui/toasts/" + shop.name().toLowerCase() + ".png"), shop.getName(), (class_2561)text));
        client.field_1724.method_5783(class_3417.field_17265, 1.0f, 1.0f);
    }

    public static class MermaidItemOffer {
        public int quantity = 0;
        public String itemTranslationKey = null;
        public String itemTranslationKeyArgs = null;

        public void set(int qty, String key, String args) {
            this.quantity = qty;
            this.itemTranslationKey = key;
            this.itemTranslationKeyArgs = args;
        }
    }
}

