/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.mixins;

import io.dampen59.mineboxadditions.utils.Utils;
import io.dampen59.mineboxadditions.utils.models.Skill;
import io.dampen59.mineboxadditions.utils.models.SkillData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={class_1259.class})
public abstract class BossBarMixin {
    @Unique
    private static final Pattern ZONE_PATTERN = Pattern.compile("\ub06b\\s*([^\uf833]+?)\uf833");
    @Unique
    private static final Pattern TIME_PATTERN = Pattern.compile("\ub06a\\s*([^\uf833]+?)\uf833");
    @Unique
    private static final Pattern SKILL_PATTERN = Pattern.compile("^(.+?)\\s*\\|\\s*.*?(\\d+)\\s*\\((\\d+)\\s*/\\s*(\\d+)\\)$");

    @Inject(method={"setName"}, at={@At(value="HEAD")})
    private void mbx$setName(class_2561 name, CallbackInfo ci) {
        Matcher matcher;
        Matcher timeMatch = TIME_PATTERN.matcher(name.getString());
        if (timeMatch.find()) {
            Utils.updateTime(timeMatch.group(1));
        }
        if ((matcher = SKILL_PATTERN.matcher(name.getString())).find()) {
            for (Skill skill : Skill.values()) {
                if (!skill.getName().getString().equals(matcher.group(1))) continue;
                SkillData data = Utils.getSkill(skill);
                data.setLevel(Integer.parseInt(matcher.group(2)));
                data.setCurrentXp(Integer.parseInt(matcher.group(3)));
                data.setMaxXP(Integer.parseInt(matcher.group(4)));
                break;
            }
        }
    }
}

